/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.gradle.PredefInputSupplier;
import net.minecraftforge.gradle.SequencedInputSupplier;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExtractS2SRangeTask
extends DefaultTask {
    @InputFiles
    private FileCollection libs;
    private DelayedFile projectFile;
    private String projectConfig;
    private boolean includeJar = false;
    private final List<DelayedFile> in = new LinkedList<DelayedFile>();
    @OutputFile
    private DelayedFile rangeMap;
    private boolean allCached = false;
    private static final Pattern FILE_FROM = Pattern.compile((String)"\\s+@\\|([\\w\\d/.]+)\\|.*$");
    private static final Pattern FILE_START = Pattern.compile((String)"\\s*Class Start\\: ([\\w\\d.]+)$");

    @TaskAction
    public void doTask() throws IOException {
        SequencedInputSupplier inSup;
        List<File> ins = this.getIn();
        File rangemap = this.getRangeMap();
        if (ins.size() == 0) {
            return;
        }
        if (ins.size() == 1) {
            inSup = this.getInput(ins.get(0));
        } else {
            inSup = new SequencedInputSupplier();
            for (File f : ins) {
                inSup.add(this.getInput(f));
            }
        }
        inSup = this.cacheInputs(inSup, rangemap);
        if (rangemap.exists()) {
            if (this.allCached) {
                return;
            }
            List files = inSup.gatherAll(".java");
            List lines = Files.readLines((File)rangemap, (Charset)Charsets.UTF_8);
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                Matcher match;
                String line = (String)it.next();
                String fileMatch = null;
                if (line.trim().startsWith("@")) {
                    match = FILE_FROM.matcher((CharSequence)line);
                    if (match.matches()) {
                        fileMatch = match.group(1).replace('\\', '/');
                    }
                } else {
                    match = FILE_START.matcher((CharSequence)line);
                    if (match.matches()) {
                        fileMatch = match.group(1).replace('.', '/') + ".java";
                    }
                }
                if (fileMatch == null || !files.contains(fileMatch)) continue;
                it.remove();
            }
            this.generateRangeMap(inSup, rangemap);
            lines.addAll(Files.readLines((File)rangemap, (Charset)Charsets.UTF_8));
            Files.write((CharSequence)Joiner.on((String)Constants.NEWLINE).join((Iterable)lines), (File)rangemap, (Charset)Charsets.UTF_8);
        } else {
            this.generateRangeMap(inSup, rangemap);
        }
    }

    private InputSupplier cacheInputs(InputSupplier input, File out) throws IOException {
        boolean outExists = out.exists();
        File cacheFile = new File(out + ".inputCache");
        HashSet<CacheEntry> cache = this.readCache(cacheFile);
        List strings = input.gatherAll(".java");
        HashSet genCache = Sets.newHashSetWithExpectedSize((int)strings.size());
        PredefInputSupplier predef = new PredefInputSupplier();
        for (String rel : strings) {
            File root = new File(input.getRoot(rel)).getCanonicalFile();
            InputStream fis = input.getInput(rel);
            byte[] array = ByteStreams.toByteArray((InputStream)fis);
            fis.close();
            CacheEntry entry = new CacheEntry(rel, root, Constants.hash(array));
            genCache.add(entry);
            if (outExists && cache.contains(entry)) continue;
            predef.addFile(rel, root, array);
        }
        if (!predef.isEmpty()) {
            this.writeCache(cacheFile, genCache);
        } else {
            this.allCached = true;
        }
        return predef;
    }

    private HashSet<CacheEntry> readCache(File cacheFile) throws IOException {
        if (!cacheFile.exists()) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        List lines = Files.readLines((File)cacheFile, (Charset)Charsets.UTF_8);
        HashSet cache = Sets.newHashSetWithExpectedSize((int)lines.size());
        for (String s : lines) {
            String[] tokens = s.split(";");
            if (tokens.length != 3) {
                this.getLogger().info("Corrupted input cache! {}", (Object)cacheFile);
                break;
            }
            cache.add(new CacheEntry(tokens[0], new File(tokens[1]), tokens[2]));
        }
        return cache;
    }

    private void writeCache(File cacheFile, Collection<CacheEntry> cache) throws IOException {
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        cacheFile.getParentFile().mkdirs();
        cacheFile.createNewFile();
        BufferedWriter writer = Files.newWriter((File)cacheFile, (Charset)Charsets.UTF_8);
        for (CacheEntry e : cache) {
            writer.write(e.toString());
            writer.newLine();
        }
        writer.close();
    }

    private void generateRangeMap(InputSupplier inSup, File rangeMap) {
        RangeExtractor extractor = new RangeExtractor();
        extractor.addLibs(this.getLibs().getAsPath()).setSrc(inSup);
        PrintStream stream = new PrintStream(Constants.createLogger(this.getLogger(), LogLevel.DEBUG));
        extractor.setOutLogger(stream);
        boolean worked = extractor.generateRangeMap(rangeMap);
        stream.close();
        if (!worked) {
            throw new RuntimeException("RangeMap generation Failed!!!");
        }
    }

    private InputSupplier getInput(File f) throws IOException {
        if (f.isDirectory()) {
            return new FolderSupplier(f);
        }
        if (f.getPath().endsWith(".jar") || f.getPath().endsWith(".zip")) {
            ZipInputSupplier supp = new ZipInputSupplier();
            supp.readZip(f);
            return supp;
        }
        throw new IllegalArgumentException("Can only make suppliers out of directories and zips right now!");
    }

    public File getRangeMap() {
        return this.rangeMap.call();
    }

    public void setRangeMap(DelayedFile out) {
        this.rangeMap = out;
    }

    @InputFiles
    public FileCollection getIns() {
        return this.getProject().files(new Object[]{this.in});
    }

    public List<File> getIn() {
        LinkedList<File> files = new LinkedList<File>();
        for (DelayedFile f : this.in) {
            files.add(f.call());
        }
        return files;
    }

    public void addIn(DelayedFile in) {
        this.in.add(in);
    }

    public FileCollection getLibs() {
        if (this.projectFile != null && this.libs == null) {
            File buildscript = this.projectFile.call();
            if (!buildscript.exists()) {
                return null;
            }
            Project proj = BasePlugin.getProject(buildscript, this.getProject());
            this.libs = proj.getConfigurations().getByName(this.projectConfig);
            if (this.includeJar) {
                AbstractTask jarTask = (AbstractTask)proj.getTasks().getByName("jar");
                this.executeTask(jarTask);
                File compiled = (File)jarTask.property("archivePath");
                this.libs = this.getProject().files(new Object[]{compiled, this.libs});
            }
        }
        return this.libs;
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    public void setLibs(FileCollection libs) {
        this.libs = libs;
    }

    public void setLibsFromProject(DelayedFile buildscript, String config, boolean includeJar) {
        this.projectFile = buildscript;
        this.projectConfig = config;
        this.includeJar = includeJar;
    }

    private static class CacheEntry {
        public final String path;
        public final String hash;
        public final File root;

        public CacheEntry(String path, File root, String hash) throws IOException {
            this.path = path.replace('\\', '/');
            this.hash = hash;
            this.root = root.getCanonicalFile();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            if (this.hash == null ? other.hash != null : !this.hash.equals(other.hash)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return !(this.root == null ? other.root != null : !this.root.getAbsolutePath().equals(other.root.getAbsolutePath()));
        }

        public String toString() {
            return "" + this.path + ";" + this.root + ";" + this.hash;
        }
    }
}

