/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.io.ByteStreams;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.apache.shiro.util.AntPathMatcher;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class ExtractConfigTask
extends CachedTask {
    private final AntPathMatcher antMatcher = new AntPathMatcher();
    @Input
    private String config;
    @Input
    private List<String> excludes = new LinkedList<String>();
    @Input
    private List<Closure<Boolean>> excludeCalls = new LinkedList<Closure<Boolean>>();
    @Input
    private List<String> includes = new LinkedList<String>();
    @OutputDirectory
    private DelayedFile out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void doTask() throws ZipException, IOException {
        File outDir = this.getOut();
        outDir.mkdirs();
        for (File source : this.getConfigFiles()) {
            this.getLogger().debug("Extracting: " + source);
            ZipFile input = new ZipFile(source);
            try {
                Enumeration<? extends ZipEntry> itr = input.entries();
                while (itr.hasMoreElements()) {
                    ZipEntry entry = itr.nextElement();
                    if (!this.shouldExtract(entry.getName())) continue;
                    File outFile = new File(outDir, entry.getName());
                    this.getLogger().debug("  " + outFile);
                    if (entry.isDirectory()) continue;
                    File outParent = outFile.getParentFile();
                    if (!outParent.exists()) {
                        outParent.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(outFile);
                    InputStream ins = input.getInputStream(entry);
                    ByteStreams.copy((InputStream)ins, (OutputStream)fos);
                    fos.close();
                    ins.close();
                }
            }
            finally {
                input.close();
            }
        }
    }

    private boolean shouldExtract(String path) {
        for (String string : this.excludes) {
            if (!this.antMatcher.matches(string, path)) continue;
            return false;
        }
        for (Closure closure : this.excludeCalls) {
            if (!((Boolean)closure.call((Object)path)).booleanValue()) continue;
            return false;
        }
        for (String string : this.includes) {
            if (!this.antMatcher.matches(string, path)) continue;
            return true;
        }
        return this.includes.size() == 0;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @Optional
    @InputFiles
    public FileCollection getConfigFiles() {
        return this.getProject().getConfigurations().getByName(this.config);
    }

    public File getOut() {
        return this.out.call();
    }

    public void setOut(DelayedFile out) {
        this.out = out;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public ExtractConfigTask include(String ... paterns) {
        for (String patern : paterns) {
            this.includes.add(patern);
        }
        return this;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public ExtractConfigTask exclude(String ... paterns) {
        for (String patern : paterns) {
            this.excludes.add(patern);
        }
        return this;
    }

    public List<Closure<Boolean>> getExcludeCalls() {
        return this.excludeCalls;
    }

    public void exclude(Closure<Boolean> c) {
        this.excludeCalls.add(c);
    }

    @Override
    protected boolean defaultCache() {
        return false;
    }
}

