/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.json.version;

import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.json.version.Action;
import net.minecraftforge.gradle.json.version.ExtractRule;
import net.minecraftforge.gradle.json.version.OS;
import net.minecraftforge.gradle.json.version.OSRule;

public class Library {
    public String name;
    public List<OSRule> rules;
    public Map<OS, String> natives;
    public ExtractRule extract;
    private String url;
    private Action _applies = null;
    private Artifact _artifact = null;

    public boolean applies() {
        if (this._applies == null) {
            this._applies = Action.DISALLOW;
            if (this.rules == null) {
                this._applies = Action.ALLOW;
            } else {
                for (OSRule rule : this.rules) {
                    if (!rule.applies()) continue;
                    this._applies = rule.action;
                }
            }
        }
        return this._applies == Action.ALLOW;
    }

    public String getPath() {
        if (this._artifact == null) {
            this._artifact = new Artifact(this.name);
        }
        return this._artifact.getPath();
    }

    public String getPathNatives() {
        if (this.natives == null) {
            return null;
        }
        if (this._artifact == null) {
            this._artifact = new Artifact(this.name);
        }
        return this._artifact.getPath(this.natives.get((Object)OS.CURRENT));
    }

    public String getArtifactName() {
        if (this._artifact == null) {
            this._artifact = new Artifact(this.name);
        }
        if (this.natives == null) {
            return this._artifact.getArtifact();
        }
        return this._artifact.getArtifact(this.natives.get((Object)OS.CURRENT));
    }

    public String getUrl() {
        return this.url == null ? "https://libraries.minecraft.net/" : this.url;
    }

    public String toString() {
        return this.name;
    }

    private class Artifact {
        private String domain;
        private String name;
        private String version;
        private String classifier;
        private String ext = "jar";

        public Artifact(String rep) {
            String[] pts = rep.split(":");
            int idx = pts[pts.length - 1].indexOf(64);
            if (idx != -1) {
                this.ext = pts[pts.length - 1].substring(idx + 1);
                pts[pts.length - 1] = pts[pts.length - 1].substring(0, idx);
            }
            this.domain = pts[0];
            this.name = pts[1];
            this.version = pts[2];
            if (pts.length > 3) {
                this.classifier = pts[3];
            }
        }

        public String getArtifact() {
            return this.getArtifact(this.classifier);
        }

        public String getArtifact(String classifier) {
            String ret = this.domain + ":" + this.name + ":" + this.version;
            if (classifier != null && classifier.indexOf(36) > -1) {
                classifier = classifier.replace("${arch}", Constants.SYSTEM_ARCH.toString());
            }
            if (classifier != null) {
                ret = ret + ":" + classifier;
            }
            if (!"jar".equals(this.ext)) {
                ret = ret + "@" + this.ext;
            }
            return ret;
        }

        public String getPath() {
            return this.getPath(this.classifier);
        }

        public String getPath(String classifier) {
            String ret = String.format("%s/%s/%s/%s-%s", this.domain.replace('.', '/'), this.name, this.version, this.name, this.version);
            if (classifier != null && classifier.indexOf(36) > -1) {
                classifier = classifier.replace("${arch}", Constants.SYSTEM_ARCH.toString());
            }
            if (classifier != null) {
                ret = ret + "-" + classifier;
            }
            return ret + "." + this.ext;
        }
    }
}

