/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.extrastuff;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.common.Constants;

public class FFPatcher {
    static final String MODIFIERS = "public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp";
    private static final Pattern SYNTHETICS = Pattern.compile((String)"(?m)(\\s*// \\$FF: (synthetic|bridge) method(\\r\\n|\\n|\\r)){1,2}\\s*(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<return>.+?) (?<method>.+?)\\((?<arguments>.*)\\)\\s*\\{(\\r\\n|\\n|\\r)\\s*return this\\.(?<method2>.+?)\\((?<arguments2>.*)\\);(\\r\\n|\\n|\\r)\\s*\\}");
    private static final Pattern ABSTRACT = Pattern.compile((String)"(?m)^(?<indent>[ \\t\\f\\v]*)(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<return>[^ ]+) (?<method>func_(?<number>\\d+)_[a-zA-Z_]+)\\((?<arguments>([^ ,]+ var\\d+,? ?)*)\\)(?: throws (?:[\\w$.]+,? ?)+)?;$");
    private static final String TRAILING = "(?m)[ \\t]+$";
    private static final String NEWLINES = "(?m)^(\\r\\n|\\r|\\n){2,}";
    private static final String EMPTY_SUPER = "(?m)^[ \t]+super\\(\\);(\\r\\n|\\n|\\r)";
    private static final String TRAILINGZERO = "([0-9]+\\.[0-9]*[1-9])0+([DdFfEe])";
    private static final String CLASS_REGEX = "(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<type>enum|class|interface) (?<name>[\\w$]+)(?: (extends|implements) (?:[\\w$.]+(?:, [\\w$.]+)*))* \\{";
    private static final String ENUM_ENTRY_REGEX = "(?<name>[\\w$]+)\\(\"(?:[\\w$]+)\", [0-9]+(?:, (?<body>.*?))?\\)(?<end> *(?:;|,|\\{)$)";
    private static final String CONSTRUCTOR_REGEX = "(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)%s\\((?<parameters>.*?)\\)(?<end>(?: throws (?<throws>[\\w$.]+(?:, [\\w$.]+)*))? *(?:\\{\\}| \\{))";
    private static final String CONSTRUCTOR_CALL_REGEX = "(?<name>this|super)\\((?<body>.*?)\\)(?<end>;)";
    private static final String VALUE_FIELD_REGEX = "private static final %s\\[\\] [$\\w\\d]+ = new %s\\[\\]\\{.*?\\};";

    public static String processFile(String fileName, String text, boolean fixInterfaces) throws IOException {
        StringBuffer out = new StringBuffer();
        Matcher m = SYNTHETICS.matcher((CharSequence)text);
        while (m.find()) {
            m.appendReplacement(out, FFPatcher.synthetic_replacement(m).replace("$", "\\$"));
        }
        m.appendTail(out);
        text = out.toString();
        text = text.replaceAll(TRAILING, "");
        text = text.replaceAll(TRAILINGZERO, "$1$2");
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll((Collection<String>)StringUtils.lines(text));
        FFPatcher.processClass(lines, "", 0, "", "");
        text = Joiner.on((String)Constants.NEWLINE).join(lines);
        text = text.replaceAll(NEWLINES, Constants.NEWLINE);
        text = text.replaceAll(EMPTY_SUPER, "");
        if (fixInterfaces) {
            out = new StringBuffer();
            m = ABSTRACT.matcher((CharSequence)text);
            while (m.find()) {
                m.appendReplacement(out, FFPatcher.abstract_replacement(m).replace("$", "\\$"));
            }
            m.appendTail(out);
            text = out.toString();
        }
        return text;
    }

    private static int processClass(List<String> lines, String indent, int startIndex, String qualifiedName, String simpleName) {
        Pattern classPattern = Pattern.compile((String)(indent + CLASS_REGEX));
        for (int i = startIndex; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (Strings.isNullOrEmpty((String)line) || line.startsWith("package") || line.startsWith("import")) continue;
            Matcher matcher = classPattern.matcher((CharSequence)line);
            if (matcher.find()) {
                String newIndent;
                String classPath;
                if (Strings.isNullOrEmpty((String)qualifiedName)) {
                    classPath = matcher.group("name");
                    newIndent = indent;
                } else {
                    classPath = qualifiedName + "." + matcher.group("name");
                    newIndent = indent + "   ";
                }
                if (matcher.group("type").equals("enum")) {
                    FFPatcher.processEnum(lines, newIndent, i + 1, classPath, matcher.group("name"));
                }
                i = FFPatcher.processClass(lines, newIndent, i + 1, classPath, matcher.group("name"));
            }
            if (!line.startsWith(indent + "}")) continue;
            return i;
        }
        return 0;
    }

    private static void processEnum(List<String> lines, String indent, int startIndex, String qualifiedName, String simpleName) {
        String newIndent = indent + "   ";
        Pattern enumEntry = Pattern.compile((String)(newIndent + ENUM_ENTRY_REGEX));
        Pattern constructor = Pattern.compile((String)(newIndent + String.format(CONSTRUCTOR_REGEX, simpleName)));
        Pattern constructorCall = Pattern.compile((String)(newIndent + "   " + CONSTRUCTOR_CALL_REGEX));
        String formatted = newIndent + String.format(VALUE_FIELD_REGEX, qualifiedName, qualifiedName);
        Pattern valueField = Pattern.compile((String)formatted);
        boolean prevSynthetic = false;
        for (int i = startIndex; i < lines.size(); ++i) {
            Object[] args;
            String body;
            String newLine = null;
            String line = lines.get(i);
            Matcher matcher = enumEntry.matcher((CharSequence)line);
            if (matcher.find()) {
                body = matcher.group("body");
                newLine = newIndent + matcher.group("name");
                if (!Strings.isNullOrEmpty((String)body)) {
                    args = body.split(", ");
                    if (line.endsWith("{") && ((String)args[args.length - 1]).equals("null")) {
                        args = (String[])Arrays.copyOf(args, args.length - 1);
                    }
                    body = Joiner.on((String)", ").join(args);
                }
                newLine = Strings.isNullOrEmpty((String)body) ? newLine + matcher.group("end") : newLine + "(" + body + ")" + matcher.group("end");
            }
            if ((matcher = constructor.matcher((CharSequence)line)).find()) {
                StringBuilder tmp = new StringBuilder();
                tmp.append(newIndent).append(matcher.group("modifiers")).append(simpleName).append("(");
                args = matcher.group("parameters").split(", ");
                for (int x = 2; x < args.length; ++x) {
                    tmp.append((String)args[x]).append(x < args.length - 1 ? ", " : "");
                }
                tmp.append(")");
                tmp.append(matcher.group("end"));
                newLine = tmp.toString();
                if (args.length <= 2 && newLine.endsWith("}")) {
                    newLine = "";
                }
            }
            if ((matcher = constructorCall.matcher((CharSequence)line)).find()) {
                body = matcher.group("body");
                if (!Strings.isNullOrEmpty((String)body)) {
                    args = body.split(", ");
                    args = (String[])Arrays.copyOfRange(args, 2, args.length);
                    body = Joiner.on((String)", ").join(args);
                }
                newLine = newIndent + "   " + matcher.group("name") + "(" + body + ")" + matcher.group("end");
            }
            if (prevSynthetic && (matcher = valueField.matcher((CharSequence)line)).find()) {
                newLine = "";
            }
            if (line.contains("// $FF: synthetic field")) {
                newLine = "";
                prevSynthetic = true;
            } else {
                prevSynthetic = false;
            }
            if (newLine != null) {
                lines.set(i, newLine);
            }
            if (line.startsWith(indent + "}")) break;
        }
    }

    private static String synthetic_replacement(Matcher match) {
        String arg2;
        if (!match.group("method").equals(match.group("method2"))) {
            return match.group();
        }
        String arg1 = match.group("arguments");
        if (arg1.equals(arg2 = match.group("arguments2")) && arg1.equals("")) {
            return "";
        }
        String[] args = match.group("arguments").split(", ");
        for (int x = 0; x < args.length; ++x) {
            args[x] = args[x].split(" ")[1];
        }
        StringBuilder b = new StringBuilder();
        b.append(args[0]);
        for (int x = 1; x < args.length; ++x) {
            b.append(", ").append(args[x]);
        }
        arg1 = b.toString();
        if (arg1.equals(arg2)) {
            return "";
        }
        return match.group();
    }

    private static String abstract_replacement(Matcher match) {
        String orig = match.group("arguments");
        String number = match.group("number");
        if (Strings.isNullOrEmpty((String)orig)) {
            return match.group();
        }
        String[] args = orig.split(", ");
        StringBuilder fixed = new StringBuilder();
        for (int x = 0; x < args.length; ++x) {
            String[] p = args[x].split(" ");
            fixed.append(p[0]).append(" p_").append(number).append('_').append(p[1].substring(3)).append('_');
            if (x == args.length - 1) continue;
            fixed.append(", ");
        }
        return match.group().replace(orig, fixed.toString());
    }
}

