/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user.patch;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.delayed.DelayedObject;
import net.minecraftforge.gradle.user.UserExtension;
import net.minecraftforge.gradle.user.patch.UserPatchBasePlugin;
import org.gradle.api.ProjectConfigurationException;

public class UserPatchExtension
extends UserExtension {
    private static final Pattern VERSION_CHECK = Pattern.compile("([\\d._pre]+)-([\\w\\d.]+)(?:-[\\w\\d.]+)?");
    private int maxFuzz = 0;
    private String apiVersion;
    private ArrayList<Object> ats = new ArrayList();

    public UserPatchExtension(UserPatchBasePlugin plugin) {
        super(plugin);
    }

    public void accessT(Object obj) {
        this.at(obj);
    }

    public void accessTs(Object ... obj) {
        this.ats(obj);
    }

    public void accessTransformer(Object obj) {
        this.at(obj);
    }

    public void accessTransformers(Object ... obj) {
        this.ats(obj);
    }

    public void at(Object obj) {
        this.ats.add(obj);
    }

    public void ats(Object ... obj) {
        for (Object object : obj) {
            this.ats.add((Object)new DelayedObject(object, this.project));
        }
    }

    public List<Object> getAccessTransformers() {
        return this.ats;
    }

    @Override
    public void setVersion(String str) {
        Matcher matcher = VERSION_CHECK.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(str + " is not in the form 'MCVersion-apiVersion-branch'!");
        }
        this.version = matcher.group(1).replace('_', '-');
        this.apiVersion = matcher.group(0);
    }

    public String getApiVersion() {
        if (this.apiVersion == null) {
            throw new ProjectConfigurationException("You must set the Minecraft Version!", (Throwable)new NullPointerException());
        }
        return this.apiVersion;
    }

    public int getMaxFuzz() {
        return this.maxFuzz;
    }

    public void setMaxFuzz(int fuzz) {
        this.maxFuzz = fuzz;
    }
}

