/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class VersionJsonTask
extends DefaultTask {
    private static final Gson GSON_FORMATTER = new GsonBuilder().setPrettyPrinting().create();
    @InputFile
    DelayedFile input;
    @OutputFile
    DelayedFile output;

    @TaskAction
    public void doTask() throws IOException {
        String data = Files.toString((File)this.getInput(), (Charset)Charsets.UTF_8);
        Map json = (Map)new Gson().fromJson(data, Map.class);
        json = (Map)json.get("versionInfo");
        data = GSON_FORMATTER.toJson((Object)json);
        Files.write((byte[])data.getBytes(), (File)this.getOutput());
    }

    public File getInput() {
        return this.input.call();
    }

    public void setInput(DelayedFile input) {
        this.input = input;
    }

    public File getOutput() {
        return this.output.call();
    }

    public void setOutput(DelayedFile output) {
        this.output = output;
    }
}

