/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.abstractutil;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.gradle.common.Constants;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;

public abstract class CachedTask
extends DefaultTask {
    private boolean doesCache = true;
    private boolean cacheSet = false;
    private final ArrayList<Annotated> cachedList = new ArrayList();
    private final ArrayList<Annotated> inputList = new ArrayList();

    public CachedTask() {
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(Cached.class)) {
                    this.addCachedOutput(new Annotated(clazz, field.getName()));
                }
                if (field.isAnnotationPresent(Excluded.class) || !field.isAnnotationPresent(InputFile.class) && !field.isAnnotationPresent(InputFiles.class) && !field.isAnnotationPresent(InputDirectory.class) && !field.isAnnotationPresent(Input.class)) continue;
                this.inputList.add(new Annotated(clazz, field.getName()));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (accessibleObject.isAnnotationPresent(Cached.class)) {
                    this.addCachedOutput(new Annotated(clazz, ((Method)accessibleObject).getName(), true));
                }
                if (accessibleObject.isAnnotationPresent(Excluded.class) || !accessibleObject.isAnnotationPresent(InputFile.class) && !accessibleObject.isAnnotationPresent(InputFiles.class) && !accessibleObject.isAnnotationPresent(InputDirectory.class) && !accessibleObject.isAnnotationPresent(Input.class)) continue;
                this.inputList.add(new Annotated(clazz, ((Method)accessibleObject).getName(), true));
            }
        }
        this.onlyIf(new Spec(){

            public boolean isSatisfiedBy(Object obj) {
                Task task = (Task)obj;
                if (!CachedTask.this.doesCache()) {
                    return true;
                }
                if (CachedTask.this.cachedList.isEmpty()) {
                    return true;
                }
                for (Annotated field : CachedTask.this.cachedList) {
                    try {
                        File file = CachedTask.this.getProject().file(field.getValue(task));
                        if (!file.exists()) {
                            return true;
                        }
                        File hashFile = CachedTask.this.getHashFile(file);
                        if (!hashFile.exists()) {
                            file.delete();
                            return true;
                        }
                        String foundMD5 = Files.toString((File)CachedTask.this.getHashFile(file), (Charset)Charset.defaultCharset());
                        String calcMD5 = CachedTask.this.getHashes(field, CachedTask.this.inputList, task);
                        if (!calcMD5.equals(foundMD5)) {
                            CachedTask.this.getProject().getLogger().info(" Corrupted Cache!");
                            CachedTask.this.getProject().getLogger().info("Checksums found: " + foundMD5);
                            CachedTask.this.getProject().getLogger().info("Checksums calculated: " + calcMD5);
                            file.delete();
                            CachedTask.this.getHashFile(file).delete();
                            return true;
                        }
                        CachedTask.this.getProject().getLogger().info("Checksums found: " + foundMD5);
                        CachedTask.this.getProject().getLogger().info("Checksums calculated: " + calcMD5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private void addCachedOutput(final Annotated annot) {
        this.cachedList.add(annot);
        this.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                if (!CachedTask.this.doesCache()) {
                    return;
                }
                try {
                    File outFile = CachedTask.this.getProject().file(annot.getValue(task));
                    if (outFile.exists()) {
                        File hashFile = CachedTask.this.getHashFile(outFile);
                        Files.write((CharSequence)CachedTask.this.getHashes(annot, CachedTask.this.inputList, task), (File)hashFile, (Charset)Charset.defaultCharset());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private File getHashFile(File file) {
        if (file.isDirectory()) {
            return new File(file, ".cache");
        }
        return new File(file.getParentFile(), file.getName() + ".md5");
    }

    private String getHashes(Annotated output, List<Annotated> inputs, Object instance) throws NoSuchFieldException, IllegalAccessException, NoSuchAlgorithmException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        LinkedList<String> hashes = new LinkedList<String>();
        hashes.addAll(Constants.hashAll(this.getProject().file(output.getValue(instance))));
        for (Annotated input : inputs) {
            AnnotatedElement m = input.getElement();
            Object val = input.getValue(instance);
            if (val == null && m.isAnnotationPresent(Optional.class)) {
                hashes.add("null");
                continue;
            }
            if (m.isAnnotationPresent(InputFile.class)) {
                hashes.add(Constants.hash(this.getProject().file(input.getValue(instance))));
                this.getLogger().info(Constants.hash(this.getProject().file(input.getValue(instance))) + " " + input.getValue(instance));
                continue;
            }
            if (m.isAnnotationPresent(InputDirectory.class)) {
                File dir = (File)input.getValue(instance);
                hashes.addAll(Constants.hashAll(dir));
                continue;
            }
            if (m.isAnnotationPresent(InputFiles.class)) {
                FileCollection files = (FileCollection)input.getValue(instance);
                for (File file : files.getFiles()) {
                    String hash = Constants.hash(file);
                    hashes.add(hash);
                    this.getLogger().info(hash + " " + input.getValue(instance));
                }
                continue;
            }
            Object obj = input.getValue(instance);
            while (obj instanceof Closure) {
                obj = ((Closure)obj).call();
            }
            if (obj instanceof String) {
                hashes.add(Constants.hash((String)obj));
                this.getLogger().info(Constants.hash((String)obj) + " " + (String)obj);
                continue;
            }
            if (obj instanceof File) {
                File file = (File)obj;
                if (file.isDirectory()) {
                    List<File> files = Arrays.asList(file.listFiles());
                    Collections.sort(files);
                    for (File i : files) {
                        hashes.add(Constants.hash(i));
                        this.getLogger().info(Constants.hash(i) + " " + i);
                    }
                    continue;
                }
                hashes.add(Constants.hash(file));
                this.getLogger().info(Constants.hash(file) + " " + file);
                continue;
            }
            hashes.add(obj.toString());
        }
        return Joiner.on((String)Constants.NEWLINE).join(hashes);
    }

    protected boolean defaultCache() {
        return true;
    }

    public boolean doesCache() {
        if (this.cacheSet) {
            return this.doesCache;
        }
        return this.defaultCache();
    }

    public void setDoesCache(boolean cacheStuff) {
        this.cacheSet = true;
        this.doesCache = cacheStuff;
    }

    private static class Annotated {
        private final Class<? extends Task> taskClass;
        private final String symbolName;
        private final boolean isMethod;

        private Annotated(Class<? extends Task> taskClass, String symbolName, boolean isMethod) {
            this.taskClass = taskClass;
            this.symbolName = symbolName;
            this.isMethod = isMethod;
        }

        private Annotated(Class<? extends Task> taskClass, String fieldName) {
            this.taskClass = taskClass;
            this.symbolName = fieldName;
            this.isMethod = false;
        }

        private AnnotatedElement getElement() throws NoSuchMethodException, SecurityException, NoSuchFieldException {
            if (this.isMethod) {
                return this.taskClass.getDeclaredMethod(this.symbolName, new Class[0]);
            }
            return this.taskClass.getDeclaredField(this.symbolName);
        }

        protected Object getValue(Object instance) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
            Method method;
            if (this.isMethod) {
                method = this.taskClass.getDeclaredMethod(this.symbolName, new Class[0]);
            } else {
                Field f = this.taskClass.getDeclaredField(this.symbolName);
                String methodName = f.getType().equals(Boolean.TYPE) ? "is" : "get";
                char[] name = this.symbolName.toCharArray();
                name[0] = Character.toUpperCase(name[0]);
                methodName = methodName + new String(name);
                try {
                    method = this.taskClass.getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    f.setAccessible(true);
                    return f.get(instance);
                }
            }
            return method.invoke(instance, new Object[0]);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Excluded {
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Cached {
    }
}

