/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public class ReplaceJavadocsTask
extends DefaultTask {
    @InputFiles
    private LinkedList<DelayedFile> inFiles = new LinkedList();
    private DelayedFile outFile;
    @InputFile
    private DelayedFile methodsCsv;
    @InputFile
    private DelayedFile fieldsCsv;
    private final Map<String, Map<String, String>> methods = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> fields = new HashMap<String, Map<String, String>>();
    private static final Pattern METHOD = Pattern.compile("^([ \t]+)// JAVADOC METHOD \\$\\$ (func.+?)$");
    private static final Pattern FIELD = Pattern.compile("^([ \t]+)// JAVADOC FIELD \\$\\$ (field.+?)$");

    @TaskAction
    public void doStuffBefore() throws Throwable {
        this.readCsvs();
        FileCollection in = this.getInFiles();
        File out = this.getOutFile();
        if (in.getFiles().size() == 1 && in.getSingleFile().getName().endsWith("jar")) {
            this.jarMode(in.getSingleFile(), out);
        } else {
            this.dirMode(in.getFiles(), out);
        }
    }

    private void readCsvs() throws IOException {
        HashMap<String, String> temp;
        CSVReader reader = RemapSourcesTask.getReader(this.getMethodsCsv());
        for (String[] s : reader.readAll()) {
            temp = new HashMap<String, String>();
            temp.put("name", s[1]);
            temp.put("javadoc", s[3]);
            this.methods.put(s[0], temp);
        }
        reader = RemapSourcesTask.getReader(this.getFieldsCsv());
        for (String[] s : reader.readAll()) {
            temp = new HashMap();
            temp.put("name", s[1]);
            temp.put("javadoc", s[3]);
            this.fields.put(s[0], temp);
        }
    }

    private void jarMode(File inJar, File outJar) throws IOException {
        if (!outJar.exists()) {
            outJar.getParentFile().mkdirs();
            outJar.createNewFile();
        }
        ZipInputStream zin = new ZipInputStream(new FileInputStream(inJar));
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(outJar));
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.getName().contains("META-INF")) continue;
            if (entry.isDirectory() || !entry.getName().endsWith(".java")) {
                zout.putNextEntry(entry);
                ByteStreams.copy((InputStream)zin, (OutputStream)zout);
                zout.closeEntry();
                continue;
            }
            String fileStr = new String(ByteStreams.toByteArray((InputStream)zin), Charset.defaultCharset());
            fileStr = this.processFile(fileStr);
            zout.putNextEntry(entry);
            zout.write(fileStr.getBytes());
            zout.closeEntry();
        }
        zin.close();
        zout.flush();
        zout.close();
    }

    private void dirMode(Set<File> inDirs, File outDir) throws IOException {
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        for (File inDir : inDirs) {
            ConfigurableFileTree tree = this.getProject().fileTree((Object)inDir);
            for (File file : tree) {
                String text = Files.toString((File)file, (Charset)Charsets.UTF_8);
                text = this.processFile(text);
                File dest = this.getDest(file, inDir, outDir);
                dest.getParentFile().mkdirs();
                dest.createNewFile();
                Files.write((CharSequence)text, (File)dest, (Charset)Charsets.UTF_8);
            }
        }
    }

    private File getDest(File in, File base, File baseOut) throws IOException {
        String relative = in.getCanonicalPath().replace(base.getCanonicalPath(), "");
        return new File(baseOut, relative);
    }

    private String processFile(String text) {
        String prevLine = null;
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : StringUtils.lines(text)) {
            String javadoc;
            String name;
            Matcher matcher = METHOD.matcher(line);
            if (matcher.find() && this.methods.containsKey(name = matcher.group(2)) && this.methods.get(name).containsKey("name")) {
                javadoc = this.methods.get(name).get("javadoc");
                if (Strings.isNullOrEmpty((String)javadoc)) {
                    line = "";
                } else {
                    line = this.buildJavadoc(matcher.group(1), javadoc, true);
                    if (!Strings.isNullOrEmpty((String)prevLine) && !prevLine.endsWith("{")) {
                        line = Constants.NEWLINE + line;
                    }
                }
            }
            if ((matcher = FIELD.matcher(line)).find() && this.fields.containsKey(name = matcher.group(2))) {
                javadoc = this.fields.get(name).get("javadoc");
                if (Strings.isNullOrEmpty((String)javadoc)) {
                    line = "";
                } else {
                    line = this.buildJavadoc(matcher.group(1), javadoc, false);
                    if (!Strings.isNullOrEmpty((String)prevLine) && !prevLine.endsWith("{")) {
                        line = Constants.NEWLINE + line;
                    }
                }
            }
            prevLine = line;
            newLines.add(line);
        }
        return Joiner.on((String)Constants.NEWLINE).join(newLines);
    }

    private String buildJavadoc(String indent, String javadoc, boolean isMethod) {
        StringBuilder builder = new StringBuilder();
        if (javadoc.length() >= 70 || isMethod) {
            List<String> list = ReplaceJavadocsTask.wrapText(javadoc, 120 - (indent.length() + 3));
            builder.append(indent);
            builder.append("/**");
            builder.append(Constants.NEWLINE);
            for (String line : list) {
                builder.append(indent);
                builder.append(" * ");
                builder.append(line);
                builder.append(Constants.NEWLINE);
            }
            builder.append(indent);
            builder.append(" */");
        } else {
            builder.append(indent);
            builder.append("/** ");
            builder.append(javadoc);
            builder.append(" */");
        }
        return builder.toString().replace(indent, indent);
    }

    private static List<String> wrapText(String text, int len) {
        if (text == null) {
            return new ArrayList<String>();
        }
        if (len <= 0) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        if (text.length() <= len) {
            return new ArrayList<String>(Arrays.asList(text));
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == ' ' || c == ',' || c == '-') {
                int tempNum;
                word.append(c);
                int n = tempNum = Character.isWhitespace(c) ? 1 : 0;
                if (line.length() + word.length() - tempNum > len) {
                    lines.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append((CharSequence)word);
                word.delete(0, word.length());
                continue;
            }
            word.append(c);
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        ArrayList<String> temp = new ArrayList<String>(lines.size());
        for (String s : lines) {
            temp.add(s.trim());
        }
        return temp;
    }

    public File getMethodsCsv() {
        return this.methodsCsv.call();
    }

    public void setMethodsCsv(DelayedFile methodsCsv) {
        this.methodsCsv = methodsCsv;
    }

    public File getFieldsCsv() {
        return this.fieldsCsv.call();
    }

    public void setFieldsCsv(DelayedFile fieldsCsv) {
        this.fieldsCsv = fieldsCsv;
    }

    public FileCollection getInFiles() {
        ConfigurableFileCollection collection = this.getProject().files(new Object[0]);
        for (DelayedFile file : this.inFiles) {
            collection = collection.plus((FileCollection)this.getProject().files(new Object[]{file}));
        }
        return collection;
    }

    public void from(DelayedFile file) {
        this.inFiles.add(file);
    }

    public File getOutFile() {
        return this.outFile.call();
    }

    public void setOutFile(DelayedFile outFile) {
        this.outFile = outFile;
    }
}

