/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.json.version.AssetIndex;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class CopyAssetsTask
extends DefaultTask {
    @Input
    Closure<AssetIndex> assetIndex;
    DelayedFile assetsDir;
    @OutputDirectory
    DelayedFile outputDir;

    @TaskAction
    public void doTask() {
        try {
            AssetIndex index = this.getAssetIndex();
            File assetsDir = new File(this.getAssetsDir(), "objects");
            File outputDir = this.getOutputDir();
            int count = 0;
            for (Map.Entry<String, AssetIndex.AssetEntry> e : index.objects.entrySet()) {
                File in = this.getHashedPath(assetsDir, e.getValue().hash);
                File out = new File(outputDir, e.getKey());
                ++count;
                if (out.exists() && out.length() == e.getValue().size) continue;
                out.getParentFile().mkdirs();
                Files.copy((File)in, (File)out);
            }
            this.getLogger().info("Copied " + count + " assets");
        }
        catch (Throwable t) {
            this.getLogger().error("Something went wrong with the assets copying");
            this.setDidWork(false);
            return;
        }
    }

    private File getHashedPath(File base, String hash) {
        return new File(base, hash.substring(0, 2) + "/" + hash);
    }

    public AssetIndex getAssetIndex() {
        return (AssetIndex)this.assetIndex.call();
    }

    public void setAssetIndex(Closure<AssetIndex> assetIndex) {
        this.assetIndex = assetIndex;
    }

    public File getAssetsDir() {
        return this.assetsDir.call();
    }

    public void setAssetsDir(DelayedFile assetsDir) {
        this.assetsDir = assetsDir;
    }

    public File getOutputDir() {
        return this.outputDir.call();
    }

    public void setOutputDir(DelayedFile outputDir) {
        this.outputDir = outputDir;
    }
}

