/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.curseforge;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectIntHashMap;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.json.JsonFactory;
import net.minecraftforge.gradle.json.curse.CurseMetadata;
import net.minecraftforge.gradle.json.curse.CurseReply;
import net.minecraftforge.gradle.json.curse.CurseVersion;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class CurseUploadTask
extends DefaultTask {
    Object projectId;
    Object artifact;
    String apiKey;
    Set<Object> gameVersions = new TreeSet<Object>();
    String releaseType;
    String changelog;
    int fileID;
    private final String UPLOAD_URL = "http://minecraft.curseforge.com/api/projects/%s/upload-file";
    private final String VERSION_URL = "http://minecraft.curseforge.com/api/game/versions";
    private final File VERSION_CACHE = new File(this.getProject().getGradle().getGradleUserHomeDir() + "/caches/minecraft/curseVersions.json");

    @TaskAction
    public void doTask() throws IOException, URISyntaxException {
        CurseMetadata meta = new CurseMetadata();
        meta.releaseType = this.getReleaseType();
        meta.changelog = this.getChangelog() == null ? "" : this.getChangelog();
        meta.gameVersions = this.resolveGameVersion();
        String url = String.format("http://minecraft.curseforge.com/api/projects/%s/upload-file", this.getProjectId());
        if (meta.releaseType == null) {
            throw new IllegalArgumentException("Release type must be defined!");
        }
        this.upload(meta, url, this.getProject().file(this.getArtifact()));
    }

    private void upload(CurseMetadata meta, String strUrl, File artifact) throws IOException, URISyntaxException {
        int fileID;
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(new URI(strUrl));
        String metaJson = JsonFactory.GSON.toJson((Object)meta);
        httpPost.addHeader("X-Api-Token", this.getApiKey());
        httpPost.setEntity(MultipartEntityBuilder.create().addTextBody("metadata", metaJson).addBinaryBody("file", artifact).build());
        this.getLogger().lifecycle("Uploading {} to {}", new Object[]{artifact, strUrl});
        this.getLogger().info("Uploading with meta {}", (Object)metaJson);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            this.getLogger().error("Error code: {}   {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            this.getLogger().error("Maybe your API key or projectID is wrong!");
            return;
        }
        InputStreamReader stream = new InputStreamReader(response.getEntity().getContent());
        this.fileID = fileID = ((CurseReply)JsonFactory.GSON.fromJson((Reader)stream, CurseReply.class)).id;
        stream.close();
        this.getLogger().lifecycle("File uploaded to CurseForge succcesfully with ID {}", new Object[]{fileID});
    }

    private int[] resolveGameVersion() throws IOException {
        String json = this.getWithEtag("http://minecraft.curseforge.com/api/game/versions", this.VERSION_CACHE);
        CurseVersion[] versions = (CurseVersion[])JsonFactory.GSON.fromJson(json, CurseVersion[].class);
        TObjectIntHashMap vMap = new TObjectIntHashMap();
        for (CurseVersion curseVersion : versions) {
            if (curseVersion.gameDependencyID != 0) continue;
            vMap.put((Object)curseVersion.name, curseVersion.id);
        }
        Set<String> gameVersions = this.getGameVersions();
        TIntHashSet out = new TIntHashSet();
        for (String string : gameVersions) {
            if (vMap.containsKey((Object)string)) {
                out.add(vMap.get((Object)string));
                continue;
            }
            throw new IllegalArgumentException(string + " is not a valid game version for CurseForge!");
        }
        if (out.isEmpty()) {
            throw new IllegalArgumentException("No valid game version set for CurseForge upload!");
        }
        return out.toArray();
    }

    private String getWithEtag(String strUrl, File cache) throws IOException {
        URL url = new URL(strUrl);
        File etagFile = this.getProject().file((Object)(cache.getPath() + ".etag"));
        String etag = etagFile.exists() ? Files.toString((File)etagFile, (Charset)Charsets.UTF_8) : "";
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setInstanceFollowRedirects(true);
        con.addRequestProperty("X-Api-Token", this.getApiKey());
        con.setRequestProperty("If-None-Match", etag);
        try {
            con.connect();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        String error = null;
        byte[] stuff = new byte[]{};
        switch (con.getResponseCode()) {
            case 404: {
                error = "" + url + "  404'ed!";
                break;
            }
            case 304: {
                break;
            }
            case 200: {
                InputStream stream = con.getInputStream();
                stuff = ByteStreams.toByteArray((InputStream)stream);
                Files.write((byte[])stuff, (File)cache);
                stream.close();
                break;
            }
            default: {
                error = "Unexpected reponse " + con.getResponseCode() + " from " + url;
            }
        }
        con.disconnect();
        if (error != null) {
            throw new RuntimeException(error);
        }
        return new String(stuff, Charsets.UTF_8);
    }

    private String resolveString(Object obj) {
        while (obj instanceof Closure) {
            obj = ((Closure)obj).call();
        }
        return obj.toString();
    }

    public String getProjectId() {
        this.projectId = this.resolveString(this.projectId);
        return this.projectId;
    }

    public void setProjectId(Object projectId) {
        this.projectId = projectId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String api_key) {
        this.apiKey = api_key;
    }

    public Set<String> getGameVersions() {
        TreeSet<Object> tVersions = new TreeSet<Object>();
        for (Object obj : this.gameVersions) {
            tVersions.add(this.resolveString(obj));
        }
        this.gameVersions = tVersions;
        return tVersions;
    }

    public void addGameVersion(Object gameVersion) {
        this.gameVersions.add(gameVersion);
    }

    public void addGameVersion(Object ... gameVersions) {
        for (Object o : gameVersions) {
            this.gameVersions.add(o);
        }
    }

    public String getReleaseType() {
        return this.releaseType;
    }

    public void setReleaseType(Object releaseType) {
        this.releaseType = StringUtils.lower(this.resolveString(releaseType));
        if (!("alpha".equals(releaseType) || "beta".equals(releaseType) || "release".equals(releaseType))) {
            throw new IllegalArgumentException("The release type must be either 'alpha', 'beta', or 'release'! '" + releaseType + "' is not a valid type!");
        }
    }

    public String getChangelog() {
        return this.changelog;
    }

    public void setChangelog(String changeLog) {
        this.changelog = changeLog;
    }

    public Object getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Object artifact) {
        this.artifact = artifact;
    }

    public int getFileID() {
        return this.fileID;
    }

    public void setFileID(int fileID) {
        this.fileID = fileID;
    }
}

