/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user.lib;

import com.google.common.base.Joiner;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.gradle.common.BaseExtension;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class UserLibBasePlugin
extends UserBasePlugin<UserExtension> {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        Configuration config = (Configuration)this.project.getConfigurations().create(this.actualApiName());
        this.project.getConfigurations().getByName("minecraft").extendsFrom(new Configuration[]{config});
        ((Jar)this.project.getTasks().getByName("jar")).setExtension(this.getJarExtension());
    }

    @Override
    public void applyOverlayPlugin() {
        this.project.getExtensions().create(this.actualApiName(), this.getExtensionClass(), new Object[]{this});
        Configuration config = (Configuration)this.project.getConfigurations().create(this.actualApiName());
        this.project.getConfigurations().getByName("minecraft").extendsFrom(new Configuration[]{config});
        if (this.shouldOverrideRunConfigs()) {
            this.overrideRunConfigs();
        }
        this.configurePackaging();
        this.project.afterEvaluate(new Action(){

            public void execute(Object arg0) {
                UserLibBasePlugin.this.getOverlayExtension().copyFrom((BaseExtension)UserLibBasePlugin.this.otherPlugin.getExtension());
            }
        });
    }

    protected void configurePackaging() {
        String cappedApiName = Character.toUpperCase(this.actualApiName().charAt(0)) + this.actualApiName().substring(1);
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        Jar jarTask = this.makeTask("jar" + cappedApiName, Jar.class);
        jarTask.from(new Object[]{((SourceSet)javaConv.getSourceSets().getByName("main")).getOutput()});
        jarTask.setClassifier(this.actualApiName());
        jarTask.setExtension(this.getJarExtension());
        ((Jar)this.project.getTasks().getByName("jar")).setClassifier(((UserBasePlugin)this.otherPlugin).getApiName());
        ((ReobfTask)this.project.getTasks().getByName("reobf")).reobf((Task)jarTask, new Action<ArtifactSpec>(){

            public void execute(ArtifactSpec spec) {
                spec.setSrgMcp();
                JavaPluginConvention javaConv = (JavaPluginConvention)UserLibBasePlugin.this.project.getConvention().getPlugins().get("java");
                spec.setClasspath(((SourceSet)javaConv.getSourceSets().getByName("main")).getCompileClasspath());
            }
        });
        this.project.getArtifacts().add("archives", (Object)jarTask);
    }

    @Override
    public final boolean canOverlayPlugin() {
        return true;
    }

    public abstract boolean shouldOverrideRunConfigs();

    abstract String actualApiName();

    private void overrideRunConfigs() {
        JavaExec exec = (JavaExec)this.project.getTasks().getByName("runClient");
        exec.setMain(this.getClientRunClass());
        exec.setArgs(this.getClientRunArgs());
        exec = (JavaExec)this.project.getTasks().getByName("runServer");
        exec.setMain(this.getServerRunClass());
        exec.setArgs(this.getServerRunArgs());
        exec = (JavaExec)this.project.getTasks().getByName("debugClient");
        exec.setMain(this.getClientRunClass());
        exec.setArgs(this.getClientRunArgs());
        exec = (JavaExec)this.project.getTasks().getByName("debugServer");
        exec.setMain(this.getServerRunClass());
        exec.setArgs(this.getServerRunArgs());
        IdeaModel ideaConv = (IdeaModel)this.project.getExtensions().getByName("idea");
        Task task = this.project.getTasks().getByName("genIntellijRuns");
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                try {
                    String module = task.getProject().getProjectDir().getCanonicalPath();
                    File file = UserLibBasePlugin.this.project.file((Object)".idea/workspace.xml");
                    if (!file.exists()) {
                        throw new RuntimeException("Only run this task after importing a build.gradle file into intellij!");
                    }
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(file);
                    UserLibBasePlugin.this.overrideIntellijRuns(doc, module);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    DOMSource source = new DOMSource(doc);
                    StreamResult result = new StreamResult(file);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (ideaConv.getWorkspace().getIws() == null) {
            return;
        }
        ideaConv.getWorkspace().getIws().withXml((Closure)new Closure<Object>((Object)this, null){

            public Object call(Object ... obj) {
                Element root = ((XmlProvider)this.getDelegate()).asElement();
                Document doc = root.getOwnerDocument();
                try {
                    UserLibBasePlugin.this.overrideIntellijRuns(doc, UserLibBasePlugin.this.project.getProjectDir().getCanonicalPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private final void overrideIntellijRuns(Document doc, String module) throws DOMException, IOException {
        Element e;
        int i;
        Element root = null;
        NodeList list = doc.getElementsByTagName("component");
        for (i = 0; i < list.getLength(); ++i) {
            e = (Element)list.item(i);
            if (!"RunManager".equals(e.getAttribute("name"))) continue;
            root = e;
            break;
        }
        list = root.getElementsByTagName("configuration");
        for (i = 0; i < list.getLength(); ++i) {
            String args;
            String runClass;
            e = (Element)list.item(i);
            if ("Minecraft Client".equals(e.getAttribute("name"))) {
                runClass = this.getClientRunClass();
                args = Joiner.on((char)' ').join(this.getClientRunArgs());
            } else {
                if (!"Minecraft Server".equals(e.getAttribute("name"))) continue;
                runClass = this.getServerRunClass();
                args = Joiner.on((char)' ').join(this.getServerRunArgs());
            }
            NodeList list2 = root.getElementsByTagName("option");
            for (int j = 0; j < list2.getLength(); ++j) {
                Element e2 = (Element)list2.item(j);
                if ("MAIN_CLASS_NAME".equals(e2.getAttribute("name"))) {
                    e2.setAttribute("value", runClass);
                    continue;
                }
                if (!"PROGRAM_PARAMETERS".equals(e2.getAttribute("name"))) continue;
                e2.setAttribute("value", args);
            }
        }
    }

    @Override
    public String getApiName() {
        return "minecraft_merged";
    }

    @Override
    protected String getSrcDepName() {
        return "minecraft_merged_src";
    }

    @Override
    protected String getBinDepName() {
        return "minecraft_merged_bin";
    }

    @Override
    protected boolean hasApiVersion() {
        return false;
    }

    @Override
    protected String getApiVersion(UserExtension exten) {
        return null;
    }

    @Override
    protected String getMcVersion(UserExtension exten) {
        return exten.getVersion();
    }

    @Override
    protected String getApiCacheDir(UserExtension exten) {
        return "{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}";
    }

    @Override
    protected DelayedFile getDevJson() {
        return this.delayedFile(this.getFmlCacheDir() + "/unpacked/dev.json");
    }

    @Override
    protected String getSrgCacheDir(UserExtension exten) {
        return this.getFmlCacheDir() + "/srgs";
    }

    @Override
    protected String getUserDevCacheDir(UserExtension exten) {
        return this.getFmlCacheDir() + "/unpacked";
    }

    private final String getFmlCacheDir() {
        return "{CACHE_DIR}/minecraft/cpw/mods/fml/" + this.getFmlVersion();
    }

    private final String getFmlVersion() {
        return "1.7.2-7.2.158.889";
    }

    @Override
    protected String getUserDev() {
        return "cpw.mods:fml:" + this.getFmlVersion();
    }

    @Override
    protected final void configureDeobfuscation(ProcessJarTask task) {
    }

    protected String getJarExtension() {
        return "jar";
    }

    @Override
    protected final void doVersionChecks(String version) {
        if (!"1.7.2".equals(version)) {
            throw new RuntimeException("ForgeGradle 1.2 does not support " + version);
        }
    }

    @Override
    public UserExtension getOverlayExtension() {
        return (UserExtension)this.project.getExtensions().getByName(this.actualApiName());
    }
}

