/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.srg2source.util.io.InputSupplier;

public class PredefInputSupplier
implements InputSupplier {
    private final Map<String, byte[]> fileMap = Maps.newHashMap();
    private final Map<String, String> rootMap = Maps.newHashMap();

    public void close() throws IOException {
    }

    public String getRoot(String resource) {
        return this.rootMap.get(this.sanitize(resource));
    }

    public InputStream getInput(String relPath) {
        return new ByteArrayInputStream(this.fileMap.get(this.sanitize(relPath)));
    }

    public List<String> gatherAll(String endFilter) {
        LinkedList out = Lists.newLinkedList();
        for (String s : this.fileMap.keySet()) {
            if (!s.endsWith(endFilter)) continue;
            out.add(s);
        }
        return out;
    }

    public void addFile(String path, File root, byte[] data) throws IOException {
        path = this.sanitize(path);
        this.fileMap.put(path, data);
        this.rootMap.put(path, this.sanitize(root.getCanonicalPath()));
    }

    private String sanitize(String in) {
        if (in == null) {
            return null;
        }
        if ((in = in.replace('\\', '/')).endsWith("/")) {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public boolean isEmpty() {
        return this.fileMap.isEmpty() && this.rootMap.isEmpty();
    }
}

