/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.gradle.json.DateAdapter;
import net.minecraftforge.gradle.json.EnumAdaptorFactory;
import net.minecraftforge.gradle.json.FileAdapter;
import net.minecraftforge.gradle.json.LiteLoaderJson;
import net.minecraftforge.gradle.json.MCInjectorStruct;
import net.minecraftforge.gradle.json.version.AssetIndex;
import net.minecraftforge.gradle.json.version.Version;

public class JsonFactory {
    public static final Gson GSON;

    public static Version loadVersion(File json) throws JsonSyntaxException, JsonIOException, IOException {
        FileReader reader = new FileReader(json);
        Version v = (Version)GSON.fromJson((Reader)reader, Version.class);
        reader.close();
        return v;
    }

    public static AssetIndex loadAssetsIndex(File json) throws JsonSyntaxException, JsonIOException, IOException {
        FileReader reader = new FileReader(json);
        AssetIndex a = (AssetIndex)GSON.fromJson((Reader)reader, AssetIndex.class);
        reader.close();
        return a;
    }

    public static LiteLoaderJson loadLiteLoaderJson(File json) throws JsonSyntaxException, JsonIOException, IOException {
        FileReader reader = new FileReader(json);
        LiteLoaderJson a = (LiteLoaderJson)GSON.fromJson((Reader)reader, LiteLoaderJson.class);
        reader.close();
        return a;
    }

    public static Map<String, MCInjectorStruct> loadMCIJson(File json) throws IOException {
        FileReader reader = new FileReader(json);
        LinkedHashMap<String, MCInjectorStruct> ret = new LinkedHashMap<String, MCInjectorStruct>();
        JsonObject object = (JsonObject)new JsonParser().parse((Reader)reader);
        reader.close();
        for (Map.Entry entry : object.entrySet()) {
            ret.put((String)entry.getKey(), (MCInjectorStruct)GSON.fromJson((JsonElement)entry.getValue(), MCInjectorStruct.class));
        }
        return ret;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumAdaptorFactory());
        builder.registerTypeAdapter(Date.class, (Object)new DateAdapter());
        builder.registerTypeAdapter(File.class, (Object)new FileAdapter());
        builder.registerTypeAdapter(LiteLoaderJson.VersionObject.class, (Object)new LiteLoaderJson.VersionAdapter());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        GSON = builder.create();
    }
}

