/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.dev;

import groovy.lang.Closure;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraftforge.gradle.CopyInto;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.DevBasePlugin;
import net.minecraftforge.gradle.dev.DevExtension;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import net.minecraftforge.gradle.tasks.ApplyS2STask;
import net.minecraftforge.gradle.tasks.DecompileTask;
import net.minecraftforge.gradle.tasks.ExtractS2SRangeTask;
import net.minecraftforge.gradle.tasks.GenSrgTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.ProcessSrcJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.DelayedJar;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.abstractutil.FileFilterTask;
import net.minecraftforge.gradle.tasks.dev.FMLVersionPropTask;
import net.minecraftforge.gradle.tasks.dev.GenBinaryPatches;
import net.minecraftforge.gradle.tasks.dev.GenDevProjectsTask;
import net.minecraftforge.gradle.tasks.dev.GeneratePatches;
import net.minecraftforge.gradle.tasks.dev.ObfuscateTask;
import net.minecraftforge.gradle.tasks.dev.SubprojectTask;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.bundling.Zip;

public class CauldronDevPlugin
extends DevBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ((DevExtension)this.getExtension()).setFmlDir("forge/fml");
        ((DevExtension)this.getExtension()).setForgeDir("forge");
        ((DevExtension)this.getExtension()).setBukkitDir("bukkit");
        GenSrgTask genSrgTask = (GenSrgTask)this.project.getTasks().getByName("genSrgs");
        for (File f : this.project.fileTree((Object)this.delayedFile("{FML_DIR}/src/main/resources").call()).getFiles()) {
            if (f.getPath().endsWith(".exc")) {
                genSrgTask.addExtraExc(f);
                continue;
            }
            if (!f.getPath().endsWith(".srg")) continue;
            genSrgTask.addExtraSrg(f);
        }
        for (File f : this.project.fileTree((Object)this.delayedFile("{FORGE_DIR}/src/main/resources").call()).getFiles()) {
            if (f.getPath().endsWith(".exc")) {
                genSrgTask.addExtraExc(f);
                continue;
            }
            if (!f.getPath().endsWith(".srg")) continue;
            genSrgTask.addExtraSrg(f);
        }
        for (File f : this.project.fileTree((Object)this.delayedFile("src/main/resources").call()).getFiles()) {
            if (f.getPath().endsWith(".exc")) {
                genSrgTask.addExtraExc(f);
                continue;
            }
            if (!f.getPath().endsWith(".srg")) continue;
            genSrgTask.addExtraSrg(f);
        }
        this.createJarProcessTasks();
        this.createProjectTasks();
        this.createEclipseTasks();
        this.createMiscTasks();
        this.createSourceCopyTasks();
        this.createPackageTasks();
        DefaultTask task = this.makeTask("setupCauldron", DefaultTask.class);
        task.dependsOn(new Object[]{"extractCauldronSources", "generateProjects", "eclipse", "copyAssets"});
        task.setGroup("Cauldron");
        Delete del = this.makeTask("cleanPackages", Delete.class);
        del.delete(new Object[]{"build/distributions"});
        task = this.makeTask("buildPackages");
        task.dependsOn(new Object[]{"cleanPackages", "packageUniversal", "packageInstaller"});
        task.setGroup("Cauldron");
    }

    @Override
    protected final DelayedFile getDevJson() {
        return this.delayedFile("jsons/{MC_VERSION}-dev.json");
    }

    protected void createJarProcessTasks() {
        ProcessJarTask task2 = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        task2.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task2.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_cauldron-{MC_VERSION}.jar"));
        task2.setSrg(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        task2.setExceptorCfg(this.delayedFile("{MAPPINGS_DIR}/joined.exc"));
        task2.setExceptorJson(this.delayedFile("{MAPPINGS_DIR}/exceptor.json"));
        task2.addTransformerClean(this.delayedFile("{FML_DIR}/src/main/resources/fml_at.cfg"));
        task2.addTransformerClean(this.delayedFile("{FORGE_DIR}/src/main/resources/forge_at.cfg"));
        task2.setApplyMarkers(true);
        task2.dependsOn(new Object[]{"downloadMcpTools", "mergeJars"});
        DecompileTask task3 = this.makeTask("decompile", DecompileTask.class);
        task3.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_cauldron-{MC_VERSION}.jar"));
        task3.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_cauldron-{MC_VERSION}.zip"));
        task3.setFernFlower(this.delayedFile("{CACHE_DIR}/minecraft/fernflower-fixed.jar"));
        task3.setPatch(this.delayedFile("{MAPPINGS_DIR}/patches/minecraft_ff"));
        task3.setAstyleConfig(this.delayedFile("{MAPPINGS_DIR}/astyle.cfg"));
        task3.dependsOn(new Object[]{"downloadMcpTools", "deobfuscateJar"});
        ProcessSrcJarTask task4 = this.makeTask("forgePatchJar", ProcessSrcJarTask.class);
        task4.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_cauldron-{MC_VERSION}.zip"));
        task4.setOutJar(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_fmlpatched.zip"));
        task4.addStage("fml", this.delayedFile("{FML_DIR}/patches/minecraft"), this.delayedFile("{FML_DIR}/src/main/java"), this.delayedFile("{FML_DIR}/src/main/resources"), this.delayedFile("{MAPPINGS_DIR}/patches/Start.java"), this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"), this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties"));
        task4.addStage("forge", this.delayedFile("{FORGE_DIR}/patches/minecraft"), this.delayedFile("{FORGE_DIR}/src/main/java"), this.delayedFile("{FORGE_DIR}/src/main/resources"));
        task4.addStage("bukkit", null, this.delayedFile("{BUKKIT_DIR}/src/main/java"));
        task4.setDoesCache(false);
        task4.setMaxFuzz(2);
        task4.dependsOn(new Object[]{"decompile", "compressDeobfData", "createVersionPropertiesFML"});
        RemapSourcesTask task6 = this.makeTask("remapCleanJar", RemapSourcesTask.class);
        task6.setInJar(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_fmlpatched.zip"));
        task6.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/clean.jar"));
        task6.setMethodsCsv(this.delayedFile("{MAPPINGS_DIR}/methods.csv"));
        task6.setFieldsCsv(this.delayedFile("{MAPPINGS_DIR}/fields.csv"));
        task6.setParamsCsv(this.delayedFile("{MAPPINGS_DIR}/params.csv"));
        task6.setDoesCache(true);
        task6.setNoJavadocs();
        task6.dependsOn(new Object[]{"forgePatchJar"});
        task4 = this.makeTask("cauldronPatchJar", ProcessSrcJarTask.class);
        task4.setInJar(this.delayedFile("{BUILD_DIR}/tmp/clean.jar"));
        task4.setOutJar(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_patched.zip"));
        task4.addStage("Cauldron", this.delayedFile("patches"));
        task4.setDoesCache(false);
        task4.setMaxFuzz(2);
        task4.dependsOn(new Object[]{"forgePatchJar", "remapCleanJar"});
        task6 = this.makeTask("remapCauldronJar", RemapSourcesTask.class);
        task6.setInJar(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_patched.zip"));
        task6.setOutJar(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_renamed.zip"));
        task6.setMethodsCsv(this.delayedFile("{MAPPINGS_DIR}/methods.csv"));
        task6.setFieldsCsv(this.delayedFile("{MAPPINGS_DIR}/fields.csv"));
        task6.setParamsCsv(this.delayedFile("{MAPPINGS_DIR}/params.csv"));
        task6.setDoesCache(true);
        task6.setNoJavadocs();
        task6.dependsOn(new Object[]{"cauldronPatchJar"});
    }

    private void createSourceCopyTasks() {
        ExtractTask task = this.makeTask("extractCleanResources", ExtractTask.class);
        task.exclude(JAVA_FILES);
        task.setIncludeEmptyDirs(false);
        task.from(this.delayedFile("{BUILD_DIR}/tmp/clean.jar"));
        task.into(this.delayedFile("eclipse/Clean/src/main/resources"));
        task.dependsOn(new Object[]{"extractWorkspace", "remapCleanJar"});
        task = this.makeTask("extractCleanSource", ExtractTask.class);
        task.include(JAVA_FILES);
        task.setIncludeEmptyDirs(false);
        task.from(this.delayedFile("{BUILD_DIR}/tmp/clean.jar"));
        task.into(this.delayedFile("eclipse/Clean/src/main/java"));
        task.dependsOn(new Object[]{"extractCleanResources"});
        task = this.makeTask("extractCauldronResources", ExtractTask.class);
        task.exclude(JAVA_FILES);
        task.from(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_renamed.zip"));
        task.into(this.delayedFile("eclipse/cauldron/src/main/resources"));
        task.dependsOn(new Object[]{"remapCauldronJar", "extractWorkspace"});
        task.onlyIf(new Spec(){

            public boolean isSatisfiedBy(Object arg0) {
                File dir = CauldronDevPlugin.this.delayedFile("eclipse/cauldron/src/main/resources").call();
                if (!dir.exists()) {
                    return true;
                }
                ConfigurableFileTree tree = CauldronDevPlugin.this.project.fileTree((Object)dir);
                tree.include(new String[]{"**/*.java"});
                return !tree.isEmpty();
            }
        });
        task = this.makeTask("extractCauldronSources", ExtractTask.class);
        task.include(JAVA_FILES);
        task.from(this.delayedFile("{BUILD_DIR}/cauldronTmp/minecraft_renamed.zip"));
        task.into(this.delayedFile("eclipse/cauldron/src/main/java"));
        task.dependsOn(new Object[]{"extractCauldronResources"});
        task.onlyIf(new Spec(){

            public boolean isSatisfiedBy(Object arg0) {
                File dir = CauldronDevPlugin.this.delayedFile("eclipse/cauldron/src/main/java").call();
                if (!dir.exists()) {
                    return true;
                }
                ConfigurableFileTree tree = CauldronDevPlugin.this.project.fileTree((Object)dir);
                tree.include(new String[]{"**/*.java"});
                return !tree.isEmpty();
            }
        });
    }

    private void createProjectTasks() {
        FMLVersionPropTask sub = this.makeTask("createVersionPropertiesFML", FMLVersionPropTask.class);
        sub.setVersion(new Closure<String>((Object)this.project){

            public String call(Object ... args) {
                return FmlDevPlugin.getVersionFromGit(CauldronDevPlugin.this.project, new File(CauldronDevPlugin.this.delayedString("{FML_DIR}").call()));
            }
        });
        sub.setOutputFile(this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties"));
        ExtractTask extract = this.makeTask("extractRes", ExtractTask.class);
        extract.into(this.delayedFile("{BUILD_DIR}/extractedResources"));
        for (File f : this.delayedFile("src/main").call().listFiles()) {
            String path;
            if (f.isDirectory() || !(path = f.getAbsolutePath()).endsWith(".jar") && !path.endsWith(".zip")) continue;
            extract.from(this.delayedFile(path));
        }
        GenDevProjectsTask task = this.makeTask("generateProjectClean", GenDevProjectsTask.class);
        task.setTargetDir(this.delayedFile("eclipse/Clean"));
        task.setJson(this.delayedFile("jsons/{MC_VERSION}-dev.json"));
        task.addSource(this.delayedFile("eclipse/Clean/src/main/java"));
        task.addResource(this.delayedFile("eclipse/Clean/src/main/resources"));
        task.dependsOn(new Object[]{"extractNatives"});
        task = this.makeTask("generateProjectCauldron", GenDevProjectsTask.class);
        task.setJson(this.delayedFile("jsons/{MC_VERSION}-dev.json"));
        task.setTargetDir(this.delayedFile("eclipse/cauldron"));
        task.addSource(this.delayedFile("eclipse/cauldron/src/main/java"));
        task.addSource(this.delayedFile("src/main/java"));
        task.addTestSource(this.delayedFile("src/test/java"));
        task.addResource(this.delayedFile("eclipse/cauldron/src/main/resources"));
        task.addResource(this.delayedFile("src/main/resources"));
        task.addResource(this.delayedFile("{BUILD_DIR}/extractedResources"));
        task.addTestSource(this.delayedFile("src/test/java"));
        task.dependsOn(new Object[]{"extractRes", "extractNatives", "createVersionPropertiesFML"});
        this.makeTask("generateProjects").dependsOn(new Object[]{"generateProjectClean", "generateProjectCauldron"});
    }

    private void createEclipseTasks() {
        SubprojectTask task = this.makeTask("eclipseClean", SubprojectTask.class);
        task.setBuildFile(this.delayedFile("eclipse/Clean/build.gradle"));
        task.setTasks("eclipse");
        task.dependsOn(new Object[]{"extractCleanSource", "generateProjects"});
        task = this.makeTask("eclipseCauldron", SubprojectTask.class);
        task.setBuildFile(this.delayedFile("eclipse/cauldron/build.gradle"));
        task.setTasks("eclipse");
        task.dependsOn(new Object[]{"extractCauldronSources", "generateProjects"});
        this.makeTask("eclipse").dependsOn(new Object[]{"eclipseClean", "eclipseCauldron"});
    }

    private void createMiscTasks() {
        DelayedFile rangeMapClean = this.delayedFile("{BUILD_DIR}/tmp/rangemapCLEAN.txt");
        DelayedFile rangeMapDirty = this.delayedFile("{BUILD_DIR}/tmp/rangemapDIRTY.txt");
        ExtractS2SRangeTask extractRange = this.makeTask("extractRangeCauldron", ExtractS2SRangeTask.class);
        extractRange.setLibsFromProject(this.delayedFile("eclipse/cauldron/build.gradle"), "compile", true);
        extractRange.addIn(this.delayedFile("eclipse/cauldron/src/main/java"));
        extractRange.setRangeMap(rangeMapDirty);
        ApplyS2STask applyS2S = this.makeTask("retroMapCauldron", ApplyS2STask.class);
        applyS2S.addIn(this.delayedFile("eclipse/cauldron/src/main/java"));
        applyS2S.setOut(this.delayedFile("{BUILD_DIR}/tmp/dirty-patch-base.zip"));
        applyS2S.addSrg(this.delayedFile("{BUILD_DIR}/tmp/mcp2srg.srg"));
        applyS2S.addExc(this.delayedFile("{BUILD_DIR}/tmp/mcp.exc"));
        applyS2S.addExc(this.delayedFile("{BUILD_DIR}/tmp/srg.exc"));
        applyS2S.setRangeMap(rangeMapDirty);
        applyS2S.dependsOn(new Object[]{"genSrgs", extractRange});
        extractRange = this.makeTask("extractRangeClean", ExtractS2SRangeTask.class);
        extractRange.setLibsFromProject(this.delayedFile("eclipse/Clean/build.gradle"), "compile", true);
        extractRange.addIn(this.delayedFile("{BUILD_DIR}/tmp/clean.jar"));
        extractRange.setRangeMap(rangeMapClean);
        applyS2S = this.makeTask("retroMapClean", ApplyS2STask.class);
        applyS2S.addIn(this.delayedFile("{BUILD_DIR}/tmp/clean.jar"));
        applyS2S.setOut(this.delayedFile("{BUILD_DIR}/tmp/clean-path-base.zip"));
        applyS2S.addSrg(this.delayedFile("{BUILD_DIR}/tmp/mcp2srg.srg"));
        applyS2S.addExc(this.delayedFile("{BUILD_DIR}/tmp/mcp.exc"));
        applyS2S.addExc(this.delayedFile("{BUILD_DIR}/tmp/srg.exc"));
        applyS2S.setRangeMap(rangeMapClean);
        applyS2S.dependsOn(new Object[]{"genSrgs", extractRange});
        GeneratePatches task2 = this.makeTask("genPatches", GeneratePatches.class);
        task2.setPatchDir(this.delayedFile("patches"));
        task2.setOriginal(this.delayedFile("eclipse/Clean/src/main/java"));
        task2.setChanged(this.delayedFile("eclipse/cauldron/src/main/java"));
        task2.setOriginalPrefix("../src-base/minecraft");
        task2.setChangedPrefix("../src-work/minecraft");
        task2.getTaskDependencies().getDependencies((Task)task2).clear();
        task2.setGroup("Cauldron");
        Delete clean = this.makeTask("cleanCauldron", Delete.class);
        clean.delete(new Object[]{"eclipse"});
        clean.setGroup("Clean");
        this.project.getTasks().getByName("clean").dependsOn(new Object[]{"cleanCauldron"});
        ObfuscateTask obf = this.makeTask("obfuscateJar", ObfuscateTask.class);
        obf.setSrg(this.delayedFile("{BUILD_DIR}/tmp/mcp2notch.srg"));
        obf.setExc(this.delayedFile("{MAPPINGS_DIR}/joined.exc"));
        obf.setReverse(false);
        obf.setPreFFJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_cauldron-{MC_VERSION}.jar"));
        obf.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/recomp_obfed.jar"));
        obf.setBuildFile(this.delayedFile("eclipse/cauldron/build.gradle"));
        obf.setMethodsCsv(this.delayedFile("{MAPPINGS_DIR}/methods.csv"));
        obf.setFieldsCsv(this.delayedFile("{MAPPINGS_DIR}/fields.csv"));
        obf.dependsOn(new Object[]{"genSrgs"});
        GenBinaryPatches task3 = this.makeTask("genBinPatches", GenBinaryPatches.class);
        task3.setCleanClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task3.setCleanServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task3.setCleanMerged(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task3.setDirtyJar(this.delayedFile("{BUILD_DIR}/tmp/recomp_obfed.jar"));
        task3.setDeobfDataLzma(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"));
        task3.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/bin_patches.jar"));
        task3.setSrg(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        task3.addPatchList(this.delayedFileTree("patches"));
        task3.addPatchList(this.delayedFileTree("{FORGE_DIR}/patches/minecraft"));
        task3.addPatchList(this.delayedFileTree("{FML_DIR}/patches/minecraft"));
        task3.dependsOn(new Object[]{"obfuscateJar", "compressDeobfData"});
    }

    private void createPackageTasks() {
        final DelayedJar uni = this.makeTask("packageUniversal", DelayedJar.class);
        uni.setClassifier(this.delayedString("B{BUILD_NUM}").call());
        uni.getInputs().file((Object)this.delayedFile("jsons/{MC_VERSION}-rel.json"));
        uni.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        uni.from(new Object[]{this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar")});
        uni.from(new Object[]{this.delayedFileTree("src/main/resources")});
        uni.from(new Object[]{this.delayedFileTree("{FORGE_DIR}/src/main/resources")});
        uni.from(new Object[]{this.delayedFileTree("{FML_DIR}/src/main/resources")});
        uni.from(new Object[]{this.delayedFileTree("{BUILD_DIR}/extractedResources")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        uni.from(new Object[]{this.delayedFile("{FORGE_DIR}/MinecraftForge-License.txt")});
        uni.from(new Object[]{this.delayedFile("{FORGE_DIR}/MinecraftForge-Credits.txt")});
        uni.from(new Object[]{this.delayedFile("{FORGE_DIR}/Paulscode IBXM Library License.txt")});
        uni.from(new Object[]{this.delayedFile("{FORGE_DIR}/Paulscode SoundSystem CodecIBXM License.txt")});
        uni.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma")});
        uni.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        uni.from(new Object[]{this.delayedFile("{BUILD_DIR}/tmp/version.json")});
        uni.exclude(new String[]{"devbinpatches.pack.lzma"});
        uni.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        uni.setIncludeEmptyDirs(false);
        uni.setManifest((Closure)new Closure<Object>((Object)this.project){

            public Object call() {
                Manifest mani = (Manifest)this.getDelegate();
                mani.getAttributes().put((Object)"Main-Class", (Object)CauldronDevPlugin.this.delayedString("{MAIN_CLASS}").call());
                mani.getAttributes().put((Object)"TweakClass", (Object)CauldronDevPlugin.this.delayedString("{FML_TWEAK_CLASS}").call());
                mani.getAttributes().put((Object)"Class-Path", (Object)CauldronDevPlugin.this.getServerClassPath(CauldronDevPlugin.this.delayedFile("jsons/{MC_VERSION}-rel.json").call()));
                return null;
            }
        });
        uni.setDestinationDir(this.delayedFile("{BUILD_DIR}/distributions").call());
        uni.dependsOn(new Object[]{"genBinPatches", "createVersionPropertiesFML"});
        this.project.getArtifacts().add("archives", (Object)uni);
        FileFilterTask task = this.makeTask("generateInstallJson", FileFilterTask.class);
        task.setInputFile(this.delayedFile("jsons/{MC_VERSION}-rel.json"));
        task.setOutputFile(this.delayedFile("{BUILD_DIR}/tmp/install_profile.json"));
        task.addReplacement("@minecraft_version@", (Object)this.delayedString("{MC_VERSION}"));
        task.addReplacement("@version@", (Object)this.delayedString("{VERSION}"));
        task.addReplacement("@project@", (Object)this.delayedString("cauldron"));
        task.addReplacement("@artifact@", (Object)this.delayedString("net.minecraftforge:forge:{MC_VERSION}-{VERSION}"));
        task.addReplacement("@universal_jar@", new Closure<String>((Object)this.project){

            public String call() {
                return uni.getArchiveName();
            }
        });
        task.addReplacement("@timestamp@", new Closure<String>((Object)this.project){

            public String call() {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date());
            }
        });
        Zip inst = this.makeTask("packageInstaller", Zip.class);
        inst.setClassifier("installer");
        inst.from(new Object[]{new Closure<File>((Object)this.project){

            public File call() {
                return uni.getArchivePath();
            }
        }});
        inst.from(new Object[]{this.delayedFile("{BUILD_DIR}/tmp/install_profile.json")});
        inst.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        inst.from(new Object[]{this.delayedFile("{FORGE_DIR}/MinecraftForge-License.txt")});
        inst.from(new Object[]{this.delayedFile("{FORGE_DIR}/MinecraftForge-Credits.txt")});
        inst.from(new Object[]{this.delayedFile("{FORGE_DIR}/Paulscode IBXM Library License.txt")});
        inst.from(new Object[]{this.delayedFile("{FORGE_DIR}/Paulscode SoundSystem CodecIBXM License.txt")});
        inst.from(new Object[]{this.delayedFile("{FORGE_DIR}/src/main/resources/forge_logo.png")});
        inst.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/installer_base.{INSTALLER_VERSION}.jar"), (Closure)new CopyInto("", "!*.json", "!*.png"));
        inst.dependsOn(new Object[]{"packageUniversal", "downloadBaseInstaller", "generateInstallJson"});
        inst.rename("forge_logo\\.png", "big_logo.png");
        inst.setExtension("jar");
        this.project.getArtifacts().add("archives", (Object)inst);
    }

    @Override
    public void afterEvaluate() {
        super.afterEvaluate();
        SubprojectTask task = (SubprojectTask)this.project.getTasks().getByName("eclipseClean");
        task.configureProject(((DevExtension)this.getExtension()).getSubprojects());
        task.configureProject(((DevExtension)this.getExtension()).getCleanProject());
        task = (SubprojectTask)this.project.getTasks().getByName("eclipseCauldron");
        task.configureProject(((DevExtension)this.getExtension()).getSubprojects());
        task.configureProject(((DevExtension)this.getExtension()).getCleanProject());
    }
}

