/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user.reobf;

import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import joptsimple.internal.Strings;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ArtifactSpec {
    private Object baseName;
    private Object appendix;
    private Object version;
    private Object classifier;
    private Object extension;
    private Object archiveName;
    private Object classpath;
    protected Object srg = null;
    private Project project;
    private boolean archiveSet = false;

    public ArtifactSpec(Project proj) {
        this.project = proj;
    }

    public ArtifactSpec(File file, Project proj) {
        this.archiveName = file.getName();
        this.extension = Files.getFileExtension((String)file.getName());
        this.project = proj;
    }

    public ArtifactSpec(String file, Project proj) {
        this.archiveName = file;
        this.extension = Files.getFileExtension((String)file);
        this.project = proj;
    }

    public ArtifactSpec(PublishArtifact artifact, Project proj) {
        this.baseName = artifact.getName();
        this.classifier = artifact.getClassifier();
        this.extension = artifact.getExtension();
        this.project = proj;
    }

    public ArtifactSpec(final AbstractArchiveTask task) {
        this.project = task.getProject();
        this.baseName = new Closure(null){

            public Object call() {
                return task.getBaseName();
            }
        };
        this.appendix = new Closure(null){

            public Object call() {
                return task.getAppendix();
            }
        };
        this.version = new Closure(null){

            public Object call() {
                return task.getVersion();
            }
        };
        this.classifier = new Closure(null){

            public Object call() {
                return task.getClassifier();
            }
        };
        this.extension = new Closure(null){

            public Object call() {
                return task.getExtension();
            }
        };
        this.archiveName = new Closure(null){

            public Object call() {
                return task.getArchiveName();
            }
        };
        this.classpath = new Closure(null){

            public Object call() {
                return task.getSource();
            }
        };
    }

    public Object getBaseName() {
        return this.baseName;
    }

    public void setBaseName(Object baseName) {
        this.baseName = baseName;
    }

    public Object getAppendix() {
        return this.appendix;
    }

    public void setAppendix(Object appendix) {
        this.appendix = appendix;
    }

    public Object getVersion() {
        return this.version;
    }

    public void setVersion(Object version) {
        this.version = version;
    }

    public Object getClassifier() {
        return this.classifier;
    }

    public void setClassifier(Object classifier) {
        this.classifier = classifier;
    }

    public Object getExtension() {
        return this.extension;
    }

    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public Object getClasspath() {
        if (this.classpath == null) {
            this.classpath = this.project.files(new Object[]{new String[0]});
        }
        return this.classpath;
    }

    public void setClasspath(Object classpath) {
        this.classpath = classpath;
    }

    public boolean isArchiveSet() {
        return this.archiveSet;
    }

    public void setArchiveSet(boolean archiveSet) {
        this.archiveSet = archiveSet;
    }

    public Object getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(Object archiveName) {
        this.archiveName = archiveName;
        this.archiveSet = true;
    }

    public Object getSrg() {
        return this.srg;
    }

    public void setSrg(Object srg) {
        this.srg = srg;
    }

    public void setSrgSrg() {
        this.srg = new DelayedFile(this.project, "{SRG_DIR}/mcp-srg.srg", new DelayedBase.IDelayedResolver[]{((UserExtension)this.project.getExtensions().getByName((String)"minecraft")).plugin});
    }

    public void setSrgMcp() {
        this.srg = new DelayedFile(this.project, "{SRG_DIR}/mcp-notch.srg", new DelayedBase.IDelayedResolver[]{((UserExtension)this.project.getExtensions().getByName((String)"minecraft")).plugin});
    }

    protected void resolve() {
        this.baseName = this.resolveString(this.baseName);
        this.appendix = this.resolveString(this.appendix);
        this.version = this.resolveString(this.version);
        this.classifier = this.resolveString(this.classifier);
        this.extension = this.resolveString(this.extension);
        this.srg = this.resolveFile(this.srg);
        if (this.classpath != null) {
            this.classpath = this.project.files(new Object[]{this.classpath});
        }
        if (this.archiveSet && this.archiveName != null) {
            return;
        }
        this.archiveName = this.resolveString(this.archiveName);
        if (this.archiveName != null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.baseName);
        if (!Strings.isNullOrEmpty((String)((String)this.appendix))) {
            builder.append('-');
            builder.append(this.appendix);
        }
        if (!Strings.isNullOrEmpty((String)((String)this.version))) {
            builder.append('-');
            builder.append(this.version);
        }
        if (!Strings.isNullOrEmpty((String)((String)this.classifier))) {
            builder.append('-');
            builder.append(this.classifier);
        }
        builder.append('.');
        builder.append(this.extension);
        this.archiveName = builder.toString();
    }

    private Object resolveString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Closure) {
            return this.resolveString(((Closure)obj).call());
        }
        return obj.toString();
    }

    private Object resolveFile(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.project.file(obj);
    }
}

