/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.patching.ContextualPatch;
import net.minecraftforge.gradle.tasks.abstractutil.EditJarTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;

public class ProcessSrcJarTask
extends EditJarTask {
    private List<ResourceHolder> stages = new LinkedList<ResourceHolder>();
    @Input
    private int maxFuzz = 0;
    private ContextProvider PROVIDER;

    @Override
    public String asRead(String file) {
        return file;
    }

    @Override
    public void doStuffBefore() throws Throwable {
        this.PROVIDER = new ContextProvider(this.sourceMap);
    }

    @Override
    public void doStuffMiddle() throws Throwable {
        for (ResourceHolder stage : this.stages) {
            if (!stage.srcDirs.isEmpty()) {
                this.getLogger().lifecycle("Injecting {} files", new Object[]{stage.name});
                for (RelFile rel : stage.getRelInjects()) {
                    String relative = rel.getRelative();
                    if (this.sourceMap.containsKey(relative) || this.resourceMap.containsKey("relative")) continue;
                    if (relative.endsWith(".java")) {
                        this.sourceMap.put(relative, Files.toString((File)rel.file, (Charset)Charset.defaultCharset()));
                        continue;
                    }
                    this.resourceMap.put(relative, Files.asByteSource((File)rel.file).read());
                }
            }
            if (stage.patchDir == null) continue;
            this.getLogger().lifecycle("Applying {} patches", new Object[]{stage.name});
            this.applyPatchStage(stage.name, stage.getPatchFiles());
        }
    }

    public void applyPatchStage(String stage, FileCollection patchFiles) throws Throwable {
        this.getLogger().info("Reading patches for stage {}", (Object)stage);
        ArrayList<PatchedFile> patches = this.readPatches(patchFiles);
        boolean fuzzed = false;
        this.getLogger().info("Applying patches for stage {}", (Object)stage);
        Throwable failure = null;
        for (PatchedFile patch : patches) {
            List<ContextualPatch.PatchReport> errors = patch.patch.patch(false);
            for (ContextualPatch.PatchReport report : errors) {
                if (!report.getStatus().isSuccess()) {
                    File reject = patch.makeRejectFile();
                    if (reject.exists()) {
                        reject.delete();
                    }
                    this.getLogger().log(LogLevel.ERROR, "Patching failed: {} {}", new Object[]{this.PROVIDER.strip(report.getTarget()), report.getFailure().getMessage()});
                    int failed = 0;
                    for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                        if (!hunk.getStatus().isSuccess()) {
                            ++failed;
                            this.getLogger().error("  " + hunk.getHunkID() + ": " + (hunk.getFailure() != null ? hunk.getFailure().getMessage() : "") + " @ " + hunk.getIndex());
                            Files.append((CharSequence)String.format("++++ REJECTED PATCH %d\n", hunk.getHunkID()), (File)reject, (Charset)Charsets.UTF_8);
                            Files.append((CharSequence)Joiner.on((char)'\n').join((Iterable)hunk.hunk.lines), (File)reject, (Charset)Charsets.UTF_8);
                            Files.append((CharSequence)String.format("\n++++ END PATCH\n", new Object[0]), (File)reject, (Charset)Charsets.UTF_8);
                            continue;
                        }
                        if (hunk.getStatus() != ContextualPatch.PatchStatus.Fuzzed) continue;
                        this.getLogger().info("  " + hunk.getHunkID() + " fuzzed " + hunk.getFuzz() + "!");
                    }
                    this.getLogger().log(LogLevel.ERROR, "  {}/{} failed", new Object[]{failed, report.getHunks().size()});
                    this.getLogger().log(LogLevel.ERROR, "  Rejects written to {}", new Object[]{reject.getAbsolutePath()});
                    if (failure != null) continue;
                    failure = report.getFailure();
                    continue;
                }
                if (report.getStatus() == ContextualPatch.PatchStatus.Fuzzed) {
                    this.getLogger().log(LogLevel.INFO, "Patching fuzzed: {}", new Object[]{this.PROVIDER.strip(report.getTarget())});
                    fuzzed = true;
                    for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                        if (hunk.getStatus() != ContextualPatch.PatchStatus.Fuzzed) continue;
                        this.getLogger().info("  {} fuzzed {}!", (Object)hunk.getHunkID(), (Object)hunk.getFuzz());
                    }
                    if (failure != null) continue;
                    failure = report.getFailure();
                    continue;
                }
                this.getLogger().info("Patch succeeded: {}", (Object)this.PROVIDER.strip(report.getTarget()));
            }
        }
        if (fuzzed) {
            this.getLogger().lifecycle("Patches Fuzzed!");
        }
    }

    private ArrayList<PatchedFile> readPatches(FileCollection patchFiles) throws IOException {
        ArrayList<PatchedFile> patches = new ArrayList<PatchedFile>();
        for (File file : patchFiles.getFiles()) {
            if (!file.getPath().endsWith(".patch")) continue;
            patches.add(this.readPatch(file));
        }
        return patches;
    }

    public PatchedFile readPatch(File file) throws IOException {
        this.getLogger().debug("Reading patch file: {}");
        return new PatchedFile(file);
    }

    @InputFiles
    public FileCollection getAllPatches() {
        FileCollection col = null;
        for (ResourceHolder holder : this.stages) {
            if (holder.patchDir == null) continue;
            if (col == null) {
                col = holder.getPatchFiles();
                continue;
            }
            col = this.getProject().files(new Object[]{col, holder.getPatchFiles()});
        }
        return col;
    }

    @InputFiles
    public FileCollection getAllInjects() {
        FileCollection col = null;
        for (ResourceHolder holder : this.stages) {
            if (col == null) {
                col = holder.getInjects();
                continue;
            }
            col = this.getProject().files(new Object[]{col, holder.getInjects()});
        }
        return col;
    }

    public void addStage(String name, DelayedFile patchDir, DelayedFile ... injects) {
        this.stages.add(new ResourceHolder(name, patchDir, Arrays.asList(injects)));
    }

    public void addStage(String name, DelayedFile patchDir) {
        this.stages.add(new ResourceHolder(name, patchDir));
    }

    @Override
    public void doStuffAfter() throws Throwable {
    }

    public int getMaxFuzz() {
        return this.maxFuzz;
    }

    public void setMaxFuzz(int maxFuzz) {
        this.maxFuzz = maxFuzz;
    }

    private static final class RelFile {
        public final File file;
        public final File root;

        public RelFile(File file, File root) {
            this.file = file;
            this.root = root;
        }

        public String getRelative() {
            return this.file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1).replace('\\', '/');
        }
    }

    private final class ResourceHolder {
        final String name;
        final DelayedFile patchDir;
        final List<DelayedFile> srcDirs;

        public ResourceHolder(String name, DelayedFile patchDir, List<DelayedFile> srcDirs) {
            this.name = name;
            this.patchDir = patchDir;
            this.srcDirs = srcDirs;
        }

        public ResourceHolder(String name, DelayedFile patchDir) {
            this.name = name;
            this.patchDir = patchDir;
            this.srcDirs = new ArrayList<DelayedFile>(0);
        }

        public FileCollection getPatchFiles() {
            File patch = ProcessSrcJarTask.this.getProject().file((Object)this.patchDir);
            if (patch.isDirectory()) {
                return ProcessSrcJarTask.this.getProject().fileTree((Object)patch);
            }
            if (patch.getPath().endsWith("zip") || patch.getPath().endsWith("jar")) {
                return ProcessSrcJarTask.this.getProject().zipTree((Object)patch);
            }
            return ProcessSrcJarTask.this.getProject().files(new Object[]{patch});
        }

        public FileCollection getInjects() {
            ArrayList<ConfigurableFileTree> trees = new ArrayList<ConfigurableFileTree>(this.srcDirs.size());
            for (DelayedFile f : this.srcDirs) {
                trees.add(ProcessSrcJarTask.this.getProject().fileTree((Object)f.call()));
            }
            return ProcessSrcJarTask.this.getProject().files(new Object[]{trees});
        }

        public List<RelFile> getRelInjects() {
            LinkedList<RelFile> files = new LinkedList<RelFile>();
            for (DelayedFile df : this.srcDirs) {
                File dir = df.call();
                if (dir.isDirectory()) {
                    for (File f : ProcessSrcJarTask.this.getProject().fileTree((Object)dir)) {
                        files.add(new RelFile(f, dir));
                    }
                    continue;
                }
                files.add(new RelFile(dir, dir.getParentFile()));
            }
            return files;
        }
    }

    private class ContextProvider
    implements ContextualPatch.IContextProvider {
        private Map<String, String> fileMap;
        private final int STRIP = 3;

        public ContextProvider(Map<String, String> fileMap) {
            this.fileMap = fileMap;
        }

        public String strip(String target) {
            target = target.replace('\\', '/');
            int index = 0;
            for (int x = 0; x < 3; ++x) {
                index = target.indexOf(47, index) + 1;
            }
            return target.substring(index);
        }

        @Override
        public List<String> getData(String target) {
            if (this.fileMap.containsKey(target = this.strip(target))) {
                String[] lines = this.fileMap.get(target).split("\r\n|\r|\n");
                ArrayList<String> ret = new ArrayList<String>();
                for (String line : lines) {
                    ret.add(line);
                }
                return ret;
            }
            return null;
        }

        @Override
        public void setData(String target, List<String> data) {
            target = this.strip(target);
            this.fileMap.put(target, Joiner.on((String)Constants.NEWLINE).join(data));
        }
    }

    private class PatchedFile {
        public final File fileToPatch;
        public final ContextualPatch patch;

        public PatchedFile(File file) throws IOException {
            this.fileToPatch = file;
            this.patch = ContextualPatch.create(Files.toString((File)file, (Charset)Charset.defaultCharset()), ProcessSrcJarTask.this.PROVIDER).setAccessC14N(true).setMaxFuzz(ProcessSrcJarTask.this.getMaxFuzz());
        }

        public File makeRejectFile() {
            return new File(this.fileToPatch.getParentFile(), this.fileToPatch.getName() + ".rej");
        }
    }
}

