/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import net.minecraftforge.srg2source.rangeapplier.MethodData;
import net.minecraftforge.srg2source.rangeapplier.SrgContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenSrgTask
extends CachedTask {
    @InputFile
    private DelayedFile inSrg;
    @InputFile
    private DelayedFile inExc;
    @InputFiles
    private final LinkedList<File> extraExcs = new LinkedList();
    @InputFiles
    private final LinkedList<File> extraSrgs = new LinkedList();
    @InputFile
    private DelayedFile methodsCsv;
    @InputFile
    private DelayedFile fieldsCsv;
    @CachedTask.Cached
    @OutputFile
    private DelayedFile notchToSrg;
    @CachedTask.Cached
    @OutputFile
    private DelayedFile notchToMcp;
    @CachedTask.Cached
    @OutputFile
    private DelayedFile mcpToNotch;
    @CachedTask.Cached
    @OutputFile
    private DelayedFile mcpToSrg;
    @CachedTask.Cached
    @OutputFile
    private DelayedFile srgExc;
    @CachedTask.Cached
    @OutputFile
    private DelayedFile mcpExc;

    @TaskAction
    public void doTask() throws IOException {
        HashMap<String, String> methods = new HashMap<String, String>();
        HashMap<String, String> fields = new HashMap<String, String>();
        GenSrgTask.readCSVs(this.getMethodsCsv(), this.getFieldsCsv(), methods, fields);
        SrgContainer inSrg = new SrgContainer().readSrg(this.getInSrg());
        Map<String, String> excRemap = GenSrgTask.readExtraSrgs(this.getExtraSrgs(), inSrg);
        this.writeOutSrgs(inSrg, methods, fields);
        this.writeOutExcs(excRemap, methods);
    }

    private static void readCSVs(File methodCsv, File fieldCsv, Map<String, String> methodMap, Map<String, String> fieldMap) throws IOException {
        CSVReader csvReader = RemapSourcesTask.getReader(methodCsv);
        for (String[] s : csvReader.readAll()) {
            methodMap.put(s[0], s[1]);
        }
        csvReader = RemapSourcesTask.getReader(fieldCsv);
        for (String[] s : csvReader.readAll()) {
            fieldMap.put(s[0], s[1]);
        }
    }

    private static Map<String, String> readExtraSrgs(FileCollection extras, SrgContainer inSrg) {
        SrgContainer extraSrg = new SrgContainer().readSrgs((Iterable)extras);
        HashMap<String, String> excRemap = new HashMap<String, String>(extraSrg.methodMap.size());
        BiMap classMap = inSrg.classMap.inverse();
        BiMap methodMap = inSrg.methodMap.inverse();
        for (Map.Entry e : extraSrg.methodMap.entrySet()) {
            String notchName = GenSrgTask.remapMethodName(((MethodData)e.getValue()).name, (Map<MethodData, MethodData>)methodMap);
            String notchSig = GenSrgTask.remapSig(((MethodData)e.getValue()).sig, (Map<String, String>)classMap);
            inSrg.methodMap.put((Object)new MethodData(notchName, notchSig), e.getValue());
            excRemap.put(((MethodData)e.getKey()).name, ((MethodData)e.getValue()).name);
        }
        return excRemap;
    }

    private void writeOutSrgs(SrgContainer inSrg, Map<String, String> methods, Map<String, String> fields) throws IOException {
        String mcpName;
        String temp;
        String line;
        Files.createParentDirs((File)this.getNotchToSrg());
        Files.createParentDirs((File)this.getNotchToMcp());
        Files.createParentDirs((File)this.getMcpToSrg());
        Files.createParentDirs((File)this.getMcpToNotch());
        BufferedWriter notch2Srg = Files.newWriter((File)this.getNotchToSrg(), (Charset)Charsets.UTF_8);
        BufferedWriter notch2Mcp = Files.newWriter((File)this.getNotchToMcp(), (Charset)Charsets.UTF_8);
        BufferedWriter mcpToSrg = Files.newWriter((File)this.getMcpToSrg(), (Charset)Charsets.UTF_8);
        BufferedWriter mcpToNotch = Files.newWriter((File)this.getMcpToNotch(), (Charset)Charsets.UTF_8);
        for (Map.Entry e : inSrg.packageMap.entrySet()) {
            line = "PK: " + (String)e.getKey() + " " + (String)e.getValue();
            notch2Srg.write(line);
            notch2Srg.newLine();
            notch2Mcp.write(line);
            notch2Mcp.newLine();
            mcpToSrg.write(line);
            mcpToSrg.newLine();
            mcpToNotch.write(line);
            mcpToNotch.newLine();
        }
        for (Map.Entry e : inSrg.classMap.entrySet()) {
            line = "CL: " + (String)e.getKey() + " " + (String)e.getValue();
            notch2Srg.write(line);
            notch2Srg.newLine();
            notch2Mcp.write(line);
            notch2Mcp.newLine();
            line = "CL: " + (String)e.getValue() + " " + (String)e.getValue();
            mcpToSrg.write("CL: " + (String)e.getValue() + " " + (String)e.getValue());
            mcpToSrg.newLine();
            mcpToNotch.write("CL: " + (String)e.getValue() + " " + (String)e.getKey());
            mcpToNotch.newLine();
        }
        for (Map.Entry e : inSrg.fieldMap.entrySet()) {
            line = "FD: " + (String)e.getKey() + " " + (String)e.getValue();
            notch2Srg.write("FD: " + (String)e.getKey() + " " + (String)e.getValue());
            notch2Srg.newLine();
            temp = ((String)e.getValue()).substring(((String)e.getValue()).lastIndexOf(47) + 1);
            mcpName = (String)e.getValue();
            if (fields.containsKey(temp)) {
                mcpName = mcpName.replace(temp, fields.get(temp));
            }
            notch2Mcp.write("FD: " + (String)e.getKey() + " " + mcpName);
            notch2Mcp.newLine();
            mcpToSrg.write("FD: " + mcpName + " " + (String)e.getValue());
            mcpToSrg.newLine();
            mcpToNotch.write("FD: " + mcpName + " " + (String)e.getKey());
            mcpToNotch.newLine();
        }
        for (Map.Entry e : inSrg.methodMap.entrySet()) {
            line = "MD: " + e.getKey() + " " + e.getValue();
            notch2Srg.write("MD: " + e.getKey() + " " + e.getValue());
            notch2Srg.newLine();
            temp = ((MethodData)e.getValue()).name.substring(((MethodData)e.getValue()).name.lastIndexOf(47) + 1);
            mcpName = ((MethodData)e.getValue()).toString();
            if (methods.containsKey(temp)) {
                mcpName = mcpName.replace(temp, methods.get(temp));
            }
            notch2Mcp.write("MD: " + e.getKey() + " " + mcpName);
            notch2Mcp.newLine();
            mcpToSrg.write("MD: " + mcpName + " " + e.getValue());
            mcpToSrg.newLine();
            mcpToNotch.write("MD: " + mcpName + " " + e.getKey());
            mcpToNotch.newLine();
        }
        notch2Srg.flush();
        notch2Srg.close();
        notch2Mcp.flush();
        notch2Mcp.close();
        mcpToSrg.flush();
        mcpToSrg.close();
        mcpToNotch.flush();
        mcpToNotch.close();
    }

    private void writeOutExcs(Map<String, String> excRemap, Map<String, String> methods) throws IOException {
        String[] split;
        Files.createParentDirs((File)this.getSrgExc());
        Files.createParentDirs((File)this.getMcpExc());
        BufferedWriter srgOut = Files.newWriter((File)this.getSrgExc(), (Charset)Charsets.UTF_8);
        BufferedWriter mcpOut = Files.newWriter((File)this.getMcpExc(), (Charset)Charsets.UTF_8);
        List excLines = Files.readLines((File)this.getInExc(), (Charset)Charsets.UTF_8);
        for (String line : excLines) {
            srgOut.write(line);
            srgOut.newLine();
            split = line.split("=");
            int sigIndex = split[0].indexOf(40);
            int dotIndex = split[0].indexOf(46);
            if (sigIndex == -1 || dotIndex == -1) {
                mcpOut.write(line);
                mcpOut.newLine();
                continue;
            }
            String name = split[0].substring(dotIndex + 1, sigIndex);
            if (methods.containsKey(name)) {
                name = methods.get(name);
            }
            mcpOut.write(split[0].substring(0, dotIndex) + name + split[0].substring(sigIndex) + "=" + split[1]);
            mcpOut.newLine();
        }
        for (File f : this.getExtraExcs()) {
            List lines = Files.readLines((File)f, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                mcpOut.write(line);
                mcpOut.newLine();
                split = line.split("=");
                int sigIndex = split[0].indexOf(40);
                int dotIndex = split[0].indexOf(46);
                if (sigIndex == -1 || dotIndex == -1) {
                    srgOut.write(line);
                    srgOut.newLine();
                    continue;
                }
                String name = split[0].substring(dotIndex + 1, sigIndex);
                if (excRemap.containsKey(name)) {
                    name = excRemap.get(name);
                }
                srgOut.write(split[0].substring(0, dotIndex) + name + split[0].substring(sigIndex) + "=" + split[1]);
                srgOut.newLine();
            }
        }
        srgOut.flush();
        srgOut.close();
        mcpOut.flush();
        mcpOut.close();
    }

    private static String remapMethodName(String name, Map<MethodData, MethodData> methodMap) {
        MethodData key = null;
        for (MethodData data : methodMap.keySet()) {
            if (!data.name.equals(name)) continue;
            key = data;
            break;
        }
        if (key == null) {
            return name;
        }
        return methodMap.get(key).name;
    }

    private static String remapSig(String sig, Map<String, String> classMap) {
        String[] params;
        StringBuilder newSig = new StringBuilder(sig.length()).append("(");
        for (String param : params = sig.substring(1, sig.lastIndexOf(41)).split(";")) {
            newSig.append(GenSrgTask.remap(param, classMap)).append(';');
        }
        newSig.append(')').append(GenSrgTask.remap(sig.substring(sig.lastIndexOf(41) + 1), classMap));
        return newSig.toString();
    }

    private static String remap(String thing, Map<String, String> map) {
        if (map.containsKey(thing)) {
            return map.get(thing);
        }
        return thing;
    }

    public File getInSrg() {
        return this.inSrg.call();
    }

    public void setInSrg(DelayedFile inSrg) {
        this.inSrg = inSrg;
    }

    public File getInExc() {
        return this.inExc.call();
    }

    public void setInExc(DelayedFile inSrg) {
        this.inExc = inSrg;
    }

    public File getMethodsCsv() {
        return this.methodsCsv.call();
    }

    public void setMethodsCsv(DelayedFile methodsCsv) {
        this.methodsCsv = methodsCsv;
    }

    public File getFieldsCsv() {
        return this.fieldsCsv.call();
    }

    public void setFieldsCsv(DelayedFile fieldsCsv) {
        this.fieldsCsv = fieldsCsv;
    }

    public File getNotchToSrg() {
        return this.notchToSrg.call();
    }

    public void setNotchToSrg(DelayedFile deobfSrg) {
        this.notchToSrg = deobfSrg;
    }

    public File getNotchToMcp() {
        return this.notchToMcp.call();
    }

    public void setNotchToMcp(DelayedFile deobfSrg) {
        this.notchToMcp = deobfSrg;
    }

    public File getMcpToSrg() {
        return this.mcpToSrg.call();
    }

    public void setMcpToSrg(DelayedFile reobfSrg) {
        this.mcpToSrg = reobfSrg;
    }

    public File getMcpToNotch() {
        return this.mcpToNotch.call();
    }

    public void setMcpToNotch(DelayedFile reobfSrg) {
        this.mcpToNotch = reobfSrg;
    }

    public File getSrgExc() {
        return this.srgExc.call();
    }

    public void setSrgExc(DelayedFile inSrg) {
        this.srgExc = inSrg;
    }

    public File getMcpExc() {
        return this.mcpExc.call();
    }

    public void setMcpExc(DelayedFile inSrg) {
        this.mcpExc = inSrg;
    }

    public FileCollection getExtraExcs() {
        return this.getProject().files(new Object[]{this.extraExcs});
    }

    public void addExtraExc(File file) {
        this.extraExcs.add(file);
    }

    public FileCollection getExtraSrgs() {
        return this.getProject().files(new Object[]{this.extraSrgs});
    }

    public void addExtraSrg(File file) {
        this.extraSrgs.add(file);
    }
}

