/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LiteLoaderJson {
    public MetaObject meta;
    public Map<String, VersionObject> versions;

    public static final class VersionAdapter
    implements JsonDeserializer<VersionObject> {
        public VersionObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            VersionObject obj = new VersionObject();
            obj.artifacts = new LinkedList<Artifact>();
            JsonObject groupLevel = json.getAsJsonObject().getAsJsonObject("artefacts");
            for (Map.Entry groupE : groupLevel.entrySet()) {
                String group = (String)groupE.getKey();
                for (Map.Entry artifactE : ((JsonElement)groupE.getValue()).getAsJsonObject().entrySet()) {
                    Artifact artifact = (Artifact)context.deserialize((JsonElement)artifactE.getValue(), Artifact.class);
                    artifact.group = group;
                    if ("latest".equals(artifactE.getKey())) {
                        obj.latest = artifact;
                        continue;
                    }
                    obj.artifacts.add(artifact);
                }
            }
            return obj;
        }
    }

    public static final class Artifact {
        public String group;
        public String md5;
        public String tweakClass;
        public String file;
        public String version;
        public String mcpJar;
        public String srcJar;
        public long timestamp;

        public boolean hasMcp() {
            return this.mcpJar != null;
        }

        public String getMcpDepString() {
            return this.group + ":" + this.version + ":" + "mcpnames";
        }
    }

    public static final class VersionObject {
        public Artifact latest;
        public List<Artifact> artifacts;
    }

    public static final class MetaObject {
        public String description;
        public String authors;
        public String url;
    }
}

