/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import joptsimple.internal.Strings;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.json.JsonFactory;
import net.minecraftforge.gradle.tasks.CopyAssetsTask;
import net.minecraftforge.gradle.tasks.DecompileTask;
import net.minecraftforge.gradle.tasks.GenSrgTask;
import net.minecraftforge.gradle.tasks.MergeJarsTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.SourceCopyTask;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class UserBasePlugin<T extends UserExtension>
extends BasePlugin<T> {
    private boolean hasAppliedJson = false;
    private boolean hasScalaBefore = false;
    private boolean hasGroovyBefore = false;

    @Override
    public void applyPlugin() {
        this.applyExternalPlugin("java");
        this.applyExternalPlugin("maven");
        this.applyExternalPlugin("eclipse");
        this.applyExternalPlugin("idea");
        this.hasScalaBefore = this.project.getPlugins().hasPlugin("scala");
        this.hasGroovyBefore = this.project.getPlugins().hasPlugin("groovy");
        this.configureDeps();
        this.configureCompilation();
        this.fixEclipseNatives();
        this.configureIntellij();
        this.tasks();
        DefaultTask task = this.makeTask("setupCIWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "deobfBinJar"});
        task.setDescription("Sets up the bare minimum to build a minecraft mod. Idea for CI servers");
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDevWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "deobfBinJar", "copyAssets", "extractNatives"});
        task.setDescription("CIWorkspace + natives and assets to run and test Minecraft");
        task.setGroup("ForgeGradle");
        task = this.makeTask("setupDecompWorkspace", DefaultTask.class);
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "repackMinecraft"});
        task.setDescription("DevWorkspace + the deobfuscated Minecraft source linked as a source jar.");
        task.setGroup("ForgeGradle");
    }

    protected abstract String getApiName();

    protected abstract String getSrcDepName();

    protected abstract String getBinDepName();

    protected abstract boolean hasApiVersion();

    protected abstract String getApiVersion(T var1);

    protected abstract String getMcVersion(T var1);

    protected abstract String getApiCacheDir(T var1);

    protected abstract String getUserDev();

    protected abstract String getClientRunClass();

    protected abstract Iterable<String> getClientRunArgs();

    protected abstract String getServerRunClass();

    protected abstract Iterable<String> getServerRunArgs();

    @Override
    public String resolve(String pattern, Project project, T exten) {
        pattern = pattern.replace("{API_CACHE_DIR}", this.getApiCacheDir(exten));
        pattern = pattern.replace("{MC_VERSION}", this.getMcVersion(exten));
        pattern = super.resolve(pattern, project, exten);
        if (this.hasApiVersion()) {
            pattern = pattern.replace("{API_VERSION}", this.getApiVersion(exten));
        }
        pattern = pattern.replace("{API_NAME}", this.getApiName());
        return pattern;
    }

    protected void configureDeps() {
        this.project.getConfigurations().create("userDevPackageDepConfig");
        this.project.getConfigurations().create("minecraftNatives");
        this.project.getConfigurations().create("minecraftDeps");
        this.project.getConfigurations().create("minecraft");
        ExtractTask extractUserDev = this.makeTask("extractUserDev", ExtractTask.class);
        extractUserDev.into(this.delayedFile("{API_CACHE_DIR}/unpacked"));
        extractUserDev.setDoesCache(true);
        extractUserDev.doLast((Action)new Action<Task>(){

            public void execute(Task arg0) {
                UserBasePlugin.this.readAndApplyJson(UserBasePlugin.this.getDevJson().call(), "minecraftDeps", "minecraftNatives", arg0.getLogger());
            }
        });
        ExtractTask extractNatives = this.makeTask("extractNatives", ExtractTask.class);
        extractNatives.into(this.delayedFile("{BUILD_DIR}/natives"));
        extractNatives.dependsOn(new Object[]{"extractUserDev"});
        this.project.getDependencies().add("compile", (Object)this.project.fileTree((Object)"libs"));
        this.project.getDependencies().add("compile", (Object)this.project.getConfigurations().getByName("minecraftDeps"));
        this.project.getDependencies().add("compile", (Object)this.project.getConfigurations().getByName("minecraft"));
    }

    protected void configureCompilation() {
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)javaConv.getSourceSets().getByName("test");
        SourceSet api = (SourceSet)javaConv.getSourceSets().create("api");
        javaConv.setSourceCompatibility((Object)"1.6");
        javaConv.setTargetCompatibility((Object)"1.6");
        main.setCompileClasspath(main.getCompileClasspath().plus((FileCollection)api.getOutput()));
        test.setCompileClasspath(test.getCompileClasspath().plus((FileCollection)api.getOutput()));
        this.project.getConfigurations().getByName("apiCompile").extendsFrom(new Configuration[]{this.project.getConfigurations().getByName("compile")});
        this.project.getConfigurations().getByName("testCompile").extendsFrom(new Configuration[]{this.project.getConfigurations().getByName("apiCompile")});
    }

    private void readAndApplyJson(File file, String depConfig, String nativeConfig, Logger log) {
        if (this.version == null) {
            try {
                this.version = JsonFactory.loadVersion(file);
            }
            catch (Exception e) {
                log.error("" + file + " could not be parsed");
                Throwables.propagate((Throwable)e);
            }
        }
        if (this.hasAppliedJson) {
            return;
        }
        DependencyHandler handler = this.project.getDependencies();
        if (this.project.getConfigurations().getByName(depConfig).getState() == Configuration.State.UNRESOLVED) {
            for (net.minecraftforge.gradle.json.version.Library lib : this.version.getLibraries()) {
                if (lib.natives != null) continue;
                handler.add(depConfig, (Object)lib.getArtifactName());
            }
        } else {
            log.info("RESOLVED: " + depConfig);
        }
        if (this.project.getConfigurations().getByName(nativeConfig).getState() == Configuration.State.UNRESOLVED) {
            for (net.minecraftforge.gradle.json.version.Library lib : this.version.getLibraries()) {
                if (lib.natives == null) continue;
                handler.add(nativeConfig, (Object)lib.getArtifactName());
            }
        } else {
            log.info("RESOLVED: " + nativeConfig);
        }
        this.hasAppliedJson = true;
        ExtractTask task = (ExtractTask)((Object)this.project.getTasks().findByName("extractNatives"));
        for (File dep : this.project.getConfigurations().getByName("minecraftNatives").getFiles()) {
            log.info("ADDING NATIVE: " + dep.getPath());
            task.from(this.delayedFile(dep.getAbsolutePath()));
            task.exclude("META-INF/**", "META-INF/**");
        }
    }

    protected void fixEclipseNatives() {
        EclipseModel eclipseConv = (EclipseModel)this.project.getExtensions().getByName("eclipse");
        eclipseConv.getClasspath().setDownloadJavadoc(true);
        eclipseConv.getClasspath().setDownloadSources(true);
        eclipseConv.getClasspath().getFile().getWhenMerged().add((Action)new Action<Classpath>(){

            public void execute(Classpath classpath) {
                String natives = UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call().replace('\\', '/');
                for (ClasspathEntry e : classpath.getEntries()) {
                    Library lib;
                    if (!(e instanceof Library) || !(lib = (Library)e).getPath().contains("lwjg") && !lib.getPath().contains("jinput")) continue;
                    lib.setNativeLibraryLocation(natives);
                }
            }
        });
        DefaultTask task = this.makeTask("afterEclipseImport", DefaultTask.class);
        task.doLast((Action)new Action<Object>(){

            public void execute(Object obj) {
                try {
                    Node root = new XmlParser().parseText(Files.toString((File)UserBasePlugin.this.project.file((Object)".classpath"), (Charset)Charset.defaultCharset()));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY");
                    map.put("value", UserBasePlugin.this.delayedString("{BUILD_DIR}/natives").call());
                    for (Node child : root.children()) {
                        if (!child.attribute((Object)"path").equals("org.springsource.ide.eclipse.gradle.classpathcontainer")) continue;
                        child.appendNode((Object)"attributes").appendNode((Object)"attribute", map);
                        break;
                    }
                    String result = XmlUtil.serialize((Node)root);
                    UserBasePlugin.this.project.getLogger().lifecycle(result);
                    Files.write((CharSequence)result, (File)UserBasePlugin.this.project.file((Object)".classpath"), (Charset)Charset.defaultCharset());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    protected void configureIntellij() {
        IdeaModel ideaConv = (IdeaModel)this.project.getExtensions().getByName("idea");
        ideaConv.getModule().getExcludeDirs().addAll(this.project.files(new Object[]{".gradle", "build", ".idea"}).getFiles());
        ideaConv.getModule().setDownloadJavadoc(true);
        ideaConv.getModule().setDownloadSources(true);
        DefaultTask task = this.makeTask("genIntellijRuns", DefaultTask.class);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                try {
                    String module = task.getProject().getProjectDir().getCanonicalPath();
                    File file = UserBasePlugin.this.project.file((Object)".idea/workspace.xml");
                    if (!file.exists()) {
                        throw new RuntimeException("Only run this task after importing a build.gradle file into intellij!");
                    }
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document doc = docBuilder.parse(file);
                    UserBasePlugin.this.injectIntellijRuns(doc, module);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    DOMSource source = new DOMSource(doc);
                    StreamResult result = new StreamResult(file);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (ideaConv.getWorkspace().getIws() == null) {
            return;
        }
        ideaConv.getWorkspace().getIws().withXml((Closure)new Closure<Object>((Object)this, null){

            public Object call(Object ... obj) {
                Element root = ((XmlProvider)this.getDelegate()).asElement();
                Document doc = root.getOwnerDocument();
                try {
                    UserBasePlugin.this.injectIntellijRuns(doc, UserBasePlugin.this.project.getProjectDir().getCanonicalPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public final void injectIntellijRuns(Document doc, String module) throws DOMException, IOException {
        String[][] config;
        Element root = null;
        NodeList list = doc.getElementsByTagName("component");
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            if (!"RunManager".equals(e.getAttribute("name"))) continue;
            root = e;
            break;
        }
        String natives = this.delayedFile("{BUILD_DIR}/natives").call().getCanonicalPath().replace(module, "$PROJECT_DIR$");
        for (String[] data : config = new String[][]{{"Minecraft Client", this.getClientRunClass(), "-Xincgc -Xmx1024M -Xms1024M -Djava.library.path=\"" + natives + "\" -Dfml.ignoreInvalidMinecraftCertificates=true", Joiner.on((char)' ').join(this.getClientRunArgs())}, {"Minecraft Server", this.getServerRunClass(), "-Xincgc -Dfml.ignoreInvalidMinecraftCertificates=true", Joiner.on((char)' ').join(this.getServerRunArgs())}}) {
            Element child = this.add(root, "configuration", "default", "false", "name", data[0], "type", "Application", "factoryName", "Application", "default", "false");
            this.add(child, "extension", "name", "coverage", "enabled", "false", "sample_coverage", "true", "runner", "idea");
            this.add(child, "option", "name", "MAIN_CLASS_NAME", "value", data[1]);
            this.add(child, "option", "name", "VM_PARAMETERS", "value", data[2]);
            this.add(child, "option", "name", "PROGRAM_PARAMETERS", "value", data[3]);
            this.add(child, "option", "name", "WORKING_DIRECTORY", "value", "file://" + this.delayedFile("{ASSET_DIR}").call().getParentFile().getCanonicalPath().replace(module, "$PROJECT_DIR$"));
            this.add(child, "option", "name", "ALTERNATIVE_JRE_PATH_ENABLED", "value", "false");
            this.add(child, "option", "name", "ALTERNATIVE_JRE_PATH", "value", "");
            this.add(child, "option", "name", "ENABLE_SWING_INSPECTOR", "value", "false");
            this.add(child, "option", "name", "ENV_VARIABLES");
            this.add(child, "option", "name", "PASS_PARENT_ENVS", "value", "true");
            this.add(child, "module", "name", ((IdeaModel)this.project.getExtensions().getByName("idea")).getModule().getName());
            this.add(child, "envs", new String[0]);
            this.add(child, "RunnerSettings", "RunnerId", "Run");
            this.add(child, "ConfigurationWrapper", "RunnerId", "Run");
            this.add(child, "method", new String[0]);
        }
    }

    private Element add(Element parent, String name, String ... values) {
        Element e = parent.getOwnerDocument().createElement(name);
        for (int x = 0; x < values.length; x += 2) {
            e.setAttribute(values[x], values[x + 1]);
        }
        parent.appendChild(e);
        return e;
    }

    private void tasks() {
        DefaultTask task = this.makeTask("copyAssets", CopyAssetsTask.class);
        task.setAssetsDir(this.delayedFile("{CACHE_DIR}/minecraft/assets"));
        task.setOutputDir(this.delayedFile("{ASSET_DIR}"));
        task.setAssetIndex(this.getAssetIndexClosure());
        task.dependsOn(new Object[]{"getAssets"});
        task = this.makeTask("genSrgs", GenSrgTask.class);
        task.setInSrg(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/packaged.srg"));
        task.setInExc(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/packaged.exc"));
        task.setMethodsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/methods.csv"));
        task.setFieldsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/fields.csv"));
        task.setNotchToSrg(this.delayedFile("{API_CACHE_DIR}/srgs/notch-srg.srg"));
        task.setNotchToMcp(this.delayedFile("{API_CACHE_DIR}/srgs/notch-mcp.srg"));
        task.setMcpToSrg(this.delayedFile("{API_CACHE_DIR}/srgs/mcp-srg.srg"));
        task.setMcpToNotch(this.delayedFile("{API_CACHE_DIR}/srgs/mcp-notch.srg"));
        task.setSrgExc(this.delayedFile("{API_CACHE_DIR}/srgs/srg.exc"));
        task.setMcpExc(this.delayedFile("{API_CACHE_DIR}/srgs/mcp.srg"));
        task.dependsOn(new Object[]{"extractUserDev"});
        task = this.makeTask("mergeJars", MergeJarsTask.class);
        task.setClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task.setServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task.setMergeCfg(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/mcp_merge.cfg"));
        task.dependsOn(new Object[]{"extractUserDev", "downloadClient", "downloadServer"});
        String name = this.getBinDepName() + "-" + (this.hasApiVersion() ? "{API_VERSION}" : "{MC_VERSION}") + ".jar";
        ProcessJarTask task2 = this.makeTask("deobfBinJar", ProcessJarTask.class);
        task2.setSrg(this.delayedFile("{API_CACHE_DIR}/srgs/notch-mcp.srg"));
        task2.setExceptorJson(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/exceptor.json"));
        task2.setExceptorCfg(this.delayedFile("{API_CACHE_DIR}/srgs/mcp.srg"));
        task2.setFieldCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/fields.csv"));
        task2.setMethodCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/methods.csv"));
        task2.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task2.setOutCleanJar(this.delayedFile("{API_CACHE_DIR}/" + name));
        task2.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/" + name));
        task2.setApplyMarkers(false);
        task2.setStripSynthetics(true);
        this.configureDeobfuscation(task2);
        task2.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs", "applyBinPatches"});
        name = "{API_NAME}-" + (this.hasApiVersion() ? "{API_VERSION}" : "{MC_VERSION}") + "-" + "srg" + ".jar";
        task2 = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        task2.setSrg(this.delayedFile("{API_CACHE_DIR}/srgs/notch-srg.srg"));
        task2.setExceptorJson(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/exceptor.json"));
        task2.setExceptorCfg(this.delayedFile("{API_CACHE_DIR}/srgs/srg.exc"));
        task2.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task2.setOutCleanJar(this.delayedFile("{API_CACHE_DIR}/" + name));
        task2.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/" + name));
        task2.setApplyMarkers(true);
        this.configureDeobfuscation(task2);
        task2.dependsOn(new Object[]{"downloadMcpTools", "mergeJars", "genSrgs"});
        task = this.makeTask("reobf", ReobfTask.class);
        task.dependsOn(new Object[]{"genSrgs"});
        task.setExceptorCfg(this.delayedFile("{API_CACHE_DIR}/srgs/srg.exc"));
        task.setSrg(this.delayedFile("{API_CACHE_DIR}/srgs/mcp-srg.srg"));
        task.setFieldCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/fields.csv"));
        task.setFieldCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/methods.csv"));
        task.reobf(this.project.getTasks().getByName("jar"), new Action<ArtifactSpec>(){

            public void execute(ArtifactSpec arg0) {
                JavaPluginConvention javaConv = (JavaPluginConvention)UserBasePlugin.this.project.getConvention().getPlugins().get("java");
                arg0.setClasspath(((SourceSet)javaConv.getSourceSets().getByName("main")).getCompileClasspath());
            }
        });
        task.mustRunAfter(new Object[]{"test"});
        this.project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
        this.project.getTasks().getByName("uploadArchives").dependsOn(new Object[]{task});
        this.createPostDecompTasks();
        this.createExecTasks();
        this.createSourceCopyTasks();
    }

    private final void createPostDecompTasks() {
        DelayedFile decompOut = this.delayedDirtyFile(null, "decomp", "jar");
        DelayedFile remapped = this.delayedDirtyFile(this.getSrcDepName(), "sources", "jar");
        final DelayedFile recomp = this.delayedDirtyFile(this.getSrcDepName(), null, "jar");
        DelayedFile recompSrc = this.delayedFile("{BUILD_DIR}/tmp/recompSrc");
        DelayedFile recompCls = this.delayedFile("{BUILD_DIR}/tmp/recompCls");
        DecompileTask decomp = this.makeTask("decompile", DecompileTask.class);
        decomp.setInJar(this.delayedDirtyFile(null, "srg", "jar"));
        decomp.setOutJar(decompOut);
        decomp.setFernFlower(this.delayedFile("{CACHE_DIR}/minecraft/fernflower-fixed.jar"));
        decomp.setPatch(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/minecraft_ff"));
        decomp.setAstyleConfig(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/astyle.cfg"));
        decomp.dependsOn(new Object[]{"downloadMcpTools", "deobfuscateJar", "genSrgs"});
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.setInJar(decompOut);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/params.csv"));
        remap.setDoesJavadocs(true);
        remap.dependsOn(new Object[]{decomp});
        Spec onlyIfCheck = new Spec(){

            public boolean isSatisfiedBy(Object obj) {
                boolean didWork = ((Task)obj).dependsOnTaskDidWork();
                boolean exists = recomp.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        };
        ExtractTask extract = this.makeTask("extractMinecraftSrc", ExtractTask.class);
        extract.from(remapped);
        extract.into(recompSrc);
        extract.setIncludeEmptyDirs(false);
        extract.dependsOn(new Object[]{remap});
        extract.onlyIf(onlyIfCheck);
        JavaCompile recompTask = this.makeTask("recompMinecraft", JavaCompile.class);
        recompTask.setSource((Object)recompSrc);
        recompTask.setSourceCompatibility("1.6");
        recompTask.setTargetCompatibility("1.6");
        recompTask.setClasspath((FileCollection)this.project.getConfigurations().getByName("minecraftDeps"));
        recompTask.dependsOn(new Object[]{extract});
        recompTask.onlyIf(onlyIfCheck);
        Jar repackageTask = this.makeTask("repackMinecraft", Jar.class);
        repackageTask.from(new Object[]{recompSrc});
        repackageTask.from(new Object[]{recompCls});
        repackageTask.exclude(new String[]{"*.java", "**/*.java", "**.java"});
        repackageTask.dependsOn(new Object[]{recompTask});
        repackageTask.onlyIf(onlyIfCheck);
    }

    private final void createExecTasks() {
        JavaExec exec = this.makeTask("runClient", JavaExec.class);
        exec.setMain(this.getClientRunClass());
        exec.jvmArgs(new Object[]{"-Xincgc", "-Xmx1024M", "-Xms1024M", "-Dfml.ignoreInvalidMinecraftCertificates=true"});
        exec.args(this.getClientRunArgs());
        exec.workingDir((Object)this.delayedFile("{ASSET_DIR}/.."));
        exec.setStandardOutput((OutputStream)System.out);
        exec.setErrorOutput((OutputStream)System.err);
        exec.setGroup("ForgeGradle");
        exec.setDescription("Runs the Minecraft client");
        exec = this.makeTask("runServer", JavaExec.class);
        exec.setMain(this.getServerRunClass());
        exec.jvmArgs(new Object[]{"-Xincgc", "-Dfml.ignoreInvalidMinecraftCertificates=true"});
        exec.workingDir((Object)this.delayedFile("{ASSET_DIR}/.."));
        exec.args(this.getServerRunArgs());
        exec.setStandardOutput((OutputStream)System.out);
        exec.setStandardInput(System.in);
        exec.setErrorOutput((OutputStream)System.err);
        exec.setGroup("ForgeGradle");
        exec.setDescription("Runs the Minecraft Server");
        exec = this.makeTask("debugClient", JavaExec.class);
        exec.setMain(this.getClientRunClass());
        exec.jvmArgs(new Object[]{"-Xincgc", "-Xmx1024M", "-Xms1024M", "-Dfml.ignoreInvalidMinecraftCertificates=true"});
        exec.args(this.getClientRunArgs());
        exec.workingDir((Object)this.delayedFile("{ASSET_DIR}/.."));
        exec.setStandardOutput((OutputStream)System.out);
        exec.setErrorOutput((OutputStream)System.err);
        exec.setDebug(true);
        exec.setGroup("ForgeGradle");
        exec.setDescription("Runs the Minecraft client in debug mode");
        exec = this.makeTask("debugServer", JavaExec.class);
        exec.setMain(this.getServerRunClass());
        exec.jvmArgs(new Object[]{"-Xincgc", "-Dfml.ignoreInvalidMinecraftCertificates=true"});
        exec.workingDir((Object)this.delayedFile("{ASSET_DIR}/.."));
        exec.args(this.getServerRunArgs());
        exec.setStandardOutput((OutputStream)System.out);
        exec.setStandardInput(System.in);
        exec.setErrorOutput((OutputStream)System.err);
        exec.setDebug(true);
        exec.setGroup("ForgeGradle");
        exec.setDescription("Runs the Minecraft serevr in debug mode");
    }

    private final void createSourceCopyTasks() {
        ScalaCompile compile;
        DelayedFile dir;
        ScalaSourceSet set;
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        DelayedFile dir2 = this.delayedFile("{BUILD_DIR}/sources/java");
        SourceCopyTask task = this.makeTask("sourceMainJava", SourceCopyTask.class);
        task.setSource(main.getJava());
        task.replace(((UserExtension)this.getExtension()).getReplacements());
        task.include(((UserExtension)this.getExtension()).getIncludes());
        task.setOutput(dir2);
        JavaCompile compile2 = (JavaCompile)this.project.getTasks().getByName(main.getCompileJavaTaskName());
        compile2.dependsOn(new Object[]{"sourceMainJava"});
        compile2.setSource((Object)dir2);
        if (this.project.getPlugins().hasPlugin("scala")) {
            set = (ScalaSourceSet)new DslObject((Object)main).getConvention().getPlugins().get("scala");
            dir = this.delayedFile("{BUILD_DIR}/sources/scala");
            task = this.makeTask("sourceMainScala", SourceCopyTask.class);
            task.setSource(set.getScala());
            task.replace(((UserExtension)this.getExtension()).getReplacements());
            task.include(((UserExtension)this.getExtension()).getIncludes());
            task.setOutput(dir);
            compile = (ScalaCompile)this.project.getTasks().getByName(main.getCompileTaskName("scala"));
            compile.dependsOn(new Object[]{"sourceMainScala"});
            compile.setSource((Object)dir);
        }
        if (this.project.getPlugins().hasPlugin("groovy")) {
            set = (GroovySourceSet)new DslObject((Object)main).getConvention().getPlugins().get("groovy");
            dir = this.delayedFile("{BUILD_DIR}/sources/groovy");
            task = this.makeTask("sourceMainGroovy", SourceCopyTask.class);
            task.setSource(set.getGroovy());
            task.replace(((UserExtension)this.getExtension()).getReplacements());
            task.include(((UserExtension)this.getExtension()).getIncludes());
            task.setOutput(dir);
            compile = (GroovyCompile)this.project.getTasks().getByName(main.getCompileTaskName("groovy"));
            compile.dependsOn(new Object[]{"sourceMainGroovy"});
            compile.setSource((Object)dir);
        }
    }

    @Override
    public final void afterEvaluate() {
        super.afterEvaluate();
        String apiVersion = this.getApiVersion((UserExtension)this.getExtension());
        int buildNumber = Integer.parseInt(apiVersion.substring(apiVersion.lastIndexOf(46) + 1));
        this.doVersionChecks(buildNumber);
        if (!this.hasScalaBefore && this.project.getPlugins().hasPlugin("scala")) {
            throw new RuntimeException(this.delayedString("You have applied the 'scala' plugin after '{API_NAME}', you must apply it before.").call());
        }
        if (!this.hasGroovyBefore && this.project.getPlugins().hasPlugin("groovy")) {
            throw new RuntimeException(this.delayedString("You have applied the 'groovy' plugin after '{API_NAME}', you must apply it before.").call());
        }
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)(this.delayedString(this.getUserDev()).call() + ":userdev"));
        if (this.getDevJson().call().exists()) {
            this.readAndApplyJson(this.getDevJson().call(), "minecraftDeps", "minecraftNatives", this.project.getLogger());
        }
        this.delayedTaskConfig();
        File decompFile = this.delayedDirtyFile(this.getSrcDepName(), "sources", "jar").call();
        if (decompFile.exists()) {
            ((UserExtension)this.getExtension()).setDecomp();
        }
        this.configurePostDecomp(((UserExtension)this.getExtension()).isDecomp());
    }

    protected void delayedTaskConfig() {
        ((ExtractTask)((Object)this.project.getTasks().findByName("extractUserDev"))).from(this.delayedFile(this.project.getConfigurations().getByName("userDevPackageDepConfig").getSingleFile().getAbsolutePath()));
        ((Task)this.project.getTasks().findByName("getAssetsIndex")).dependsOn(new Object[]{"extractUserDev"});
        ((ReobfTask)this.project.getTasks().getByName("reobf")).setExtraSrg(((UserExtension)this.getExtension()).getSrgExtra());
        JavaCompile compile = (JavaCompile)this.project.getTasks().getByName("recompMinecraft");
        compile.setDestinationDir(this.delayedFile("{BUILD_DIR}/tmp/recompCls").call());
        Jar repackageTask = (Jar)this.project.getTasks().getByName("repackMinecraft");
        DelayedFile recomp = this.delayedDirtyFile(this.getSrcDepName(), null, "jar");
        File out = recomp.call();
        repackageTask.setArchiveName(out.getName());
        repackageTask.setDestinationDir(out.getParentFile());
        Jar jarTask = (Jar)this.project.getTasks().getByName("jar");
        JavaExec exec = (JavaExec)this.project.getTasks().getByName("runClient");
        exec.jvmArgs(new Object[]{"-Djava.library.path=" + this.delayedFile("{BUILD_DIR}/natives").call().getAbsolutePath()});
        exec.classpath(new Object[]{this.project.getConfigurations().getByName("runtime")});
        exec.classpath(new Object[]{jarTask.getArchivePath()});
        exec.dependsOn(new Object[]{jarTask});
        exec = (JavaExec)this.project.getTasks().getByName("runServer");
        exec.classpath(new Object[]{this.project.getConfigurations().getByName("runtime")});
        exec.classpath(new Object[]{jarTask.getArchivePath()});
        exec.dependsOn(new Object[]{jarTask});
        exec = (JavaExec)this.project.getTasks().getByName("debugClient");
        exec.jvmArgs(new Object[]{"-Djava.library.path=" + this.delayedFile("{BUILD_DIR}/natives").call().getAbsolutePath()});
        exec.classpath(new Object[]{this.project.getConfigurations().getByName("runtime")});
        exec.classpath(new Object[]{jarTask.getArchivePath()});
        exec.dependsOn(new Object[]{jarTask});
        exec = (JavaExec)this.project.getTasks().getByName("debugServer");
        exec.classpath(new Object[]{this.project.getConfigurations().getByName("runtime")});
        exec.classpath(new Object[]{jarTask.getArchivePath()});
        exec.dependsOn(new Object[]{jarTask});
    }

    protected void configurePostDecomp(boolean decomp) {
        if (decomp) {
            ((ReobfTask)this.project.getTasks().getByName("reobf")).setDeobfFile(((ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar")).getDelayedOutput());
            ((ReobfTask)this.project.getTasks().getByName("reobf")).setRecompFile(this.delayedDirtyFile(this.getSrcDepName(), null, "jar"));
        } else {
            this.project.getTasks().getByName("compileJava").dependsOn(new Object[]{"deobfBinJar"});
            this.project.getTasks().getByName("compileApiJava").dependsOn(new Object[]{"deobfBinJar"});
        }
    }

    protected abstract void configureDeobfuscation(ProcessJarTask var1);

    protected abstract void doVersionChecks(int var1);

    protected DelayedFile delayedDirtyFile(final String name, final String classifier, final String ext) {
        return new DelayedFile(this.project, "", new DelayedBase.IDelayedResolver[]{this}){

            @Override
            public File call() {
                ProcessJarTask decompDeobf = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
                this.pattern = (decompDeobf.isClean() ? "{API_CACHE_DIR}" : "{BUILD_DIR}/dirtyArtifacts") + "/";
                this.pattern = !Strings.isNullOrEmpty((String)name) ? this.pattern + name : this.pattern + "{API_NAME}";
                this.pattern = this.pattern + "-" + (UserBasePlugin.this.hasApiVersion() ? "{API_VERSION}" : "{MC_VERSION}");
                if (!Strings.isNullOrEmpty((String)classifier)) {
                    this.pattern = this.pattern + "-" + classifier;
                }
                if (!Strings.isNullOrEmpty((String)ext)) {
                    this.pattern = this.pattern + "." + ext;
                }
                return super.call();
            }
        };
    }
}

