/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user.patch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.ProcessSrcJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.user.ApplyBinPatchesTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.patch.UserPackExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public abstract class UserPatchBasePlugin
extends UserBasePlugin<UserPackExtension> {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ApplyBinPatchesTask task = this.makeTask("applyBinPatches", ApplyBinPatchesTask.class);
        task.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task.setOutJar(this.delayedFile("{API_CACHE_DIR}/{API_NAME}-binpatched-{API_VERSION}.jar"));
        task.setPatches(this.delayedFile("{API_CACHE_DIR}/unpacked/devbinpatches.pack.lzma"));
        task.setClassesJar(this.delayedFile("{API_CACHE_DIR}/unpacked/binaries.jar"));
        task.setResources(this.delayedFileTree("{API_CACHE_DIR}/unpacked/src/main/resources"));
        task.dependsOn(new Object[]{"mergeJars"});
        this.project.getTasks().getByName("deobfBinJar").dependsOn(new Object[]{task});
        ProcessJarTask deobf = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar").dependsOn(new Object[]{task});
        deobf.setInJar(this.delayedFile("{API_CACHE_DIR}/{API_NAME}-binpatched-{API_VERSION}.jar"));
        deobf.dependsOn(new Object[]{task});
        DelayedFile decompOut = this.delayedDirtyFile(null, "decomp", "jar");
        DelayedFile processed = this.delayedDirtyFile(null, "patched", "jar");
        ProcessSrcJarTask patch = this.makeTask("processSources", ProcessSrcJarTask.class);
        patch.dependsOn(new Object[]{"decompile"});
        patch.setInJar(decompOut);
        patch.setOutJar(processed);
        this.configurePatching(patch);
        RemapSourcesTask remap = (RemapSourcesTask)this.project.getTasks().getByName("remapJar");
        remap.setInJar(processed);
        remap.dependsOn(new Object[]{patch});
        this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Object>((Object)this, null){

            public Object call() {
                String path;
                TaskExecutionGraph graph = UserPatchBasePlugin.this.project.getGradle().getTaskGraph();
                if (graph.hasTask((path = UserPatchBasePlugin.this.project.getPath()) + "setupDecompWorkspace")) {
                    ((UserPackExtension)UserPatchBasePlugin.this.getExtension()).setDecomp();
                    UserPatchBasePlugin.this.setMinecraftDeps(true, false);
                }
                return null;
            }

            public Object call(Object obj) {
                return this.call();
            }

            public Object call(Object ... obj) {
                return this.call();
            }
        });
        this.project.getTasks().getByName("eclipse").doLast(new Action(){

            public void execute(Object arg0) {
                File f = new File("eclipse/.metadata/.plugins/org.eclipse.core.resources/.projects/Minecraft/.location");
                if (f.exists()) {
                    String projectDir = "URI//" + UserPatchBasePlugin.this.project.getProjectDir().toURI().toString();
                    try {
                        byte[] LOCATION_BEFORE = new byte[]{64, -79, -117, -127, 35, -68, 0, 20, 26, 37, -106, -25, -93, -109, -66, 30};
                        byte[] LOCATION_AFTER = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, 88, -5, -13, 35, -68, 0, 20, 26, 81, -13, -116, 123, -69, 119, -58};
                        FileOutputStream fos = new FileOutputStream(f);
                        fos.write(LOCATION_BEFORE);
                        fos.write((byte)((projectDir.length() & 0xFF) >> 8));
                        fos.write((byte)((projectDir.length() & 0xFF) >> 0));
                        fos.write(projectDir.getBytes());
                        fos.write(LOCATION_AFTER);
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    protected void delayedTaskConfig() {
        ProcessJarTask binDeobf = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        ProcessJarTask decompDeobf = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        Object[] extAts = ((UserPackExtension)this.getExtension()).getAccessTransformers().toArray();
        binDeobf.addTransformer(extAts);
        decompDeobf.addTransformer(extAts);
        JavaPluginConvention javaConv = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
        SourceSet main = (SourceSet)javaConv.getSourceSets().getByName("main");
        SourceSet api = (SourceSet)javaConv.getSourceSets().getByName("api");
        for (File at : main.getResources().getFiles()) {
            if (!at.getName().toLowerCase().endsWith("_at.cfg")) continue;
            this.project.getLogger().lifecycle("Found AccessTransformer in main resources: " + at.getName());
            binDeobf.addTransformer(at);
            decompDeobf.addTransformer(at);
        }
        for (File at : api.getResources().getFiles()) {
            if (!at.getName().toLowerCase().endsWith("_at.cfg")) continue;
            this.project.getLogger().lifecycle("Found AccessTransformer in api resources: " + at.getName());
            binDeobf.addTransformer(at);
            decompDeobf.addTransformer(at);
        }
        super.delayedTaskConfig();
        final String repoDir = this.delayedDirtyFile("this", "doesnt", "matter").call().getParentFile().getAbsolutePath();
        this.project.allprojects((Action)new Action<Project>(){

            public void execute(Project proj) {
                UserPatchBasePlugin.this.addFlatRepo(proj, UserPatchBasePlugin.this.getApiName() + "FlatRepo", repoDir);
                proj.getLogger().info("Adding repo to " + proj.getPath() + " >> " + repoDir);
            }
        });
    }

    @Override
    protected void configurePostDecomp(boolean decomp) {
        this.setMinecraftDeps(decomp, false);
    }

    private final void setMinecraftDeps(boolean decomp, boolean remove) {
        String version = this.getApiVersion((UserPackExtension)this.getExtension());
        if (decomp) {
            this.project.getDependencies().add("minecraft", (Object)ImmutableMap.of((Object)"name", (Object)this.getSrcDepName(), (Object)"version", (Object)version));
            if (remove) {
                this.project.getConfigurations().getByName("minecraft").exclude((Map)ImmutableMap.of((Object)"module", (Object)this.getBinDepName()));
            }
        } else {
            this.project.getDependencies().add("minecraft", (Object)ImmutableMap.of((Object)"name", (Object)this.getBinDepName(), (Object)"version", (Object)version));
            if (remove) {
                this.project.getConfigurations().getByName("minecraft").exclude((Map)ImmutableMap.of((Object)"module", (Object)this.getSrcDepName()));
            }
        }
    }

    @Override
    protected DelayedFile getDevJson() {
        return this.delayedFile("{API_CACHE_DIR}/unpacked/dev.json");
    }

    @Override
    protected String getSrcDepName() {
        return this.getApiName() + "Src";
    }

    @Override
    protected String getBinDepName() {
        return this.getApiName() + "Bin";
    }

    @Override
    protected boolean hasApiVersion() {
        return true;
    }

    @Override
    protected String getApiCacheDir(UserPackExtension exten) {
        return "{CACHE_DIR}/minecraft/{API_NAME}/" + this.getApiGroup().replace('.', '/') + "/{API_NAME}/{API_VERSION}";
    }

    @Override
    protected String getUserDev() {
        return this.getApiGroup() + ":{API_NAME}:{API_VERSION}";
    }

    @Override
    protected Class<UserPackExtension> getExtensionClass() {
        return UserPackExtension.class;
    }

    @Override
    protected String getApiVersion(UserPackExtension exten) {
        return exten.getApiVersion();
    }

    @Override
    protected String getMcVersion(UserPackExtension exten) {
        return exten.getVersion();
    }

    @Override
    protected String getClientRunClass() {
        return "net.minecraft.launchwrapper.Launch";
    }

    @Override
    protected Iterable<String> getClientRunArgs() {
        return ImmutableList.of((Object)"--version", (Object)"1.7", (Object)"--tweakClass", (Object)"cpw.mods.fml.common.launcher.FMLTweaker", (Object)"--username=ForgeDevName", (Object)"--accessToken FML");
    }

    @Override
    protected String getServerRunClass() {
        return "cpw.mods.fml.relauncher.ServerLaunchWrapper";
    }

    @Override
    protected Iterable<String> getServerRunArgs() {
        return new ArrayList<String>(0);
    }

    protected abstract void configurePatching(ProcessSrcJarTask var1);

    protected abstract String getApiGroup();
}

