/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.DownloadTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.user.reobf.ReobfTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forgeBin-{API_VERSION}.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forgeBin-{API_VERSION}.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-srg.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forge-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "repackForge"});
    }

    @Override
    public void afterEvaluate() {
        String apiVersion = ((UserExtension)this.getExtension()).getApiVersion();
        int buildNumber = Integer.parseInt(apiVersion.substring(apiVersion.lastIndexOf(46) + 1));
        if (buildNumber < 1048) {
            throw new IllegalArgumentException("ForgeGradle 1.2 only works for Forge versions 10.12.0.1048+");
        }
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)("net.minecraftforge:forge:" + apiVersion + ":userdev@jar"));
        super.afterEvaluate();
        ProcessJarTask deobf = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        boolean clean = deobf.isClean();
        DownloadTask dl = this.makeTask("getJavadocs", DownloadTask.class);
        dl.setUrl(this.delayedString("http://files.minecraftforge.net/maven/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-javadoc.zip"));
        dl.setOutput(this.delayedFile((clean ? this.getCacheDir() : "{BUILD_DIR}/dirtyArtifacts") + "/forgeBin-{API_VERSION}-javadoc.jar"));
        deobf.dependsOn(new Object[]{dl});
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{API_CACHE_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformerClean(this.delayedFile("{API_CACHE_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar");
    }

    @Override
    protected String getDecompOut() {
        return "/forge-{API_VERSION}-decomp.jar";
    }

    @Override
    protected String getCacheDir() {
        return "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}";
    }

    @Override
    protected void createMcModuleDep(boolean isClean, DependencyHandler depHandler, String depConfig) {
        final String repoDir = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts").call().getAbsolutePath();
        this.project.allprojects((Action)new Action<Project>(){

            public void execute(Project proj) {
                ForgeUserPlugin.this.addFlatRepo(proj, "forgeFlatRepo", repoDir);
                proj.getLogger().info("Adding repo to " + proj.getPath() + " >> " + repoDir);
            }
        });
        if (((UserExtension)this.getExtension()).isDecomp) {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"forgeSrc", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        } else {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"forgeBin", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        }
    }

    @Override
    public void finalCall() {
        super.finalCall();
        if (((UserExtension)this.getExtension()).isDecomp) {
            boolean isClean = ((ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar")).isClean();
            ((ReobfTask)this.project.getTasks().getByName("reobf")).setRecompFile(this.delayedFile((isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts") + "/forgeSrc-{API_VERSION}.jar"));
        }
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        String prefix = isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        DelayedFile fmled = this.delayedFile(prefix + "/forge-{API_VERSION}-fmled.jar");
        final DelayedFile injected = this.delayedFile(prefix + "/forge-{API_VERSION}-fmlinjected.jar");
        DelayedFile forged = this.delayedFile(prefix + "/forge-{API_VERSION}-forged.jar");
        DelayedFile remapped = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}-sources.jar");
        final DelayedFile forgeRecomp = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}.jar");
        DelayedFile recompSrc = this.delayedFile("{BUILD_DIR}/tmp/recompSrc");
        DelayedFile recompCls = this.delayedFile("{BUILD_DIR}/tmp/recompCls");
        Spec onlyIfCheck = new Spec(){

            public boolean isSatisfiedBy(Object obj) {
                boolean didWork = ((Task)obj).dependsOnTaskDidWork();
                boolean exists = forgeRecomp.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        };
        final PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{API_CACHE_DIR}/unpacked/fmlpatches.zip"));
        Zip inject = this.makeTask("addSources", Zip.class);
        inject.dependsOn(new Object[]{fmlPatches});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{API_CACHE_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{API_CACHE_DIR}/unpacked/src/main/resources")});
        inject.onlyIf(new Spec(){

            public boolean isSatisfiedBy(Object o) {
                boolean didWork = fmlPatches.getDidWork();
                boolean exists = injected.call().exists();
                if (!exists) {
                    return true;
                }
                return didWork;
            }
        });
        File injectFile = injected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        PatchJarTask forgePatches = this.makeTask("doForgePatches", PatchJarTask.class);
        forgePatches.dependsOn(new Object[]{inject});
        forgePatches.setInJar(injected);
        forgePatches.setOutJar(forged);
        forgePatches.setInPatches(this.delayedFile("{API_CACHE_DIR}/unpacked/forgepatches.zip"));
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.dependsOn(new Object[]{forgePatches});
        remap.setInJar(forged);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{API_CACHE_DIR}/unpacked/conf/params.csv"));
        remap.setDoesJavadocs(true);
        ExtractTask extract = this.makeTask("extractForgeSrc", ExtractTask.class);
        extract.from(remapped);
        extract.into(recompSrc);
        extract.setIncludeEmptyDirs(false);
        extract.dependsOn(new Object[]{remap});
        extract.onlyIf(onlyIfCheck);
        JavaCompile recompTask = this.makeTask("recompForge", JavaCompile.class);
        recompTask.setSource((Object)recompSrc);
        recompTask.setDestinationDir(recompCls.call());
        recompTask.setSourceCompatibility("1.6");
        recompTask.setTargetCompatibility("1.6");
        recompTask.setClasspath((FileCollection)this.project.getConfigurations().getByName("minecraftDeps"));
        recompTask.dependsOn(new Object[]{extract});
        recompTask.onlyIf(onlyIfCheck);
        Jar repackageTask = this.makeTask("repackForge", Jar.class);
        repackageTask.from(new Object[]{recompSrc});
        repackageTask.from(new Object[]{recompCls});
        repackageTask.exclude(new String[]{"*.java", "**/*.java", "**.java"});
        repackageTask.dependsOn(new Object[]{recompTask});
        File out = forgeRecomp.call();
        repackageTask.setArchiveName(out.getName());
        repackageTask.setDestinationDir(out.getParentFile());
        repackageTask.onlyIf(onlyIfCheck);
    }
}

