/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.io.File;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.abstractutil.DownloadTask;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forgeBin-{API_VERSION}.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forgeBin-{API_VERSION}.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-srg.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forge-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "repackForge"});
    }

    @Override
    public void afterEvaluate() {
        String depBase = "net.minecraftforge:forge:" + ((UserExtension)this.getExtension()).getApiVersion();
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)(depBase + ":userdev@jar"));
        super.afterEvaluate();
        ProcessJarTask deobf = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        boolean clean = deobf.isClean();
        DownloadTask dl = this.makeTask("getJavadocs", DownloadTask.class);
        dl.setUrl(this.delayedString("http://files.minecraftforge.net/maven/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-javadoc.zip"));
        dl.setOutput(this.delayedFile((clean ? this.getCacheDir() : "{BUILD_DIR}/dirtyArtifacts") + "/forgeBin-{API_VERSION}-javadoc.jar"));
        deobf.dependsOn(new Object[]{dl});
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar");
    }

    @Override
    protected String getDecompOut() {
        return "/forge-{API_VERSION}-decomp.jar";
    }

    @Override
    protected String getCacheDir() {
        return "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}";
    }

    @Override
    protected void createMcModuleDep(boolean isClean, DependencyHandler depHandler, String depConfig) {
        final String repoDir = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts").call().getAbsolutePath();
        this.project.allprojects((Action)new Action<Project>(){

            public void execute(Project proj) {
                ForgeUserPlugin.this.addFlatRepo(proj, "forgeFlatRepo", repoDir);
                proj.getLogger().info("Adding repo to " + proj.getPath() + " >> " + repoDir);
            }
        });
        if (((UserExtension)this.getExtension()).isDecomp) {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"forgeSrc", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        } else {
            depHandler.add(depConfig, (Object)ImmutableMap.of((Object)"name", (Object)"forgeBin", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        }
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        String prefix = isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        DelayedFile fmled = this.delayedFile(prefix + "/forge-{API_VERSION}-fmled.jar");
        DelayedFile injected = this.delayedFile(prefix + "/forge-{API_VERSION}-fmlinjected.jar");
        DelayedFile remapped = this.delayedFile(prefix + "/forge-{API_VERSION}-mcped.jar");
        DelayedFile forged = this.delayedFile(prefix + "/forge-{API_VERSION}-src-nojd.jar");
        DelayedFile forgeJavaDocced = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}-sources.jar");
        DelayedFile forgeRecomp = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}.jar");
        DelayedFile recompSrc = this.delayedFile("{BUILD_DIR}/tmp/recompSrc");
        DelayedFile recompCls = this.delayedFile("{BUILD_DIR}/tmp/recompCls");
        PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        final Zip inject = this.makeTask("addSources", Zip.class);
        inject.getOutputs().upToDateWhen((Closure)new Closure<Boolean>(null){
            private static final long serialVersionUID = -8480140049890357630L;

            public Boolean call(Object o) {
                return !inject.dependsOnTaskDidWork();
            }
        });
        inject.dependsOn(new Object[]{fmlPatches});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        File injectFile = injected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        PatchJarTask forgePatches = this.makeTask("doForgePatches", PatchJarTask.class);
        forgePatches.dependsOn(new Object[]{inject});
        forgePatches.setInJar(injected);
        forgePatches.setOutJar(forged);
        forgePatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/forgepatches.zip"));
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.dependsOn(new Object[]{inject});
        remap.setInJar(forged);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        remap.setDoesJavadocs(true);
        RemapSourcesTask javadocRemap = this.makeTask("addForgeJavadoc", RemapSourcesTask.class);
        javadocRemap.dependsOn(new Object[]{forgePatches});
        javadocRemap.setInJar(forged);
        javadocRemap.setOutJar(forgeJavaDocced);
        javadocRemap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        javadocRemap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        javadocRemap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        javadocRemap.setDoesJavadocs(true);
        ExtractTask extract = this.makeTask("extractForgeSrc", ExtractTask.class);
        extract.from(forgeJavaDocced);
        extract.into(recompSrc);
        extract.setIncludeEmptyDirs(false);
        extract.dependsOn(new Object[]{javadocRemap});
        extract.onlyIf(new Closure(this, this){

            public Boolean call(Object obj) {
                return ((Task)obj).dependsOnTaskDidWork();
            }
        });
        JavaCompile recompTask = this.makeTask("recompForge", JavaCompile.class);
        recompTask.setSource((Object)recompSrc);
        recompTask.setDestinationDir(recompCls.call());
        recompTask.setSourceCompatibility("1.6");
        recompTask.setTargetCompatibility("1.6");
        recompTask.setClasspath((FileCollection)this.project.getConfigurations().getByName("minecraftDeps"));
        recompTask.dependsOn(new Object[]{extract});
        recompTask.onlyIf(new Closure(this, this){

            public Boolean call(Object obj) {
                return ((Task)obj).dependsOnTaskDidWork();
            }
        });
        Jar repackageTask = this.makeTask("repackForge", Jar.class);
        repackageTask.from(new Object[]{recompSrc});
        repackageTask.from(new Object[]{recompCls});
        repackageTask.exclude(new String[]{"*.java", "**/*.java", "**.java"});
        repackageTask.dependsOn(new Object[]{recompTask});
        File out = forgeRecomp.call();
        repackageTask.setArchiveName(out.getName());
        repackageTask.setDestinationDir(out.getParentFile());
        repackageTask.onlyIf(new Closure(this, this){

            public Boolean call(Object obj) {
                return ((Task)obj).dependsOnTaskDidWork();
            }
        });
    }
}

