/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.gradle.SequencedInputSupplier;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExtractS2SRangeTask
extends DefaultTask {
    @InputFiles
    private FileCollection libs;
    private DelayedFile projectFile;
    private String projectConfig;
    private boolean includeJar = false;
    private final List<DelayedFile> in = new LinkedList<DelayedFile>();
    @OutputFile
    private DelayedFile rangeMap;

    @TaskAction
    public void doTask() throws IOException {
        SequencedInputSupplier inSup;
        List<File> ins = this.getIn();
        File rangemap = this.getRangeMap();
        if (ins.size() == 0) {
            return;
        }
        if (ins.size() == 1) {
            inSup = this.getInput(ins.get(0));
        } else {
            inSup = new SequencedInputSupplier();
            for (File f : ins) {
                inSup.add(this.getInput(f));
            }
        }
        this.generateRangeMap(inSup, rangemap);
    }

    private void generateRangeMap(InputSupplier inSup, File rangeMap) {
        RangeExtractor extractor = new RangeExtractor();
        extractor.addLibs(this.getLibs().getAsPath()).setSrc(inSup);
        PrintStream stream = new PrintStream(Constants.createLogger(this.getLogger(), LogLevel.DEBUG));
        extractor.setOutLogger(stream);
        boolean worked = extractor.generateRangeMap(rangeMap);
        stream.close();
        if (!worked) {
            throw new RuntimeException("RangeMap generation Failed!!!");
        }
    }

    private InputSupplier getInput(File f) throws IOException {
        if (f.isDirectory()) {
            return new FolderSupplier(f);
        }
        if (f.getPath().endsWith(".jar") || f.getPath().endsWith(".zip")) {
            ZipInputSupplier supp = new ZipInputSupplier();
            supp.readZip(f);
            return supp;
        }
        throw new IllegalArgumentException("Can only make suppliers out of directories and zips right now!");
    }

    public File getRangeMap() {
        return this.rangeMap.call();
    }

    public void setRangeMap(DelayedFile out) {
        this.rangeMap = out;
    }

    @InputFiles
    public FileCollection getIns() {
        return this.getProject().files(new Object[]{this.in});
    }

    public List<File> getIn() {
        LinkedList<File> files = new LinkedList<File>();
        for (DelayedFile f : this.in) {
            files.add(f.call());
        }
        return files;
    }

    public void addIn(DelayedFile in) {
        this.in.add(in);
    }

    public FileCollection getLibs() {
        if (this.projectFile != null && this.libs == null) {
            Project proj = BasePlugin.getProject(this.projectFile.call(), this.getProject());
            this.libs = proj.getConfigurations().getByName(this.projectConfig);
            if (this.includeJar) {
                AbstractTask jarTask = (AbstractTask)proj.getTasks().getByName("jar");
                this.executeTask(jarTask);
                File compiled = (File)jarTask.property("archivePath");
                this.libs = this.getProject().files(new Object[]{compiled, this.libs});
            }
        }
        return this.libs;
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    public void setLibs(FileCollection libs) {
        this.libs = libs;
    }

    public void setLibsFromProject(DelayedFile buildscript, String config, boolean includeJar) {
        this.projectFile = buildscript;
        this.projectConfig = config;
        this.includeJar = includeJar;
    }
}

