/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;

public class MultiDirSupplier
implements InputSupplier,
OutputSupplier {
    private final List<File> dirs;

    public MultiDirSupplier(Iterable<File> dirs) {
        this.dirs = ImmutableList.copyOf(dirs);
    }

    public void close() throws IOException {
    }

    public OutputStream getOutput(String relPath) {
        File f = this.getFileFor(relPath);
        try {
            return f == null ? null : (FileOutputStream)Files.newOutputStreamSupplier((File)f).getOutput();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getRoot(String resource) {
        File dir = this.getDirFor(resource);
        return dir == null ? null : dir.getAbsolutePath();
    }

    public InputStream getInput(String relPath) {
        File f = this.getFileFor(relPath);
        try {
            return f == null ? null : (FileInputStream)Files.newInputStreamSupplier((File)f).getInput();
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<String> gatherAll(String endFilter) {
        LinkedList<String> out = new LinkedList<String>();
        Stack<File> dirStack = new Stack<File>();
        for (File root : this.dirs) {
            dirStack.push(root);
            int rootCut = root.getAbsolutePath().length() + 1;
            while (dirStack.size() > 0) {
                for (File f : ((File)dirStack.pop()).listFiles()) {
                    if (f.isDirectory()) {
                        dirStack.push(f);
                        continue;
                    }
                    if (!f.getPath().endsWith(endFilter)) continue;
                    out.add(f.getAbsolutePath().substring(rootCut));
                }
            }
        }
        return out;
    }

    private File getFileFor(String rel) {
        for (File dir : this.dirs) {
            File file = new File(dir, rel);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private File getDirFor(String rel) {
        for (File dir : this.dirs) {
            File file = new File(dir, rel);
            if (!file.exists()) continue;
            return dir;
        }
        return null;
    }
}

