/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExtractS2SRangeTask
extends DefaultTask {
    @InputFiles
    private FileCollection libs;
    private DelayedFile projectFile;
    private String projectConfig;
    private DelayedFile in;
    @OutputFile
    private DelayedFile rangeMap;

    @TaskAction
    public void doTask() throws IOException {
        ZipInputSupplier inSup;
        boolean isJar;
        File in = this.getIn();
        File rangemap = this.getRangeMap();
        boolean bl = isJar = in.getPath().endsWith(".jar") || in.getPath().endsWith(".zip");
        if (isJar) {
            inSup = new ZipInputSupplier();
            inSup.readZip(in);
        } else {
            inSup = new FolderSupplier(in);
        }
        this.generateRangeMap((InputSupplier)inSup, rangemap);
    }

    private void generateRangeMap(InputSupplier inSup, File rangeMap) {
        RangeExtractor extractor = new RangeExtractor();
        extractor.addLibs(this.getLibs().getAsPath()).setSrc(inSup);
        PrintStream stream = new PrintStream(Constants.createLogger(this.getLogger(), LogLevel.DEBUG));
        extractor.setOutLogger(stream);
        boolean worked = extractor.generateRangeMap(rangeMap);
        stream.close();
        if (!worked) {
            throw new RuntimeException("RangeMap generation Failed!!!");
        }
    }

    public File getRangeMap() {
        return this.rangeMap.call();
    }

    public void setRangeMap(DelayedFile out) {
        this.rangeMap = out;
    }

    @InputFiles
    public FileCollection getIns() {
        File inFile = this.getIn();
        if (inFile.isDirectory()) {
            return this.getProject().fileTree((Object)inFile);
        }
        return this.getProject().files(new Object[]{inFile});
    }

    public File getIn() {
        return this.in.call();
    }

    public void setIn(DelayedFile in) {
        this.in = in;
    }

    public FileCollection getLibs() {
        if (this.projectFile != null && this.libs == null) {
            Project proj = BasePlugin.getProject(this.projectFile.call(), this.getProject());
            this.libs = proj.getConfigurations().getByName(this.projectConfig);
        }
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs = libs;
    }

    public void setLibsFromProject(DelayedFile buildscript, String config) {
        this.projectFile = buildscript;
        this.projectConfig = config;
    }
}

