/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.srg2source.rangeapplier.RangeApplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import net.minecraftforge.srg2source.util.io.ZipOutputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public class ApplyS2STask
extends DefaultTask {
    @InputFiles
    private final List<Object> srg = new LinkedList<Object>();
    @Optional
    @InputFiles
    private final List<Object> exc = new LinkedList<Object>();
    @InputFile
    private DelayedFile rangeMap;
    private DelayedFile in;
    private DelayedFile out;

    @TaskAction
    public void doTask() throws IOException {
        FolderSupplier outSup;
        ZipInputSupplier inSup;
        boolean isJar;
        File in = this.getIn();
        File out = this.out == null ? in : this.getOut();
        File rangemap = this.getRangeMap();
        File rangelog = File.createTempFile("rangelog", ".txt", this.getTemporaryDir());
        FileCollection srg = this.getSrgs();
        FileCollection exc = this.getExcs();
        boolean bl = isJar = in.getPath().endsWith(".jar") || in.getPath().endsWith(".zip");
        if (isJar) {
            inSup = new ZipInputSupplier();
            inSup.readZip(in);
            outSup = new ZipOutputSupplier(out);
        } else {
            FolderSupplier fSup = new FolderSupplier(in);
            inSup = fSup;
            outSup = in == out ? fSup : new FolderSupplier(out);
        }
        this.getLogger().lifecycle("remapping source...");
        this.applyRangeMap((InputSupplier)inSup, (OutputSupplier)outSup, srg, exc, rangemap, rangelog);
        inSup.close();
        outSup.close();
    }

    private void applyRangeMap(InputSupplier inSup, OutputSupplier outSup, FileCollection srg, FileCollection exc, File rangeMap, File rangeLog) throws IOException {
        RangeApplier app = new RangeApplier().readSrg((Iterable)srg.getFiles());
        final PrintStream debug = new PrintStream(Constants.createLogger(this.getLogger(), LogLevel.DEBUG));
        PrintStream stream = new PrintStream(rangeLog){

            @Override
            public void println(String line) {
                debug.println(line);
                super.println(line);
            }
        };
        app.setOutLogger(stream);
        if (!exc.isEmpty()) {
            app.readParamMap((Iterable)exc);
        }
        app.dumpRenameMap();
        app.remapSources(inSup, outSup, rangeMap, false);
    }

    @InputFiles
    public FileCollection getIns() {
        File inFile = this.getIn();
        if (inFile.isDirectory()) {
            return this.getProject().fileTree((Object)inFile);
        }
        return this.getProject().files(new Object[]{inFile});
    }

    public File getIn() {
        return this.in.call();
    }

    public void setIn(DelayedFile in) {
        this.in = in;
    }

    @OutputFiles
    public FileCollection getOuts() {
        File outFile = this.getOut();
        if (outFile.isDirectory()) {
            return this.getProject().fileTree((Object)outFile);
        }
        return this.getProject().files(new Object[]{outFile});
    }

    public File getOut() {
        if (this.out == null) {
            return this.getIn();
        }
        return this.out.call();
    }

    public void setOut(DelayedFile out) {
        this.out = out;
    }

    public FileCollection getSrgs() {
        return this.getProject().files(new Object[]{this.srg});
    }

    public void addSrg(DelayedFile srg) {
        this.srg.add((Object)srg);
    }

    public void addSrg(String srg) {
        this.srg.add(srg);
    }

    public void addSrg(File srg) {
        this.srg.add(srg);
    }

    public FileCollection getExcs() {
        return this.getProject().files(new Object[]{this.exc});
    }

    public void addExc(DelayedFile exc) {
        this.exc.add((Object)exc);
    }

    public void addExc(String exc) {
        this.exc.add(exc);
    }

    public void addExc(File exc) {
        this.exc.add(exc);
    }

    public File getRangeMap() {
        return this.rangeMap.call();
    }

    public void setRangeMap(DelayedFile rangeMap) {
        this.rangeMap = rangeMap;
    }
}

