/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.rangeapplier.RangeApplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import net.minecraftforge.srg2source.util.io.ZipOutputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public class ApplySrg2Source
extends DefaultTask {
    @InputFile
    private DelayedFile srg;
    @Optional
    @InputFile
    private DelayedFile exc;
    @InputFiles
    private FileCollection libs;
    private DelayedFile projectFile;
    private String projectConfig;
    private DelayedFile in;
    private DelayedFile out;

    @TaskAction
    public void doTask() throws IOException {
        FolderSupplier outSup;
        ZipInputSupplier inSup;
        boolean isJar;
        File in = this.getIn();
        File out = this.out == null ? in : this.getOut();
        File rangemap = File.createTempFile("rangemap", ".txt", this.getTemporaryDir());
        File rangelog = File.createTempFile("rangelog", ".txt", this.getTemporaryDir());
        File srg = this.getSrg();
        boolean bl = isJar = in.getPath().endsWith(".jar") || in.getPath().endsWith(".zip");
        if (isJar) {
            inSup = new ZipInputSupplier();
            inSup.readZip(in);
            outSup = new ZipOutputSupplier(out);
        } else {
            FolderSupplier fSup = new FolderSupplier(in);
            inSup = fSup;
            outSup = in == out ? fSup : new FolderSupplier(out);
        }
        this.getLogger().lifecycle("generating rangemap...");
        this.generateRangeMap((InputSupplier)inSup, rangemap);
        this.getLogger().lifecycle("remapping source...");
        this.applyRangeMap((InputSupplier)inSup, (OutputSupplier)outSup, srg, rangemap, rangelog);
        inSup.close();
        outSup.close();
    }

    private void generateRangeMap(InputSupplier inSup, File rangeMap) {
        RangeExtractor extractor = new RangeExtractor();
        extractor.addLibs(this.getLibs().getAsPath()).setSrc(inSup);
        PrintStream stream = new PrintStream(Constants.createLogger(this.getLogger(), LogLevel.DEBUG));
        extractor.setOutLogger(stream);
        boolean worked = extractor.generateRangeMap(rangeMap);
        stream.close();
        if (!worked) {
            throw new RuntimeException("RangeMap generation Failed!!!");
        }
    }

    private void applyRangeMap(InputSupplier inSup, OutputSupplier outSup, File srg, File rangeMap, File rangeLog) throws IOException {
        RangeApplier app = new RangeApplier().readSrg(srg);
        final PrintStream debug = new PrintStream(Constants.createLogger(this.getLogger(), LogLevel.DEBUG));
        PrintStream stream = new PrintStream(rangeLog){

            @Override
            public void println(String line) {
                debug.println(line);
                super.println(line);
            }
        };
        app.setOutLogger(stream);
        if (this.exc != null) {
            app.readParamMap(this.getExc(), null);
        }
        app.dumpRenameMap();
        app.remapSources(inSup, outSup, rangeMap, false);
    }

    @InputFiles
    public FileCollection getIns() {
        File inFile = this.getIn();
        if (inFile.isDirectory()) {
            return this.getProject().fileTree((Object)inFile);
        }
        return this.getProject().files(new Object[]{inFile});
    }

    public File getIn() {
        return this.in.call();
    }

    public void setIn(DelayedFile in) {
        this.in = in;
    }

    @OutputFiles
    public FileCollection getOuts() {
        File outFile = this.getOut();
        if (outFile.isDirectory()) {
            return this.getProject().fileTree((Object)outFile);
        }
        return this.getProject().files(new Object[]{outFile});
    }

    public File getOut() {
        if (this.out == null) {
            return this.getIn();
        }
        return this.out.call();
    }

    public void setOut(DelayedFile out) {
        this.out = out;
    }

    public FileCollection getLibs() {
        if (this.projectFile != null && this.libs == null) {
            Project proj = BasePlugin.getProject(this.projectFile.call(), this.getProject());
            this.libs = proj.getConfigurations().getByName(this.projectConfig);
        }
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs = libs;
    }

    public void setLibsFromProject(DelayedFile buildscript, String config) {
        this.projectFile = buildscript;
        this.projectConfig = config;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getExc() {
        return this.exc.call();
    }

    public void setExc(DelayedFile exc) {
        this.exc = exc;
    }
}

