/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.common.BaseExtension;
import net.minecraftforge.gradle.delayed.DelayedObject;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;

public class UserExtension
extends BaseExtension {
    private static final Pattern VERSION_CHECK = Pattern.compile("([\\d.]+)-([\\w\\d.]+)(?:-[\\w\\d.]+)?");
    private String apiVersion;
    private ArrayList<Object> ats = new ArrayList();
    private HashMap<String, Object> replacements = new HashMap();
    private ArrayList<String> includes = new ArrayList();
    protected boolean isDecomp = false;

    public UserExtension(Project project) {
        super(project);
    }

    public void accessT(Object obj) {
        this.at(obj);
    }

    public void accessTs(Object ... obj) {
        this.ats(obj);
    }

    public void accessTransformer(Object obj) {
        this.at(obj);
    }

    public void accessTransformers(Object ... obj) {
        this.ats(obj);
    }

    public void at(Object obj) {
        this.ats.add(obj);
    }

    public void ats(Object ... obj) {
        for (Object object : obj) {
            this.ats.add((Object)new DelayedObject(object, this.project));
        }
    }

    public List<Object> getAccessTransformers() {
        return this.ats;
    }

    public void replace(Object token, Object replacement) {
        this.replacements.put(token.toString(), replacement);
    }

    public void replace(Map<Object, Object> map) {
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            this.replace(e.getKey(), e.getValue());
        }
    }

    public Map<String, Object> getReplacements() {
        return this.replacements;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void replaceIn(String path) {
        this.includes.add(path);
    }

    @Override
    public void setVersion(String str) {
        Matcher matcher = VERSION_CHECK.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(str + " is not in the form 'MCVersion-apiVersion-branch'!");
        }
        this.version = matcher.group(1);
        this.apiVersion = matcher.group(0);
        if (!this.version.equals("1.7.2")) {
            throw new IllegalArgumentException("ForgeGradle 1.1 will only work for Minecraft 1.7.2");
        }
    }

    public String getApiVersion() {
        if (this.apiVersion == null) {
            throw new ProjectConfigurationException("You must set the Minecraft Version!", (Throwable)new NullPointerException());
        }
        return this.apiVersion;
    }

    public boolean isDecomp() {
        return this.isDecomp;
    }
}

