/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import joptsimple.internal.Strings;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.json.JsonFactory;
import net.minecraftforge.gradle.json.MCInjectorStruct;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ProcessJarTask
extends CachedTask {
    @InputFile
    @Optional
    private DelayedFile fieldCsv;
    @InputFile
    @Optional
    private DelayedFile methodCsv;
    @InputFile
    private DelayedFile inJar;
    @InputFile
    private DelayedFile srg;
    @InputFile
    private DelayedFile exceptorCfg;
    @InputFile
    private DelayedFile exceptorJson;
    @Input
    private boolean applyMarkers = false;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outCleanJar;
    @OutputFile
    @CachedTask.Cached
    private DelayedFile outDirtyJar = new DelayedFile(this.getProject(), "{BUILD_DIR}/processed.jar");
    @InputFiles
    private ArrayList<DelayedFile> ats = new ArrayList();
    private DelayedFile log;
    private boolean isClean = true;

    public void addTransformerClean(DelayedFile ... obj) {
        for (DelayedFile object : obj) {
            this.ats.add(object);
        }
    }

    public void addTransformer(Object ... obj) {
        for (Object object : obj) {
            if (object instanceof File) {
                this.ats.add(new DelayedFile(this.getProject(), ((File)object).getAbsolutePath()));
            } else if (object instanceof String) {
                this.ats.add(new DelayedFile(this.getProject(), (String)object));
            } else {
                this.ats.add(new DelayedFile(this.getProject(), object.toString()));
            }
            this.isClean = false;
        }
    }

    @TaskAction
    public void doTask() throws IOException {
        File tempObfJar = new File(this.getTemporaryDir(), "deobfed.jar");
        File tempExcJar = new File(this.getTemporaryDir(), "excepted.jar");
        HashSet<File> ats = new HashSet<File>();
        for (DelayedFile obj : this.ats) {
            ats.add(this.getProject().file((Object)obj).getCanonicalFile());
        }
        this.getLogger().lifecycle("Applying SpecialSource...");
        this.deobfJar(this.getInJar(), tempObfJar, this.getSrg(), ats);
        File log = this.getLog();
        if (log == null) {
            log = new File(this.getTemporaryDir(), "exceptor.log");
        }
        this.getLogger().lifecycle("Applying Exceptor...");
        this.applyExceptor(tempObfJar, tempExcJar, this.getExceptorCfg(), log, ats);
        File out = this.isClean ? this.getOutCleanJar() : this.getOutDirtyJar();
        this.getLogger().lifecycle("Injecting source info...");
        this.injectSourceInfo(tempExcJar, out);
    }

    private void deobfJar(File inJar, File outJar, File srg, Collection<File> ats) throws IOException {
        this.getLogger().debug("INPUT: " + inJar);
        this.getLogger().debug("OUTPUT: " + outJar);
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(srg);
        final HashMap renames = Maps.newHashMap();
        for (File f : new File[]{this.getFieldCsv(), this.getMethodCsv()}) {
            if (f == null) continue;
            Files.readLines((File)f, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<String>(){

                public boolean processLine(String line) throws IOException {
                    String[] pts = line.split(",");
                    if (!"searge".equals(pts[0])) {
                        renames.put(pts[0], pts[1]);
                    }
                    return true;
                }

                public String getResult() {
                    return null;
                }
            });
        }
        AccessMap accessMap = new AccessMap(){

            public void addAccessChange(String symbolString, String accessString) {
                Object[] pts = symbolString.split(" ");
                if (pts.length >= 2) {
                    String rename;
                    int idx = pts[1].indexOf(40);
                    Object start = pts[1];
                    String end = "";
                    if (idx != -1) {
                        start = ((String)pts[1]).substring(0, idx);
                        end = ((String)pts[1]).substring(idx);
                    }
                    if ((rename = (String)renames.get(start)) != null) {
                        pts[1] = rename + end;
                    }
                }
                String joinedString = Joiner.on((char)'.').join(pts);
                super.addAccessChange(joinedString, accessString);
            }
        };
        this.getLogger().info("Using AccessTransformers...");
        for (File at : ats) {
            this.getLogger().info("" + at);
            accessMap.loadAccessTransformer(at);
        }
        RemapperProcessor srgProcessor = new RemapperProcessor(null, mapping, null);
        RemapperProcessor atProcessor = new RemapperProcessor(null, null, accessMap);
        JarRemapper remapper = new JarRemapper(srgProcessor, mapping, atProcessor);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        remapper.remapJar(input, outJar);
    }

    private int fixAccess(int access, String target) {
        int ret = access & 0xFFFFFFF8;
        int t = 0;
        if (target.startsWith("public")) {
            t = 1;
        } else if (target.startsWith("private")) {
            t = 2;
        } else if (target.startsWith("protected")) {
            t = 4;
        }
        switch (access & 7) {
            case 2: {
                ret |= t;
                break;
            }
            case 0: {
                ret |= t != 2 ? t : 0;
                break;
            }
            case 4: {
                ret |= t != 2 && t != 0 ? t : 4;
                break;
            }
            case 1: {
                ret |= 1;
            }
        }
        if (target.endsWith("-f")) {
            ret &= 0xFFFFFFEF;
        } else if (target.endsWith("+f")) {
            ret |= 0x10;
        }
        return ret;
    }

    public void applyExceptor(File inJar, File outJar, File config, File log, Set<File> ats) throws IOException {
        String json = null;
        File getJson = this.getExceptorJson();
        if (getJson != null) {
            final Map<String, MCInjectorStruct> struct = JsonFactory.loadMCIJson(getJson);
            for (File at : ats) {
                this.getLogger().info("loading AT: " + at.getCanonicalPath());
                Files.readLines((File)at, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Object>(){

                    public boolean processLine(String line) throws IOException {
                        if (line.indexOf(35) != -1) {
                            line = line.substring(0, line.indexOf(35));
                        }
                        if ((line = line.trim().replace('.', '/')).isEmpty()) {
                            return true;
                        }
                        String[] s = line.split(" ");
                        if (s.length == 2 && s[1].indexOf(36) > 0) {
                            String parent = s[1].substring(0, s[1].indexOf(36));
                            for (MCInjectorStruct cls : new MCInjectorStruct[]{(MCInjectorStruct)struct.get(parent), (MCInjectorStruct)struct.get(s[1])}) {
                                if (cls == null || cls.innerClasses == null) continue;
                                for (MCInjectorStruct.InnerClass inner : cls.innerClasses) {
                                    if (!inner.inner_class.equals(s[1])) continue;
                                    int access = ProcessJarTask.this.fixAccess(inner.getAccess(), s[0]);
                                    inner.access = access == 0 ? null : Integer.toHexString(access);
                                }
                            }
                        }
                        return true;
                    }

                    public Object getResult() {
                        return null;
                    }
                });
            }
            File jsonTmp = new File(this.getTemporaryDir(), "transformed.json");
            json = jsonTmp.getCanonicalPath();
            Files.write((byte[])JsonFactory.GSON.toJson(struct).getBytes(), (File)jsonTmp);
        }
        this.getLogger().debug("INPUT: " + inJar);
        this.getLogger().debug("OUTPUT: " + outJar);
        this.getLogger().debug("CONFIG: " + config);
        this.getLogger().debug("JSON: " + json);
        this.getLogger().debug("LOG: " + log);
        MCInjectorImpl.process((String)inJar.getCanonicalPath(), (String)outJar.getCanonicalPath(), (String)config.getCanonicalPath(), (String)log.getCanonicalPath(), null, (int)0, (String)json, (boolean)this.isApplyMarkers());
    }

    private void injectSourceInfo(File inJar, File outJar) throws IOException {
        ZipFile in = new ZipFile(inJar);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outJar)));
        for (ZipEntry zipEntry : Collections.list(in.entries())) {
            if (zipEntry.getName().contains("META-INF")) continue;
            if (zipEntry.isDirectory()) {
                out.putNextEntry(zipEntry);
                continue;
            }
            ZipEntry n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            out.putNextEntry(n);
            byte[] data = ByteStreams.toByteArray((InputStream)in.getInputStream(zipEntry));
            if (zipEntry.getName().endsWith(".class")) {
                data = this.correctSourceName(zipEntry.getName(), data);
            }
            out.write(data);
        }
        out.flush();
        out.close();
        in.close();
    }

    private byte[] correctSourceName(String name, byte[] data) {
        ClassReader reader = new ClassReader(data);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        if (Strings.isNullOrEmpty((String)node.sourceFile) || !node.sourceFile.endsWith(".java")) {
            node.sourceFile = name.substring(name.lastIndexOf(47) + 1).replace(".class", ".java");
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public File getExceptorCfg() {
        return this.exceptorCfg.call();
    }

    public void setExceptorCfg(DelayedFile exceptorCfg) {
        this.exceptorCfg = exceptorCfg;
    }

    public File getExceptorJson() {
        if (this.exceptorJson == null) {
            return null;
        }
        return this.exceptorJson.call();
    }

    public void setExceptorJson(DelayedFile exceptorJson) {
        this.exceptorJson = exceptorJson;
    }

    public boolean isApplyMarkers() {
        return this.applyMarkers;
    }

    public void setApplyMarkers(boolean applyMarkers) {
        this.applyMarkers = applyMarkers;
    }

    public File getInJar() {
        return this.inJar.call();
    }

    public void setInJar(DelayedFile inJar) {
        this.inJar = inJar;
    }

    public File getLog() {
        if (this.log == null) {
            return null;
        }
        return this.log.call();
    }

    public void setLog(DelayedFile Log) {
        this.log = Log;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getOutCleanJar() {
        return this.outCleanJar.call();
    }

    public void setOutCleanJar(DelayedFile outJar) {
        this.outCleanJar = outJar;
    }

    public File getOutDirtyJar() {
        return this.outDirtyJar.call();
    }

    public void setOutDirtyJar(DelayedFile outDirtyJar) {
        this.outDirtyJar = outDirtyJar;
    }

    public boolean isClean() {
        return this.isClean;
    }

    public DelayedFile getDelayedOutput() {
        return this.isClean ? this.outCleanJar : this.outDirtyJar;
    }

    public File getOutJar() {
        return this.isClean ? this.outCleanJar.call() : this.outDirtyJar.call();
    }

    public FileCollection getAts() {
        return this.getProject().files(this.ats.toArray());
    }

    public File getFieldCsv() {
        return this.fieldCsv == null ? null : this.fieldCsv.call();
    }

    public void setFieldCsv(DelayedFile fieldCsv) {
        this.fieldCsv = fieldCsv;
    }

    public File getMethodCsv() {
        return this.methodCsv == null ? null : this.methodCsv.call();
    }

    public void setMethodCsv(DelayedFile methodCsv) {
        this.methodCsv = methodCsv;
    }
}

