/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.json.version;

import java.util.Locale;

public enum OS {
    LINUX("linux", "bsd", "unix"),
    WINDOWS("windows", "win"),
    OSX("osx", "mac"),
    UNKNOWN("unknown", new String[0]);

    private String name;
    private String[] aliases;
    public static final OS CURRENT;
    public static final String VERSION;

    private OS(String name, String ... aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public static OS getCurrentPlatform() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        for (OS os : OS.values()) {
            if (osName.contains(os.name)) {
                return os;
            }
            for (String alias : os.aliases) {
                if (!osName.contains(alias)) continue;
                return os;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name;
    }

    static {
        CURRENT = OS.getCurrentPlatform();
        VERSION = System.getProperty("os.version");
    }
}

