/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user.reobf;

import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.delayed.DelayedThingy;
import net.minecraftforge.gradle.extrastuff.ReobfExceptor;
import net.minecraftforge.gradle.tasks.user.reobf.ArtifactSpec;
import net.minecraftforge.gradle.tasks.user.reobf.ObfArtifact;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ReobfTask
extends DefaultTask {
    private final DefaultDomainObjectSet<ObfArtifact> obfOutput = new DefaultDomainObjectSet(ObfArtifact.class);
    @Input
    private boolean useRetroGuard = false;
    @InputFile
    private DelayedFile inSrg;
    private DelayedFile fieldCsv;
    private DelayedFile methodCsv;
    private DelayedFile exceptorCfg;
    private DelayedFile deobfFile;
    @Input
    private LinkedList<String> extraSrg = new LinkedList();

    public ReobfTask() {
        this.getInputs().files(new Object[]{new Closure<Object>(this.obfOutput){

            public Object call(Object ... objects) {
                return ReobfTask.this.getFilesToObfuscate();
            }
        }});
        this.getOutputs().files(new Object[]{new Closure<Object>(this.obfOutput){

            public Object call(Object ... objects) {
                return ReobfTask.this.getObfuscatedFiles();
            }
        }});
    }

    public void reobf(Task task, Action<ArtifactSpec> artifactSpec) {
        this.reobf(task, (Closure<Object>)new ActionClosure(artifactSpec));
    }

    public void reobf(Task task, Closure<Object> artifactSpec) {
        if (!(task instanceof AbstractArchiveTask)) {
            throw new InvalidUserDataException("You cannot reobfuscate tasks that are not 'archive' tasks, such as 'jar', 'zip' etc. (you tried to sign $task)");
        }
        ArtifactSpec spec = new ArtifactSpec((AbstractArchiveTask)task);
        artifactSpec.call((Object)spec);
        this.dependsOn(new Object[]{task});
        this.addArtifact(new ObfArtifact(new DelayedThingy(task), spec, this));
    }

    public void reobf(Task ... tasks) {
        for (Task task : tasks) {
            if (!(task instanceof AbstractArchiveTask)) {
                throw new InvalidUserDataException("You cannot reobfuscate tasks that are not 'archive' tasks, such as 'jar', 'zip' etc. (you tried to sign $task)");
            }
            this.dependsOn(new Object[]{(AbstractArchiveTask)task});
            this.addArtifact(new ObfArtifact(new DelayedThingy(task), new ArtifactSpec(this.getProject()), this));
        }
    }

    public void reobf(PublishArtifact art, Action<ArtifactSpec> artifactSpec) {
        this.reobf(art, (Closure<Object>)new ActionClosure(artifactSpec));
    }

    public void reobf(PublishArtifact publishArtifact, Closure<Object> artifactSpec) {
        ArtifactSpec spec = new ArtifactSpec(publishArtifact, this.getProject());
        artifactSpec.call((Object)spec);
        this.dependsOn(new Object[]{publishArtifact});
        this.addArtifact(new ObfArtifact(publishArtifact, spec, this));
    }

    public void reobf(PublishArtifact ... publishArtifacts) {
        for (PublishArtifact publishArtifact : publishArtifacts) {
            this.dependsOn(new Object[]{publishArtifact});
            this.addArtifact(new ObfArtifact(publishArtifact, new ArtifactSpec(publishArtifact, this.getProject()), this));
        }
    }

    public void reobf(File file, Action<ArtifactSpec> artifactSpec) {
        this.reobf(file, (Closure<Object>)new ActionClosure(artifactSpec));
    }

    public void reobf(File file, Closure<Object> artifactSpec) {
        ArtifactSpec spec = new ArtifactSpec(file, this.getProject());
        artifactSpec.call((Object)spec);
        this.addArtifact(new ObfArtifact(file, spec, this));
    }

    public void reobf(File ... files) {
        for (File file : files) {
            this.addArtifact(new ObfArtifact(file, new ArtifactSpec(file, this.getProject()), this));
        }
    }

    public void reobf(Configuration configuration, final Closure<Object> artifactSpec) {
        configuration.getAllArtifacts().all((Action)new Action<PublishArtifact>(){

            public void execute(PublishArtifact artifact) {
                if (!(artifact instanceof ObfArtifact)) {
                    ReobfTask.this.reobf(artifact, (Closure<Object>)artifactSpec);
                }
            }
        });
        configuration.getAllArtifacts().whenObjectRemoved((Action)new Action<PublishArtifact>(){

            public void execute(PublishArtifact artifact) {
                ObfArtifact removed = null;
                for (ObfArtifact it : ReobfTask.this.obfOutput) {
                    if (it.toObfArtifact != artifact) continue;
                    removed = it;
                    break;
                }
                if (removed != null) {
                    ReobfTask.this.obfOutput.remove(removed);
                }
            }
        });
    }

    public void reobf(Configuration ... configurations) {
        for (Configuration configuration : configurations) {
            configuration.getAllArtifacts().all((Action)new Action<PublishArtifact>(){

                public void execute(PublishArtifact artifact) {
                    if (!(artifact instanceof ObfArtifact)) {
                        ReobfTask.this.reobf(artifact);
                    }
                }
            });
            configuration.getAllArtifacts().whenObjectRemoved((Action)new Action<PublishArtifact>(){

                public void execute(PublishArtifact artifact) {
                    ObfArtifact removed = null;
                    for (ObfArtifact it : ReobfTask.this.obfOutput) {
                        if (it.toObfArtifact != artifact) continue;
                        removed = it;
                        break;
                    }
                    if (removed != null) {
                        ReobfTask.this.obfOutput.remove(removed);
                    }
                }
            });
        }
    }

    @TaskAction
    public void generate() throws IOException {
        ReobfExceptor exc = null;
        File srg = new File(this.getTemporaryDir(), "reobf.srg");
        UserExtension ext = (UserExtension)this.getProject().getExtensions().getByName("minecraft");
        if (ext.isDecomp()) {
            exc = new ReobfExceptor();
            exc.deobfJar = this.getDeobfFile();
            exc.excConfig = this.getExceptorCfg();
            exc.inSrg = this.getInSrg();
            exc.outSrg = srg;
            exc.fieldCSV = this.getFieldCsv();
            exc.methodCSV = this.getMethodCsv();
            exc.doFirstThings();
        } else {
            Files.copy((File)this.getInSrg(), (File)srg);
            BufferedWriter writer = new BufferedWriter(new FileWriter(srg, true));
            for (String line : this.getExtraSrg()) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        for (ObfArtifact obf : this.getObfuscated()) {
            obf.generate(exc, srg);
        }
    }

    private void addArtifact(ObfArtifact artifact) {
        this.obfOutput.add((Object)artifact);
    }

    DomainObjectSet<ObfArtifact> getObfuscated() {
        return this.obfOutput;
    }

    FileCollection getFilesToObfuscate() {
        ArrayList<File> collect = new ArrayList<File>();
        for (ObfArtifact obf : this.getObfuscated()) {
            if (obf == null || obf.getToObf() == null) continue;
            collect.add(obf.getToObf());
        }
        return new SimpleFileCollection(collect.toArray(new File[collect.size()]));
    }

    FileCollection getObfuscatedFiles() {
        ArrayList<File> collect = new ArrayList<File>();
        for (ObfArtifact obf : this.getObfuscated()) {
            if (obf == null || obf.getFile() == null) continue;
            collect.add(obf.getFile());
        }
        return new SimpleFileCollection(collect.toArray(new File[collect.size()]));
    }

    public boolean getUseRetroGuard() {
        return this.useRetroGuard;
    }

    public void setUseRetroGuard(boolean useRG) {
        this.useRetroGuard = useRG;
    }

    public File getDeobfFile() {
        return this.deobfFile == null ? null : this.deobfFile.call();
    }

    public void setDeobfFile(DelayedFile deobfFile) {
        this.deobfFile = deobfFile;
    }

    public File getExceptorCfg() {
        return this.exceptorCfg == null ? null : this.exceptorCfg.call();
    }

    public void setExceptorCfg(DelayedFile file) {
        this.exceptorCfg = file;
    }

    public LinkedList<String> getExtraSrg() {
        return this.extraSrg;
    }

    public void setExtraSrg(LinkedList<String> extraSrg) {
        this.extraSrg = extraSrg;
    }

    public File getInSrg() {
        return this.inSrg.call();
    }

    public void setInSrg(DelayedFile inSrg) {
        this.inSrg = inSrg;
    }

    public File getFieldCsv() {
        return this.fieldCsv == null ? null : this.fieldCsv.call();
    }

    public void setFieldCsv(DelayedFile fieldCsv) {
        this.fieldCsv = fieldCsv;
    }

    public File getMethodCsv() {
        return this.methodCsv == null ? null : this.methodCsv.call();
    }

    public void setMethodCsv(DelayedFile methodCsv) {
        this.methodCsv = methodCsv;
    }

    public DefaultDomainObjectSet<ObfArtifact> getObfOutput() {
        return this.obfOutput;
    }

    private class ActionClosure
    extends Closure<Object> {
        private final Action act;

        public ActionClosure(Action artifactSpec) {
            super(null);
            this.act = artifactSpec;
        }

        public Object call(Object obj) {
            this.act.execute(obj);
            return null;
        }
    }
}

