/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.io.File;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.user.RecompileTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.tasks.bundling.Zip;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forgeBin-{API_VERSION}.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forgeBin-{API_VERSION}.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-srg.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/forge-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "recompForge"});
    }

    @Override
    public void afterEvaluate() {
        String depBase = "net.minecraftforge:forge:" + ((UserExtension)this.getExtension()).getApiVersion();
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)(depBase + ":userdev@jar"));
        super.afterEvaluate();
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-binPatched.jar");
    }

    @Override
    protected String getDecompOut() {
        return "/forge-{API_VERSION}-decomp.jar";
    }

    @Override
    protected String getCacheDir() {
        return "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}";
    }

    @Override
    protected void createMcModuleDep(final boolean isClean, DependencyHandler depHandler, String depConfig) {
        this.project.allprojects((Action)new Action<Project>(){

            public void execute(Project proj) {
                ForgeUserPlugin.this.addFlatRepo(ForgeUserPlugin.this.project, "forgeFlatRepo", ForgeUserPlugin.this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts").call().getAbsolutePath());
            }
        });
        if (((UserExtension)this.getExtension()).isDecomp) {
            depHandler.add("compile", (Object)ImmutableMap.of((Object)"name", (Object)"forgeSrc", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        } else {
            depHandler.add("compile", (Object)ImmutableMap.of((Object)"name", (Object)"forgeBin", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        }
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        String prefix = isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        DelayedFile fmled = this.delayedFile(prefix + "/forge-{API_VERSION}-fmled.jar");
        DelayedFile fmlInjected = this.delayedFile(prefix + "/forge-{API_VERSION}-fmlinjected.jar");
        DelayedFile remapped = this.delayedFile(prefix + "/forge-{API_VERSION}-mcped.jar");
        DelayedFile forged = this.delayedFile(prefix + "/forge-{API_VERSION}-src-nojd.jar");
        DelayedFile forgeJavaDocced = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}-sources.jar");
        DelayedFile forgeRecomp = this.delayedFile(prefix + "/forgeSrc-{API_VERSION}.jar");
        PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        final Zip inject = this.makeTask("addFmlSources", Zip.class);
        inject.getOutputs().upToDateWhen((Closure)new Closure<Boolean>(null){
            private static final long serialVersionUID = -8480140049890357630L;

            public Boolean call(Object o) {
                return !inject.dependsOnTaskDidWork();
            }
        });
        inject.dependsOn(new Object[]{fmlPatches});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        File injectFile = fmlInjected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.dependsOn(new Object[]{inject});
        remap.setInJar(fmlInjected);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        remap.setDoesJavadocs(false);
        PatchJarTask forgePatches = this.makeTask("doForgePatches", PatchJarTask.class);
        forgePatches.dependsOn(new Object[]{remap});
        forgePatches.setInJar(remapped);
        forgePatches.setOutJar(forged);
        forgePatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/forgepatches.zip"));
        RemapSourcesTask javadocRemap = this.makeTask("addForgeJavadoc", RemapSourcesTask.class);
        javadocRemap.dependsOn(new Object[]{forgePatches});
        javadocRemap.setInJar(forged);
        javadocRemap.setOutJar(forgeJavaDocced);
        javadocRemap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        javadocRemap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        javadocRemap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        javadocRemap.setDoesJavadocs(true);
        RecompileTask recomp = this.makeTask("recompForge", RecompileTask.class);
        recomp.setConfig("minecraft");
        recomp.setInSrcJar(forgeJavaDocced);
        recomp.setOutJar(forgeRecomp);
        recomp.dependsOn(new Object[]{javadocRemap});
    }
}

