/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.io.File;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.tasks.user.RecompileTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.tasks.bundling.Zip;

public class FmlUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-binPatched.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fmlBin-{API_VERSION}.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/fmlBin-{API_VERSION}.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-srg.jar"));
        procTask.setOutDirtyJar(this.delayedFile("{BUILD_DIR}/dirtyArtifacts/fml-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"genSrgs", "copyAssets", "extractNatives", "recompFml"});
    }

    @Override
    public void afterEvaluate() {
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)("cpw.mods:fml:" + ((UserExtension)this.getExtension()).getApiVersion() + ":userdev"));
        super.afterEvaluate();
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}/fml-{API_VERSION}-binPatched.jar");
    }

    @Override
    protected String getDecompOut() {
        return "/fml-{API_VERSION}-decomp.jar";
    }

    @Override
    protected String getCacheDir() {
        return "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}";
    }

    @Override
    protected void createMcModuleDep(final boolean isClean, DependencyHandler depHandler, String depConfig) {
        String prefix;
        this.project.allprojects((Action)new Action<Project>(){

            public void execute(Project proj) {
                FmlUserPlugin.this.addFlatRepo(FmlUserPlugin.this.project, "fmlFlatRepo", FmlUserPlugin.this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts").call());
            }
        });
        String string = prefix = isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        if (((UserExtension)this.getExtension()).isDecomp) {
            depHandler.add("compile", (Object)ImmutableMap.of((Object)"name", (Object)"fmlSrc", (Object)"version", (Object)((UserExtension)this.getExtension()).getApiVersion()));
        } else {
            depHandler.add("compile", (Object)this.project.files(new Object[]{this.delayedFile(prefix + "/fml-{API_VERSION}-binPatched.jar")}));
        }
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        String prefix = isClean ? "{CACHE_DIR}/minecraft/cpw/mods/fml/{API_VERSION}" : "{BUILD_DIR}/dirtyArtifacts";
        DelayedFile fmled = this.delayedFile(prefix + "/fml-{API_VERSION}-fmled.jar");
        DelayedFile injected = this.delayedFile(prefix + "/fml-{API_VERSION}-src-injected.jar");
        DelayedFile remapped = this.delayedFile(prefix + "/fmlSrc-{API_VERSION}-sources.jar");
        DelayedFile recompJar = this.delayedFile(prefix + "/fmlSrc-{API_VERSION}.jar");
        PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        final Zip inject = this.makeTask("addFmlSources", Zip.class);
        inject.getOutputs().upToDateWhen((Closure)new Closure<Boolean>(null){
            private static final long serialVersionUID = -8480140049890357630L;

            public Boolean call(Object o) {
                return !inject.dependsOnTaskDidWork();
            }
        });
        inject.dependsOn(new Object[]{"doFmlPatches"});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        File injectFile = injected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        RemapSourcesTask remapTask = this.makeTask("remapJar", RemapSourcesTask.class);
        remapTask.dependsOn(new Object[]{"addFmlSources"});
        remapTask.setInJar(injected);
        remapTask.setOutJar(remapped);
        remapTask.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/fields.csv", "{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remapTask.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/methods.csv", "{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remapTask.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/conf/params.csv", "{BUILD_DIR}/unpacked/mappings/params.csv"));
        remapTask.setDoesJavadocs(true);
        RecompileTask recomp = this.makeTask("recompFml", RecompileTask.class);
        recomp.setConfig("minecraft");
        recomp.setInSrcJar(remapped);
        recomp.setOutJar(recompJar);
        recomp.dependsOn(new Object[]{remapTask});
    }
}

