/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user;

import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.abstractutil.CachedTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;

public class RecompileTask
extends CachedTask {
    @InputFile
    DelayedFile inSrcJar;
    @CachedTask.Cached
    @OutputFile
    DelayedFile outJar;
    @Input
    String config;

    @TaskAction
    public void doTask() throws IOException {
        File srcDir = new File(this.getTemporaryDir(), "sources");
        File classDir = new File(this.getTemporaryDir(), "classes");
        Configuration config = this.getProject().getConfigurations().getByName(this.config);
        this.getLogger().lifecycle("extracting sources...");
        srcDir.mkdirs();
        this.readInJar(this.getInSrcJar(), srcDir, classDir);
        this.getLogger().lifecycle("compiling sources...");
        classDir.mkdirs();
        this.compile(srcDir, classDir, config);
        this.getLogger().lifecycle("rebuilding jar...");
        this.buildJar(this.getOutJar(), classDir);
    }

    private void readInJar(File inJar, File srcDir, File clsDir) throws IOException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(inJar));
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File out = entry.getName().endsWith(".java") ? new File(srcDir, entry.getName()) : new File(clsDir, entry.getName());
            out.getParentFile().mkdirs();
            if (!out.exists()) {
                out.createNewFile();
            }
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zin), (File)out);
        }
        zin.close();
    }

    private void compile(final File src, final File outDir, final Configuration config) throws IOException {
        final OutputStream stream = Constants.getNullStream();
        outDir.getParentFile().mkdirs();
        if (!outDir.exists()) {
            outDir.createNewFile();
        }
        final File listFile = new File(this.getTemporaryDir(), "list.txt");
        listFile.getParentFile().mkdirs();
        if (!listFile.exists()) {
            listFile.createNewFile();
        }
        Files.write((CharSequence)Joiner.on((char)'\n').join((Iterable)this.getProject().fileTree((Object)src).getFiles()), (File)listFile, (Charset)Charset.defaultCharset());
        this.getProject().exec((Closure)new Closure<Object>((Object)this, (Object)this){

            public Object call(Object ... obj) {
                ExecSpec exec = (ExecSpec)this.getDelegate();
                exec.executable((Object)"javac");
                exec.args(new Object[]{"-d", outDir.getAbsolutePath()});
                exec.args(new Object[]{"-target", "1.6", "-source", "1.6"});
                exec.args(new Object[]{"-cp", config.getAsPath()});
                exec.args(new Object[]{"-nowarn"});
                exec.args(new Object[]{"@" + listFile.getAbsolutePath()});
                exec.workingDir((Object)src);
                exec.setIgnoreExitValue(true);
                exec.setStandardOutput(stream);
                exec.setErrorOutput(stream);
                return exec;
            }
        });
        stream.close();
    }

    private void buildJar(File outJar, File classDir) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        JarOutputStream jout = new JarOutputStream((OutputStream)new FileOutputStream(outJar), manifest);
        int cut = classDir.getCanonicalPath().length() + 1;
        this.writeDir(classDir, cut, jout);
        jout.flush();
        jout.close();
    }

    private void writeDir(File dir, int cut, JarOutputStream jout) throws IOException {
        for (File file : dir.listFiles()) {
            String name = file.getCanonicalPath().substring(cut).replace('\\', '/');
            if (file.isDirectory()) {
                jout.putNextEntry(new JarEntry(name + "/"));
                jout.closeEntry();
                this.writeDir(file, cut, jout);
                continue;
            }
            jout.putNextEntry(new JarEntry(name));
            Files.copy((File)file, (OutputStream)jout);
            jout.closeEntry();
        }
    }

    public File getInSrcJar() {
        return this.inSrcJar.call();
    }

    public void setInSrcJar(DelayedFile inSrcJar) {
        this.inSrcJar = inSrcJar;
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
}

