/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.launch4j;

import edu.sc.seis.launch4j.CreateLaunch4jXMLTask;
import edu.sc.seis.launch4j.Launch4jPluginExtension;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;

public class Launch4jPlugin
implements Plugin<Project> {
    static final String LAUNCH4J_PLUGIN_NAME = "launch4j";
    static final String LAUNCH4J_GROUP = "launch4j";
    static final String LAUNCH4J_CONFIGURATION_NAME = "launch4j";
    static final String TASK_XML_GENERATE_NAME = "generateXmlConfig";
    static final String TASK_LIB_COPY_NAME = "copyL4jLib";
    static final String TASK_RUN_NAME = "createExe";
    static final String TASK_LAUNCH4J_NAME = "launch4j";
    Project project;

    public void apply(Project project) {
        this.project = project;
        ((Configuration)project.getConfigurations().create("launch4j")).setVisible(false).setTransitive(true).setDescription("The launch4j configuration for this project.");
        Launch4jPluginExtension pluginExtension = new Launch4jPluginExtension();
        project.getExtensions().add("launch4j", (Object)pluginExtension);
        Task xmlTask = this.addCreateLaunch4jXMLTask(project, pluginExtension);
        Task copyTask = this.addCopyToLibTask(project, pluginExtension);
        Task runTask = this.addRunLauch4jTask(project, pluginExtension);
        runTask.dependsOn(new Object[]{copyTask});
        runTask.dependsOn(new Object[]{xmlTask});
        Task l4jTask = this.addLaunch4jTask(project, pluginExtension);
        l4jTask.dependsOn(new Object[]{runTask});
        Launch4jPluginExtension ext = (Launch4jPluginExtension)project.getExtensions().getByName("launch4j");
        ext.initExtensionDefaults(project);
    }

    private Task addCreateLaunch4jXMLTask(Project project, Launch4jPluginExtension configuration) {
        CreateLaunch4jXMLTask task = this.makeTask(TASK_XML_GENERATE_NAME, CreateLaunch4jXMLTask.class);
        task.setDescription("Creates XML configuration file used by launch4j to create an windows exe.");
        task.setGroup("launch4j");
        task.getInputs().property("project version", project.getVersion());
        task.getInputs().property("Launch4j extension", (Object)configuration);
        task.getOutputs().file((Object)project.file((Object)configuration.getXmlFileName()));
        return task;
    }

    private Task addCopyToLibTask(Project project, Launch4jPluginExtension configuration) {
        final Sync task = this.makeTask(TASK_LIB_COPY_NAME, Sync.class);
        task.setDescription("Copies the project dependency jars in the lib directory.");
        task.setGroup("launch4j");
        task.into((Object)new Closure<File>(null){

            public File call(Object ... obj) {
                Launch4jPluginExtension ext = (Launch4jPluginExtension)task.getProject().getExtensions().getByName("launch4j");
                return task.getProject().file((Object)(task.getProject().getBuildDir() + "/" + ext.getOutputDir() + "/lib"));
            }
        });
        return task;
    }

    private Task addRunLauch4jTask(Project project, Launch4jPluginExtension configuration) {
        final Exec task = this.makeTask(TASK_RUN_NAME, Exec.class);
        task.setDescription("Runs launch4j to generate an .exe file");
        task.setGroup("launch4j");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Launch4jPluginExtension ext = (Launch4jPluginExtension)task.getProject().getExtensions().getByName("launch4j");
                task.setCommandLine(new Object[]{ext.getLaunch4jCmd(), project.getBuildDir() + "/" + ext.getOutputDir() + "/" + ext.getXmlFileName()});
                task.setWorkingDir((Object)project.file((Object)ext.getChdir()));
            }
        });
        return task;
    }

    private Task addLaunch4jTask(Project project, Launch4jPluginExtension configuration) {
        DefaultTask task = this.makeTask("launch4j");
        task.setDescription("Placeholder task for tasks relating to creating .exe applications with launch4j");
        task.setGroup("launch4j");
        return task;
    }

    private CopySpec configureDistSpec(Project project) {
        CopySpec distSpec = project.copySpec((Closure)new Closure<Object>(null){});
        Jar jar = (Jar)project.getTasks().getByName("jar");
        distSpec.from(new Object[]{jar});
        distSpec.from(new Object[]{project.getConfigurations().getByName("runtime")});
        return distSpec;
    }

    public DefaultTask makeTask(String name) {
        return this.makeTask(name, DefaultTask.class);
    }

    public <T extends Task> T makeTask(String name, Class<T> type) {
        return Launch4jPlugin.makeTask(this.project, name, type);
    }

    public static <T extends Task> T makeTask(Project proj, String name, Class<T> type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", type);
        return (T)proj.task(map, name);
    }
}

