/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.dev;

import groovy.lang.Closure;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraftforge.gradle.CopyInto;
import net.minecraftforge.gradle.common.BasePlugin;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedBase;
import net.minecraftforge.gradle.dev.DevBasePlugin;
import net.minecraftforge.gradle.dev.DevExtension;
import net.minecraftforge.gradle.tasks.DecompileTask;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.abstractutil.DelayedJar;
import net.minecraftforge.gradle.tasks.abstractutil.ExtractTask;
import net.minecraftforge.gradle.tasks.abstractutil.FileFilterTask;
import net.minecraftforge.gradle.tasks.dev.ChangelogTask;
import net.minecraftforge.gradle.tasks.dev.FMLVersionPropTask;
import net.minecraftforge.gradle.tasks.dev.GenBinaryPatches;
import net.minecraftforge.gradle.tasks.dev.GenDevProjectsTask;
import net.minecraftforge.gradle.tasks.dev.GeneratePatches;
import net.minecraftforge.gradle.tasks.dev.ObfuscateTask;
import net.minecraftforge.gradle.tasks.dev.SubprojectTask;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;

public class FmlDevPlugin
extends DevBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ((DevExtension)this.getExtension()).setFmlDir(".");
        this.createJarProcessTasks();
        this.createProjectTasks();
        this.createEclipseTasks();
        this.createMiscTasks();
        this.createSourceCopyTasks();
        this.createPackageTasks();
        DefaultTask task = this.makeTask("setupFML", DefaultTask.class);
        task.dependsOn(new Object[]{"extractFmlSources", "generateProjects", "eclipse", "copyAssets"});
        task.setGroup("FML");
        task = this.makeTask("buildPackages");
        task.dependsOn(new Object[]{"launch4j", "createChangelog", "packageUniversal", "packageInstaller", "packageUserDev", "packageSrc", "genJavadocs"});
        task.setGroup("FML");
        Delete delTask = this.makeTask("cleanDecompile", Delete.class);
        delTask.delete(new Object[]{this.delayedFile("eclipse/Clean/src/main/java")});
        delTask.delete(new Object[]{this.delayedFile("eclipse/FML/src/main/java")});
        delTask.delete(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_fml-{MC_VERSION}.zip")});
        delTask.delete(new Object[]{this.delayedFile("{BUILD_DIR}/fmlTmp/minecraft_patched.zip")});
        delTask.setGroup("Clean");
    }

    protected void createJarProcessTasks() {
        ProcessJarTask task2 = this.makeTask("deobfuscateJar", ProcessJarTask.class);
        task2.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task2.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_fml-{MC_VERSION}.jar"));
        task2.setSrg(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        task2.setExceptorCfg(this.delayedFile("{MAPPINGS_DIR}/joined.exc"));
        task2.setExceptorJson(this.delayedFile("{MAPPINGS_DIR}/exceptor.json"));
        task2.addTransformerClean(this.delayedFile("{FML_DIR}/src/main/resources/fml_at.cfg"));
        task2.setApplyMarkers(true);
        task2.dependsOn(new Object[]{"downloadMcpTools", "mergeJars"});
        DecompileTask task3 = this.makeTask("decompile", DecompileTask.class);
        task3.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_fml-{MC_VERSION}.jar"));
        task3.setOutJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_fml-{MC_VERSION}.zip"));
        task3.setFernFlower(this.delayedFile("{CACHE_DIR}/minecraft/fernflower.jar"));
        task3.setPatch(this.delayedFile("{MAPPINGS_DIR}/patches/minecraft_ff"));
        task3.setAstyleConfig(this.delayedFile("{MAPPINGS_DIR}/astyle.cfg"));
        task3.dependsOn(new Object[]{"downloadMcpTools", "deobfuscateJar"});
        PatchJarTask task4 = this.makeTask("fmlPatchJar", PatchJarTask.class);
        task4.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_fml-{MC_VERSION}.zip"));
        task4.setOutJar(this.delayedFile("{BUILD_DIR}/fmlTmp/minecraft_patched.zip"));
        task4.setInPatches(this.delayedFile("{FML_DIR}/patches/minecraft"));
        task4.setDoesCache(false);
        task4.setMaxFuzz(2);
        task4.dependsOn(new Object[]{"decompile"});
    }

    private void createSourceCopyTasks() {
        ExtractTask task = this.makeTask("extractMcResources", ExtractTask.class);
        task.exclude(JAVA_FILES);
        task.setIncludeEmptyDirs(false);
        task.from(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_fml-{MC_VERSION}.zip"));
        task.into(this.delayedFile("eclipse/Clean/src/main/resources"));
        task.dependsOn(new Object[]{"extractWorkspace", "decompile"});
        Copy copy = this.makeTask("copyStart", Copy.class);
        copy.from(new Object[]{this.delayedFile("{MAPPINGS_DIR}/patches")});
        copy.include(new String[]{"Start.java"});
        copy.into((Object)this.delayedFile("eclipse/Clean/src/main/java"));
        copy.dependsOn(new Object[]{"extractMcResources"});
        task = this.makeTask("extractMcSource", ExtractTask.class);
        task.include(JAVA_FILES);
        task.setIncludeEmptyDirs(false);
        task.from(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_decomp/{MC_VERSION}/minecraft_decomp_fml-{MC_VERSION}.zip"));
        task.into(this.delayedFile("eclipse/Clean/src/main/java"));
        task.dependsOn(new Object[]{"copyStart"});
        task = this.makeTask("extractFmlResources", ExtractTask.class);
        task.exclude(JAVA_FILES);
        task.from(this.delayedFile("{BUILD_DIR}/fmlTmp/minecraft_patched.zip"));
        task.into(this.delayedFile("eclipse/FML/src/main/resources"));
        task.dependsOn(new Object[]{"fmlPatchJar", "extractWorkspace"});
        copy = this.makeTask("copyDeobfData", Copy.class);
        copy.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma")});
        copy.from(new Object[]{this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties")});
        copy.into((Object)this.delayedFile("eclipse/FML/src/main/resources"));
        copy.dependsOn(new Object[]{"extractFmlResources", "compressDeobfData"});
        task = this.makeTask("extractFmlSources", ExtractTask.class);
        task.include(JAVA_FILES);
        task.exclude("cpw/**");
        task.from(this.delayedFile("{BUILD_DIR}/fmlTmp/minecraft_patched.zip"));
        task.into(this.delayedFile("eclipse/FML/src/main/java"));
        task.dependsOn(new Object[]{"copyDeobfData"});
    }

    private void createProjectTasks() {
        GenDevProjectsTask task = this.makeTask("generateProjectClean", GenDevProjectsTask.class);
        task.setTargetDir(this.delayedFile("eclipse/Clean"));
        task.setJson(this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-dev.json"));
        task.dependsOn(new Object[]{"extractNatives"});
        task = this.makeTask("generateProjectFML", GenDevProjectsTask.class);
        task.setJson(this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-dev.json"));
        task.setTargetDir(this.delayedFile("eclipse/FML"));
        task.addSource(this.delayedFile("eclipse/FML/src/main/java"));
        task.addSource(this.delayedFile("{FML_DIR}/src/main/java"));
        task.addResource(this.delayedFile("eclipse/FML/src/main/resources"));
        task.addResource(this.delayedFile("{FML_DIR}/src/main/resources"));
        task.dependsOn(new Object[]{"extractNatives", "createVersionProperties"});
        this.makeTask("generateProjects").dependsOn(new Object[]{"generateProjectClean", "generateProjectFML"});
    }

    private void createEclipseTasks() {
        SubprojectTask task = this.makeTask("eclipseClean", SubprojectTask.class);
        task.setBuildFile(this.delayedFile("eclipse/Clean/build.gradle"));
        task.configureProject(((DevExtension)this.getExtension()).getSubprojects());
        task.configureProject(((DevExtension)this.getExtension()).getCleanProject());
        task.setTasks("eclipse");
        task.dependsOn(new Object[]{"extractMcSource", "generateProjects"});
        task = this.makeTask("eclipseFML", SubprojectTask.class);
        task.setBuildFile(this.delayedFile("eclipse/FML/build.gradle"));
        task.configureProject(((DevExtension)this.getExtension()).getSubprojects());
        task.configureProject(((DevExtension)this.getExtension()).getDirtyProject());
        task.setTasks("eclipse");
        task.dependsOn(new Object[]{"extractFmlSources", "generateProjects"});
        this.makeTask("eclipse").dependsOn(new Object[]{"eclipseClean", "eclipseFML"});
    }

    private void createMiscTasks() {
        GeneratePatches task2 = this.makeTask("genPatches", GeneratePatches.class);
        task2.setPatchDir(this.delayedFile("{FML_DIR}/patches/minecraft"));
        task2.setOriginalDir(this.delayedFile("eclipse/Clean/src/main/java"));
        task2.setChangedDir(this.delayedFile("eclipse/FML/src/main/java"));
        task2.setOriginalPrefix("../src-base/minecraft");
        task2.setChangedPrefix("../src-work/minecraft");
        task2.setGroup("FML");
        Delete clean = this.makeTask("cleanFml", Delete.class);
        clean.delete(new Object[]{"eclipse"});
        clean.setGroup("Clean");
        ObfuscateTask obf = this.makeTask("obfuscateJar", ObfuscateTask.class);
        obf.configureProject(((DevExtension)this.getExtension()).getSubprojects());
        obf.configureProject(((DevExtension)this.getExtension()).getDirtyProject());
        obf.setSrg(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        obf.setExc(this.delayedFile("{MAPPINGS_DIR}/joined.exc"));
        obf.setReverse(true);
        obf.setPreFFJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/minecraft_srg_fml-{MC_VERSION}.jar"));
        obf.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/recomp_obfed.jar"));
        obf.setBuildFile(this.delayedFile("eclipse/FML/build.gradle"));
        obf.setMethodsCsv(this.delayedFile("{MAPPINGS_DIR}/methods.csv"));
        obf.setFieldsCsv(this.delayedFile("{MAPPINGS_DIR}/fields.csv"));
        obf.dependsOn(new Object[]{"generateProjects", "extractFmlSources"});
        GenBinaryPatches task3 = this.makeTask("genBinPatches", GenBinaryPatches.class);
        task3.setCleanClient(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft/{MC_VERSION}/minecraft-{MC_VERSION}.jar"));
        task3.setCleanServer(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_server/{MC_VERSION}/minecraft_server-{MC_VERSION}.jar"));
        task3.setCleanMerged(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_merged/{MC_VERSION}/minecraft_merged-{MC_VERSION}.jar"));
        task3.setDirtyJar(this.delayedFile("{BUILD_DIR}/tmp/recomp_obfed.jar"));
        task3.setDeobfDataLzma(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"));
        task3.setOutJar(this.delayedFile("{BUILD_DIR}/tmp/bin_patches.jar"));
        task3.setSrg(this.delayedFile("{MAPPINGS_DIR}/joined.srg"));
        task3.addPatchList(this.delayedFileTree("{FML_DIR}/patches/minecraft"));
        task3.dependsOn(new Object[]{"obfuscateJar", "compressDeobfData"});
        FMLVersionPropTask prop = this.makeTask("createVersionProperties", FMLVersionPropTask.class);
        prop.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        prop.setOutputFile(this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties"));
    }

    private void createPackageTasks() {
        ChangelogTask log = this.makeTask("createChangelog", ChangelogTask.class);
        log.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        log.setServerRoot(this.delayedString("{JENKINS_SERVER}"));
        log.setJobName(this.delayedString("{JENKINS_JOB}"));
        log.setAuthName(this.delayedString("{JENKINS_AUTH_NAME}"));
        log.setAuthPassword(this.delayedString("{JENKINS_AUTH_PASSWORD}"));
        log.setTargetBuild(this.delayedString("{BUILD_NUM}"));
        log.setOutput(this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt"));
        final DelayedJar uni = this.makeTask("packageUniversal", DelayedJar.class);
        uni.setClassifier("universal");
        uni.getInputs().file((Object)this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-rel.json"));
        uni.getOutputs().upToDateWhen(Constants.CALL_FALSE);
        uni.from(new Object[]{this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar")});
        uni.from(new Object[]{this.delayedFileTree("{FML_DIR}/src/main/resources")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/build/tmp/fmlversion.properties")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        uni.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        uni.from(new Object[]{this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma")});
        uni.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        uni.exclude(new String[]{"devbinpatches.pack.lzma"});
        uni.setIncludeEmptyDirs(false);
        uni.setManifest((Closure)new Closure<Object>((Object)this.project){

            public Object call() {
                Manifest mani = (Manifest)this.getDelegate();
                mani.getAttributes().put((Object)"Main-Class", (Object)FmlDevPlugin.this.delayedString("{MAIN_CLASS}").call());
                mani.getAttributes().put((Object)"TweakClass", (Object)FmlDevPlugin.this.delayedString("{FML_TWEAK_CLASS}").call());
                mani.getAttributes().put((Object)"Class-Path", (Object)FmlDevPlugin.this.getServerClassPath(FmlDevPlugin.this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-rel.json").call()));
                return null;
            }
        });
        uni.dependsOn(new Object[]{"genBinPatches", "createChangelog", "createVersionProperties"});
        this.project.getArtifacts().add("archives", (Object)uni);
        FileFilterTask task = this.makeTask("generateInstallJson", FileFilterTask.class);
        task.setInputFile(this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-rel.json"));
        task.setOutputFile(this.delayedFile("{BUILD_DIR}/tmp/install_profile.json"));
        task.addReplacement("@minecraft_version@", (Object)this.delayedString("{MC_VERSION}"));
        task.addReplacement("@version@", (Object)this.delayedString("{VERSION}"));
        task.addReplacement("@project@", (Object)this.delayedString("FML"));
        task.addReplacement("@artifact@", (Object)this.delayedString("cpw.mods:fml:{MC_VERSION}-{VERSION}"));
        task.addReplacement("@universal_jar@", new Closure<String>((Object)this.project){

            public String call() {
                return uni.getArchiveName();
            }
        });
        task.addReplacement("@timestamp@", new Closure<String>((Object)this.project){

            public String call() {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date());
            }
        });
        Zip inst = this.makeTask("packageInstaller", Zip.class);
        inst.setClassifier("installer");
        inst.from(new Object[]{new Closure<File>((Object)this.project){

            public File call() {
                return uni.getArchivePath();
            }
        }});
        inst.from(new Object[]{this.delayedFile("{BUILD_DIR}/tmp/install_profile.json")});
        inst.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        inst.from(new Object[]{this.delayedFile("{FML_DIR}/jsons/big_logo.png")});
        inst.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/installer_base.{INSTALLER_VERSION}.jar"), (Closure)new CopyInto("/", "!*.json", "!*.png"));
        inst.dependsOn(new Object[]{"packageUniversal", "downloadBaseInstaller", "generateInstallJson"});
        inst.setExtension("jar");
        this.project.getArtifacts().add("archives", (Object)inst);
        final Zip patchZip = this.makeTask("zipPatches", Zip.class);
        patchZip.from(new Object[]{this.delayedFile("{FML_DIR}/patches/minecraft")});
        patchZip.setArchiveName("fmlpatches.zip");
        final Zip classZip = this.makeTask("jarClasses", Zip.class);
        classZip.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar"), (Closure)new CopyInto("", "**/*.class"));
        classZip.setArchiveName("binaries.jar");
        SubprojectTask javadocJar = this.makeTask("genJavadocs", SubprojectTask.class);
        javadocJar.setBuildFile(this.delayedFile("eclipse/FML/build.gradle"));
        javadocJar.configureProject(((DevExtension)this.getExtension()).getSubprojects());
        javadocJar.configureProject(((DevExtension)this.getExtension()).getDirtyProject());
        javadocJar.setTasks("jar");
        javadocJar.setConfigureTask(new Action<Task>(){

            public void execute(Task obj) {
                Jar task = (Jar)obj;
                File file = FmlDevPlugin.this.delayedFile("{BUILD_DIR}/tmp/javadoc").call();
                task.setDestinationDir(file.getParentFile());
                task.setArchiveName(file.getName());
            }
        });
        Zip userDev = this.makeTask("packageUserDev", Zip.class);
        userDev.setClassifier("userdev");
        userDev.from(new Object[]{this.delayedFile("{FML_DIR}/jsons/{MC_VERSION}-dev.json")});
        userDev.from(new Object[]{this.delayedFile("{BUILD_DIR}/tmp/javadoc")});
        userDev.from(new Object[]{new Closure<File>((Object)this.project){

            public File call() {
                return patchZip.getArchivePath();
            }
        }});
        userDev.from(new Object[]{new Closure<File>((Object)this.project){

            public File call() {
                return classZip.getArchivePath();
            }
        }});
        userDev.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        userDev.from((Object)this.delayedZipTree("{BUILD_DIR}/tmp/bin_patches.jar"), (Closure)new CopyInto("", "devbinpatches.pack.lzma"));
        userDev.from((Object)this.delayedFileTree("{FML_DIR}/src"), (Closure)new CopyInto("src"));
        userDev.from((Object)this.delayedFile("{CACHE_DIR}/minecraft/net/minecraft/minecraft_srg/{MC_VERSION}/deobfuscation_data-{MC_VERSION}.lzma"), (Closure)new CopyInto("src/main/resources/"));
        userDev.from((Object)this.delayedFile("{FML_DIR}/mcp_merge.cfg"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFileTree("{MAPPINGS_DIR}"), (Closure)new CopyInto("conf", "astyle.cfg", "exceptor.json"));
        userDev.from((Object)this.delayedFileTree("{MAPPINGS_DIR}"), (Closure)new CopyInto("mappings", "*.csv", "!packages.csv"));
        userDev.from((Object)this.delayedFile("{MAPPINGS_DIR}/joined.srg"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFile("{MAPPINGS_DIR}/joined.exc"), (Closure)new CopyInto("conf"));
        userDev.from((Object)this.delayedFileTree("{MAPPINGS_DIR}/patches"), (Closure)new CopyInto("conf"));
        userDev.rename("[\\d.]+?-dev\\.json", "dev.json");
        userDev.rename(".+?\\.srg", "packaged.srg");
        userDev.rename(".+?\\.exc", "packaged.exc");
        userDev.setIncludeEmptyDirs(false);
        userDev.dependsOn(new Object[]{"packageUniversal", "zipPatches", "jarClasses"});
        userDev.setExtension("jar");
        this.project.getArtifacts().add("archives", (Object)userDev);
        Zip src = this.makeTask("packageSrc", Zip.class);
        src.setClassifier("src");
        src.from(new Object[]{this.delayedFile("{BUILD_DIR}/distributions/{PROJECT}-{MC_VERSION}-{VERSION}-changelog.txt")});
        src.from(new Object[]{this.delayedFile("{FML_DIR}/LICENSE-fml.txt")});
        src.from(new Object[]{this.delayedFile("{FML_DIR}/CREDITS-fml.txt")});
        src.from((Object)this.delayedFile("{FML_DIR}/install"), (Closure)new CopyInto(null, "!*.gradle"));
        src.from((Object)this.delayedFile("{FML_DIR}/install"), (Closure)new CopyInto(null, "*.gradle").addExpand("version", this.delayedString("{MC_VERSION}-{VERSION}")).addExpand("name", "fml"));
        src.from(new Object[]{this.delayedFile("{FML_DIR}/gradlew")});
        src.from(new Object[]{this.delayedFile("{FML_DIR}/gradlew.bat")});
        src.from((Object)this.delayedFile("{FML_DIR}/gradle/wrapper"), (Closure)new CopyInto("gradle/wrapper"));
        src.rename(".+?\\.gradle", "build.gradle");
        src.dependsOn(new Object[]{"createChangelog"});
        src.setExtension("zip");
        this.project.getArtifacts().add("archives", (Object)src);
    }

    public static String getVersionFromGit(Project project) {
        return FmlDevPlugin.getVersionFromGit(project, project.getProjectDir());
    }

    public static String getVersionFromGit(Project project, File workDir) {
        if (project == null) {
            project = BasePlugin.getProject(null, null);
        }
        String fullVersion = FmlDevPlugin.runGit(project, workDir, "describe", "--long", "--match=[^(jenkins)]*");
        fullVersion = fullVersion.replace('-', '.').replaceAll("[^0-9.]", "");
        String[] pts = fullVersion.split("\\.");
        String major = pts[0];
        String minor = pts[1];
        String revision = pts[2];
        String build = "0";
        if (System.getenv().containsKey("BUILD_NUMBER")) {
            build = System.getenv("BUILD_NUMBER");
        }
        String branch = null;
        if (!System.getenv().containsKey("GIT_BRANCH")) {
            branch = FmlDevPlugin.runGit(project, workDir, "rev-parse", "--abbrev-ref", "HEAD");
        } else {
            branch = System.getenv("GIT_BRANCH");
            branch = branch.substring(branch.lastIndexOf(47) + 1);
        }
        if (branch != null && (branch.equals("master") || branch.equals("HEAD"))) {
            branch = null;
        }
        StringBuilder out = new StringBuilder();
        out.append(DelayedBase.resolve("{MC_VERSION}", project, new DelayedBase.IDelayedResolver[0])).append('-');
        out.append(major).append('.').append(minor).append('.').append(revision).append('.').append(build);
        if (branch != null) {
            out.append('-').append(branch);
        }
        return out.toString();
    }
}

