/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import net.minecraftforge.gradle.extrastuff.ReobfExceptor;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.TaskAction;

public class ObfuscateTask
extends DefaultTask {
    private DelayedFile outJar;
    private DelayedFile preFFJar;
    private DelayedFile srg;
    private DelayedFile exc;
    private boolean reverse;
    private DelayedFile buildFile;
    private DelayedFile methodsCsv;
    private DelayedFile fieldsCsv;

    @TaskAction
    public void doTask() throws IOException {
        this.getLogger().debug("Building child project model...");
        Project childProj = FmlDevPlugin.getProject(this.getBuildFile(), this.getProject());
        AbstractTask compileTask = (AbstractTask)childProj.getTasks().getByName("compileJava");
        AbstractTask jarTask = (AbstractTask)childProj.getTasks().getByName("jar");
        this.getLogger().debug("Executing child Jar task...");
        this.executeTask(jarTask);
        File inJar = (File)jarTask.property("archivePath");
        File srg = this.getSrg();
        if (this.getExc() != null) {
            ReobfExceptor exceptor = new ReobfExceptor();
            exceptor.toReobfJar = inJar;
            exceptor.deobfJar = this.getPreFFJar();
            exceptor.inSrg = srg;
            exceptor.outSrg = new File(this.getTemporaryDir(), "reobf_cls.srg");
            exceptor.excConfig = this.getExc();
            exceptor.fieldCSV = this.getFieldsCsv();
            exceptor.methodCSV = this.getMethodsCsv();
            exceptor.doFirstThings();
            exceptor.buildSrg();
            srg = exceptor.outSrg;
        }
        this.getLogger().debug("Obfuscating jar...");
        this.obfuscate(inJar, (FileCollection)compileTask.property("classpath"), srg);
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    private void obfuscate(File inJar, FileCollection classpath, File srg) throws FileNotFoundException, IOException {
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(Files.newReader((File)srg, (Charset)Charset.defaultCharset()), null, null, this.reverse);
        JarRemapper remapper = new JarRemapper(null, mapping);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        if (classpath != null) {
            inheritanceProviders.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)new URLClassLoader(ObfuscateTask.toUrls(classpath))));
        }
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        File out = this.getOutJar();
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        remapper.remapJar(input, this.getOutJar());
    }

    public static URL[] toUrls(FileCollection collection) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : collection.getFiles()) {
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getPreFFJar() {
        return this.preFFJar.call();
    }

    public void setPreFFJar(DelayedFile preFFJar) {
        this.preFFJar = preFFJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getExc() {
        return this.exc.call();
    }

    public void setExc(DelayedFile exc) {
        this.exc = exc;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public File getBuildFile() {
        return this.buildFile.call();
    }

    public void setBuildFile(DelayedFile buildFile) {
        this.buildFile = buildFile;
    }

    public File getMethodsCsv() {
        return this.methodsCsv.call();
    }

    public void setMethodsCsv(DelayedFile methodsCsv) {
        this.methodsCsv = methodsCsv;
    }

    public File getFieldsCsv() {
        return this.fieldsCsv.call();
    }

    public void setFieldsCsv(DelayedFile fieldsCsv) {
        this.fieldsCsv = fieldsCsv;
    }
}

