/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.abstractutil;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.gradle.common.Constants;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;

public abstract class CachedTask
extends DefaultTask {
    private boolean doesCache = true;
    private final ArrayList<Annotated> cachedList = new ArrayList();
    private final ArrayList<Annotated> inputList = new ArrayList();

    public CachedTask() {
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (f.isAnnotationPresent(Cached.class)) {
                    this.addCachedField(new Annotated(clazz, f.getName()));
                }
                if (!f.isAnnotationPresent(InputFile.class) && !f.isAnnotationPresent(Input.class)) continue;
                this.inputList.add(new Annotated(clazz, f.getName()));
            }
        }
        this.onlyIf((Closure)new Closure<Boolean>((Object)this, (Object)this){
            private static final long serialVersionUID = -1685502083302238195L;

            public Boolean call(Object ... objects) {
                if (!CachedTask.this.doesCache()) {
                    return true;
                }
                if (CachedTask.this.cachedList.isEmpty()) {
                    return true;
                }
                for (Annotated field : CachedTask.this.cachedList) {
                    try {
                        File file = this.getFile(field);
                        if (!file.exists()) {
                            return true;
                        }
                        File hashFile = CachedTask.this.getHashFile(file);
                        if (!hashFile.exists()) {
                            file.delete();
                            return true;
                        }
                        String foundMD5 = Files.toString((File)CachedTask.this.getHashFile(file), (Charset)Charset.defaultCharset());
                        String calcMD5 = CachedTask.this.getHashes(field, CachedTask.this.inputList, this.getDelegate());
                        CachedTask.this.getProject().getLogger().info("Cached file found: " + file);
                        CachedTask.this.getProject().getLogger().info("Checksums found: " + foundMD5);
                        CachedTask.this.getProject().getLogger().info("Checksums calculated: " + calcMD5);
                        if (calcMD5.equals(foundMD5)) continue;
                        CachedTask.this.getProject().getLogger().error(" Corrupted Cache!");
                        file.delete();
                        CachedTask.this.getHashFile(file).delete();
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return true;
                    }
                }
                return false;
            }

            private File getFile(Annotated field) throws IllegalAccessException, NoSuchFieldException {
                Field f = field.taskClass.getDeclaredField(field.fieldName);
                f.setAccessible(true);
                return CachedTask.this.getProject().file(f.get(this.getDelegate()));
            }
        });
    }

    private void addCachedField(final Annotated annot) {
        this.cachedList.add(annot);
        this.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                if (!CachedTask.this.doesCache()) {
                    return;
                }
                try {
                    File outFile = CachedTask.this.getProject().file(annot.getValue(task));
                    if (outFile.exists()) {
                        File hashFile = CachedTask.this.getHashFile(outFile);
                        Files.write((CharSequence)CachedTask.this.getHashes(annot, CachedTask.this.inputList, task), (File)hashFile, (Charset)Charset.defaultCharset());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private File getHashFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".md5");
    }

    private String getHashes(Annotated output, List<Annotated> inputs, Object instance) throws NoSuchFieldException, IllegalAccessException, NoSuchAlgorithmException {
        ArrayList<String> hashes = new ArrayList<String>();
        hashes.add(Constants.hash(this.getProject().file(output.getValue(instance))));
        for (Annotated input : inputs) {
            Field f = input.getField();
            if (f.isAnnotationPresent(InputFile.class)) {
                hashes.add(Constants.hash(this.getProject().file(input.getValue(instance))));
                this.getLogger().info(Constants.hash(this.getProject().file(input.getValue(instance))) + " " + input.getValue(instance));
                continue;
            }
            Object obj = input.getValue(instance);
            if (obj instanceof Closure) {
                obj = ((Closure)obj).call();
            }
            if (obj instanceof String) {
                hashes.add(Constants.hash((String)obj));
                this.getLogger().info(Constants.hash((String)obj) + " " + (String)obj);
                continue;
            }
            if (!(obj instanceof File)) continue;
            File file = (File)obj;
            if (file.isDirectory()) {
                List<File> files = Arrays.asList(file.listFiles());
                Collections.sort(files);
                for (File i : files) {
                    hashes.add(Constants.hash(i));
                    this.getLogger().info(Constants.hash(i) + " " + i);
                }
                continue;
            }
            hashes.add(Constants.hash(file));
            this.getLogger().info(Constants.hash(file) + " " + file);
        }
        return Joiner.on((String)Constants.NEWLINE).join(hashes);
    }

    public boolean doesCache() {
        return this.doesCache;
    }

    public void setDoesCache(boolean cacheStuff) {
        this.doesCache = cacheStuff;
    }

    private class Annotated {
        private final Class<? extends Task> taskClass;
        private final String fieldName;

        private Annotated(Class<? extends Task> taskClass, String fieldName) {
            this.taskClass = taskClass;
            this.fieldName = fieldName;
        }

        protected Field getField() throws NoSuchFieldException {
            return this.taskClass.getDeclaredField(this.fieldName);
        }

        protected Object getValue(Object instance) throws NoSuchFieldException, IllegalAccessException {
            Field f = this.getField();
            f.setAccessible(true);
            return f.get(instance);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Cached {
    }
}

