/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.user;

import groovy.lang.Closure;
import java.io.File;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.tasks.PatchJarTask;
import net.minecraftforge.gradle.tasks.ProcessJarTask;
import net.minecraftforge.gradle.tasks.RemapSourcesTask;
import net.minecraftforge.gradle.user.UserBasePlugin;
import net.minecraftforge.gradle.user.UserExtension;
import org.gradle.api.Task;
import org.gradle.api.tasks.bundling.Zip;

public class ForgeUserPlugin
extends UserBasePlugin {
    @Override
    public void applyPlugin() {
        super.applyPlugin();
        ProcessJarTask procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfBinJar");
        procTask.setInJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}.jar"));
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-mcp.jar"));
        procTask = (ProcessJarTask)this.project.getTasks().getByName("deobfuscateJar");
        procTask.setOutCleanJar(this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-srg.jar"));
        Task task = this.project.getTasks().getByName("setupDecompWorkspace");
        task.dependsOn(new Object[]{"addForgeJavadoc"});
    }

    @Override
    public void afterEvaluate() {
        String depBase = "net.minecraftforge:forge:" + ((UserExtension)this.getExtension()).getApiVersion();
        this.project.getDependencies().add("userDevPackageDepConfig", (Object)(depBase + ":userdev"));
        this.project.getDependencies().add("apiJavaDocsConfig", (Object)(depBase + ":javadoc@zip"));
        super.afterEvaluate();
    }

    @Override
    protected void addATs(ProcessJarTask task) {
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/fml_at.cfg"));
        task.addTransformerClean(this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources/forge_at.cfg"));
    }

    @Override
    protected DelayedFile getBinPatchOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}.jar");
    }

    @Override
    protected DelayedFile getDecompOut() {
        return this.delayedFile("{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-decomp.jar");
    }

    @Override
    protected void doPostDecompTasks(boolean isClean, DelayedFile decompOut) {
        DelayedFile fmled = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-fmled.jar" : "{BUILD_DIR}/decompiled-fmled.jar");
        DelayedFile fmlInjected = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-fmlinjected.jar" : "{BUILD_DIR}/decompiled-fmlinjected.jar");
        DelayedFile remapped = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-mcped.jar" : "{BUILD_DIR}/decompiled-remapped.jar");
        DelayedFile forged = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-src-nojd.jar" : "{BUILD_DIR}/decompiled-forged-nojd.jar");
        DelayedFile forgeJavaDocced = this.delayedFile(isClean ? "{CACHE_DIR}/minecraft/net/minecraftforge/forge/{API_VERSION}/forge-{API_VERSION}-src.jar" : "{BUILD_DIR}/decompiled-forged.jar");
        PatchJarTask fmlPatches = this.makeTask("doFmlPatches", PatchJarTask.class);
        fmlPatches.dependsOn(new Object[]{"decompile"});
        fmlPatches.setInJar(decompOut);
        fmlPatches.setOutJar(fmled);
        fmlPatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/fmlpatches.zip"));
        final Zip inject = this.makeTask("addFmlSources", Zip.class);
        inject.getOutputs().upToDateWhen((Closure)new Closure<Boolean>(null){
            private static final long serialVersionUID = -8480140049890357630L;

            public Boolean call(Object o) {
                return !inject.dependsOnTaskDidWork();
            }
        });
        inject.dependsOn(new Object[]{"doFmlPatches"});
        inject.from(new Object[]{fmled.toZipTree()});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/java")});
        inject.from(new Object[]{this.delayedFile("{BUILD_DIR}/unpacked/src/main/resources")});
        File injectFile = fmlInjected.call();
        inject.setDestinationDir(injectFile.getParentFile());
        inject.setArchiveName(injectFile.getName());
        RemapSourcesTask remap = this.makeTask("remapJar", RemapSourcesTask.class);
        remap.dependsOn(new Object[]{"addFmlSources"});
        remap.setInJar(fmlInjected);
        remap.setOutJar(remapped);
        remap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/fields.csv"));
        remap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/methods.csv"));
        remap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/params.csv"));
        remap.setDoesJavadocs(false);
        PatchJarTask forgePatches = this.makeTask("doForgePatches", PatchJarTask.class);
        forgePatches.dependsOn(new Object[]{"remapJar"});
        forgePatches.setInJar(remapped);
        forgePatches.setOutJar(forged);
        forgePatches.setInPatches(this.delayedFile("{BUILD_DIR}/unpacked/forgepatches.zip"));
        RemapSourcesTask javadocRemap = this.makeTask("addForgeJavadoc", RemapSourcesTask.class);
        javadocRemap.dependsOn(new Object[]{"doForgePatches"});
        javadocRemap.setInJar(forged);
        javadocRemap.setOutJar(forgeJavaDocced);
        javadocRemap.setFieldsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/fields.csv"));
        javadocRemap.setMethodsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/methods.csv"));
        javadocRemap.setParamsCsv(this.delayedFile("{BUILD_DIR}/unpacked/mappings/params.csv"));
        javadocRemap.setDoesJavadocs(true);
        this.project.getDependencies().add("apiSrcConfig", (Object)this.project.files(new Object[]{forgeJavaDocced}));
    }
}

