/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.gradle.JsonUtil;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class GenDevProjectsTask
extends DefaultTask {
    protected DelayedFile targetDir;
    @Input
    protected DelayedFile json;
    private List<DelayedFile> sources = new ArrayList<DelayedFile>();
    private List<DelayedFile> resources = new ArrayList<DelayedFile>();
    private final ArrayList<String> deps = new ArrayList();

    public GenDevProjectsTask() {
        this.getOutputs().file(this.getTargetFile());
    }

    @TaskAction
    public void doTask() throws IOException, InvalidSyntaxException {
        this.parseJson();
        this.writeFile();
    }

    private void parseJson() throws IOException, InvalidSyntaxException {
        JsonRootNode node = Constants.PARSER.parse(Files.newReader((File)this.getJson(), (Charset)Charset.defaultCharset()));
        for (JsonNode lib : node.getArrayNode("libraries")) {
            if (lib.getStringValue("name").contains("fixed") || lib.isNode("natives") || lib.isNode("extract") || lib.isNode("rules") && !JsonUtil.ruleMatches(lib.getArrayNode("rules"))) continue;
            this.deps.add(lib.getStringValue("name"));
        }
    }

    private void writeFile() throws IOException {
        File file = this.getProject().file(this.getTargetFile().call());
        file.getParentFile().mkdirs();
        Files.touch((File)file);
        StringBuilder o = new StringBuilder();
        this.a(o, "apply plugin: 'java' ", "apply plugin: 'eclipse'", "", "sourceCompatibility = '1.6'", "targetCompatibility = '1.6'", "", "repositories", "{", "    maven", "    {", "        name 'forge'", "        url 'http://files.minecraftforge.net/maven'", "    }", "    mavenCentral()", "    maven", "    {", "        name 'minecraft'", "        url 'https://libraries.minecraft.net/'", "    }", "}", "", "dependencies", "{");
        for (String dep : this.deps) {
            o.append("    compile '").append(dep).append('\'').append(Constants.NEWLINE);
        }
        this.a(o, "", "    testCompile 'junit:junit:4.5'", "}", "");
        URI base = this.targetDir.call().toURI();
        if (this.resources.size() > 0 || this.sources.size() > 0) {
            String relative;
            this.a(o, "sourceSets");
            this.a(o, "{");
            this.a(o, "    main");
            this.a(o, "    {");
            if (this.sources.size() > 0) {
                this.a(o, "        java");
                this.a(o, "        {");
                for (DelayedFile src : this.sources) {
                    relative = base.relativize(src.call().toURI()).getPath();
                    o.append("            srcDir '").append(relative).append('\'').append(Constants.NEWLINE);
                }
                this.a(o, "        }");
            }
            if (this.resources.size() > 0) {
                this.a(o, "        resources");
                this.a(o, "        {");
                for (DelayedFile src : this.resources) {
                    relative = base.relativize(src.call().toURI()).getPath();
                    o.append("            srcDir '").append(relative).append('\'').append(Constants.NEWLINE);
                }
                this.a(o, "        }");
            }
            this.a(o, "    }");
            this.a(o, "}");
        }
        Files.write((CharSequence)o.toString(), (File)file, (Charset)Charset.defaultCharset());
    }

    private void a(StringBuilder out, String ... lines) {
        for (String line : lines) {
            out.append(line).append(Constants.NEWLINE);
        }
    }

    private Closure<File> getTargetFile() {
        return new Closure<File>((Object)this){
            private static final long serialVersionUID = -6333350974905684295L;

            public File call() {
                return new File(GenDevProjectsTask.this.getTargetDir(), "build.gradle");
            }

            public File call(Object obj) {
                return new File(GenDevProjectsTask.this.getTargetDir(), "build.gradle");
            }
        };
    }

    public File getTargetDir() {
        return this.targetDir.call();
    }

    public void setTargetDir(DelayedFile targetDir) {
        this.targetDir = targetDir;
    }

    public GenDevProjectsTask addSource(DelayedFile source) {
        this.sources.add(source);
        return this;
    }

    public GenDevProjectsTask addResource(DelayedFile resource) {
        this.resources.add(resource);
        return this;
    }

    public File getJson() {
        return this.json.call();
    }

    public void setJson(DelayedFile json) {
        this.json = json;
    }
}

