/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.launch4j;

import edu.sc.seis.launch4j.Launch4jPluginExtension;
import java.io.File;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateLaunch4jXMLTask
extends DefaultTask {
    private final Pattern VERSION1 = Pattern.compile("\\d+(\\.\\d+){3}");
    private final Pattern VERSION2 = Pattern.compile("\\d+(\\.\\d+){0,2}");

    @OutputFile
    public File getXmlOutFile() {
        return ((Launch4jPluginExtension)this.getProject().getExtensions().getByName("launch4j")).getXmlOutFileForProject(this.getProject());
    }

    @TaskAction
    public void writeXmlConfig() throws ParserConfigurationException, TransformerException {
        Launch4jPluginExtension cfg = (Launch4jPluginExtension)this.getProject().getExtensions().getByName("launch4j");
        File file = this.getXmlOutFile();
        file.getParentFile().mkdirs();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("launch4jConfig");
        doc.appendChild(root);
        this.textElement(doc, root, "dontWrapJar", cfg.getDontWrapJar());
        this.textElement(doc, root, "headerType", cfg.getHeaderType());
        this.textElement(doc, root, "jar", new File(cfg.getJar()).getAbsolutePath());
        this.textElement(doc, root, "outfile", new File(cfg.getOutfile()).getAbsolutePath());
        this.textElement(doc, root, "errTitle", cfg.getErrTitle());
        this.textElement(doc, root, "cmdLine", cfg.getCmdLine());
        this.textElement(doc, root, "chdir", cfg.getChdir());
        this.textElement(doc, root, "priority", cfg.getPriority());
        this.textElement(doc, root, "downloadUrl", cfg.getDownloadUrl());
        this.textElement(doc, root, "supportUrl", cfg.getSupportUrl());
        this.textElement(doc, root, "customProcName", cfg.getCustomProcName());
        this.textElement(doc, root, "stayAlive", cfg.getStayAlive());
        this.textElement(doc, root, "manifest", cfg.getManifest());
        this.textElement(doc, root, "icon", cfg.getIcon());
        Element child = doc.createElement("versionInfo");
        root.appendChild(child);
        this.textElement(doc, child, "fileVersion", this.parseDotVersion(cfg.getVersion()));
        this.textElement(doc, child, "txtFileVersion", cfg.getVersion());
        this.textElement(doc, child, "fileDescription", this.getProject().getName());
        this.textElement(doc, child, "copyright", cfg.getCopyright());
        this.textElement(doc, child, "productVersion", this.parseDotVersion(cfg.getVersion()));
        this.textElement(doc, child, "txtProductVersion", cfg.getVersion());
        this.textElement(doc, child, "productName", this.getProject().getName());
        this.textElement(doc, child, "internalName", this.getProject().getName());
        this.textElement(doc, child, "originalFilename", new File(cfg.getOutfile()).getName());
        child = doc.createElement("jre");
        root.appendChild(child);
        this.textElement(doc, child, "path", cfg.getBundledJrePath());
        this.textElement(doc, child, "minVersion", cfg.getJreMinVersion());
        this.textElement(doc, child, "maxVersion", cfg.getJreMaxVersion());
        this.textElement(doc, child, "opt", cfg.getOpt());
        this.textElement(doc, child, "initialHeapSize", cfg.getInitialHeapSize());
        this.textElement(doc, child, "initialHeapPercent", cfg.getInitialHeapPercent());
        this.textElement(doc, child, "maxHeapSize", cfg.getMaxHeapSize());
        this.textElement(doc, child, "maxHeapPercent", cfg.getMaxHeapPercent());
        if (cfg.getMessagesStartupError() != null || cfg.getMessagesBundledJreError() != null || cfg.getMessagesJreVersionError() != null || cfg.getMessagesLauncherError() != null) {
            child = doc.createElement("messages");
            root.appendChild(child);
            this.textElement(doc, child, "startupErr", cfg.getMessagesStartupError());
            this.textElement(doc, child, "bundledJreErr", cfg.getMessagesBundledJreError());
            this.textElement(doc, child, "jreVersionErr", cfg.getMessagesJreVersionError());
            this.textElement(doc, child, "launcherErr", cfg.getMessagesLauncherError());
        }
        if (cfg.getMutexName() != null || cfg.getWindowTitle() != null) {
            child = doc.createElement("singleInstance");
            root.appendChild(child);
            this.textElement(doc, child, "mutexName", cfg.getMutexName());
            this.textElement(doc, child, "windowTitle", cfg.getWindowTitle());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    private void textElement(Document doc, Element parent, String name, Integer val) {
        if (val == null) {
            return;
        }
        this.textElement(doc, parent, name, val.toString());
    }

    private void textElement(Document doc, Element parent, String name, boolean val) {
        this.textElement(doc, parent, name, val ? "true" : "false");
    }

    private void textElement(Document doc, Element parent, String name, String val) {
        if (val == null || name == null || val.isEmpty()) {
            return;
        }
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(val));
        if (parent != null) {
            parent.appendChild(node);
        }
    }

    private String parseDotVersion(String version) {
        if (this.VERSION1.matcher(version).matches()) {
            return version;
        }
        if (this.VERSION2.matcher(version).matches()) {
            String s = version + ".0";
            while (this.VERSION2.matcher(s).matches()) {
                s = s + ".0";
            }
            return s;
        }
        return "0.0.0.1";
    }
}

