/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.TaskAction;

public class SubprojectTask
extends DefaultTask {
    private DelayedFile buildFile;
    private String tasks;
    private Closure<Object> configureTask;

    @TaskAction
    public void doTask() throws IOException {
        Project childProj = FmlDevPlugin.getProject(this.getBuildFile(), this.getProject());
        for (String task : this.tasks.split(" ")) {
            Set list = childProj.getTasksByName(task, false);
            for (Task t : list) {
                if (this.configureTask != null) {
                    this.configureTask.call((Object)t);
                }
                this.executeTask((AbstractTask)t);
            }
        }
        System.gc();
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    public File getBuildFile() {
        return this.buildFile.call();
    }

    public void setBuildFile(DelayedFile buildFile) {
        this.buildFile = buildFile;
    }

    public String getTasks() {
        return this.tasks;
    }

    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    public Closure<Object> getConfigureTask() {
        return this.configureTask;
    }

    public void setConfigureTask(Closure<Object> configureTask) {
        this.configureTask = configureTask;
    }
}

