/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class SourceCopyTask
extends DefaultTask {
    @InputFiles
    SourceDirectorySet source;
    @Input
    HashMap<String, String> replacements = new HashMap();
    @Input
    ArrayList<String> includes = new ArrayList();
    @OutputDirectory
    DelayedFile output;

    @TaskAction
    public void doTask() throws IOException {
        this.getLogger().info("INPUTS >> " + this.source);
        this.getLogger().info("OUTPUTS >> " + this.getOutput());
        this.getLogger().info("REPLACE >> " + this.replacements);
        PatternSet patterns = new PatternSet();
        patterns.setIncludes((Iterable)this.source.getIncludes());
        patterns.setExcludes((Iterable)this.source.getExcludes());
        File out = this.getOutput();
        if (out.exists()) {
            this.deleteDir(out);
        }
        out.mkdirs();
        out = out.getCanonicalFile();
        for (DirectoryTree dirTree : this.source.getSrcDirTrees()) {
            File dir = dirTree.getDir();
            this.getLogger().info("PARSING DIR >> " + dir);
            if (!dir.exists() || !dir.isDirectory()) continue;
            dir = dir.getCanonicalFile();
            FileTree tree = this.getProject().fileTree((Object)dir).matching(this.source.getFilter()).matching((PatternFilterable)patterns);
            for (File file : tree) {
                if (!this.isIncluded(file)) continue;
                this.getLogger().debug("PARSING FILE IN >> " + file);
                String text = Files.toString((File)file, (Charset)Charsets.UTF_8);
                for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
                    text = text.replaceAll(entry.getKey(), entry.getValue());
                }
                File dest = this.getDest(file, dir, out);
                this.getLogger().debug("PARSING FILE OUT >> " + dest);
                dest.getParentFile().mkdirs();
                dest.createNewFile();
                Files.write((CharSequence)text, (File)dest, (Charset)Charsets.UTF_8);
            }
        }
    }

    private File getDest(File in, File base, File baseOut) throws IOException {
        String relative = in.getCanonicalPath().replace(base.getCanonicalPath(), "");
        return new File(baseOut, relative);
    }

    private boolean isIncluded(File file) throws IOException {
        if (this.includes.isEmpty()) {
            return true;
        }
        String path = file.getCanonicalPath().replace('\\', '/');
        for (String include : this.includes) {
            if (!path.endsWith(include.replace('\\', '/'))) continue;
            return true;
        }
        return false;
    }

    private boolean deleteDir(File dir) {
        File[] files;
        if (dir.exists() && null != (files = dir.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return dir.delete();
    }

    public File getOutput() {
        return this.output.call();
    }

    public void setOutput(DelayedFile output) {
        this.output = output;
    }

    public void setSource(SourceDirectorySet source) {
        this.source = source;
    }

    public FileCollection getSource() {
        return this.source;
    }

    public void replace(String key, String val) {
        this.replacements.put(key, val);
    }

    public void replace(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.replace(Pattern.quote(e.getKey()), e.getValue());
        }
    }

    public HashMap<String, String> getReplacements() {
        return this.replacements;
    }

    public void include(String str) {
        this.includes.add(str);
    }

    public void include(List<String> strs) {
        this.includes.addAll(strs);
    }

    public ArrayList<String> getIncudes() {
        return this.includes;
    }
}

