/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ObfuscateTask
extends DefaultTask {
    private DelayedFile outJar;
    private DelayedFile preFFJar;
    private DelayedFile srg;
    private DelayedFile exc;
    private boolean reverse;
    private DelayedFile buildFile;
    private DelayedFile methodsCsv;
    private DelayedFile fieldsCsv;

    @TaskAction
    public void doTask() throws IOException {
        this.getLogger().debug("Building child project model...");
        Project childProj = FmlDevPlugin.getProject(this.getBuildFile(), this.getProject());
        AbstractTask compileTask = (AbstractTask)childProj.getTasks().getByName("compileJava");
        AbstractTask jarTask = (AbstractTask)childProj.getTasks().getByName("jar");
        this.getLogger().debug("Executing child Jar task...");
        this.executeTask(jarTask);
        File inJar = (File)jarTask.property("archivePath");
        File srg = this.getSrg();
        if (this.getExc() != null) {
            JarInfo new_info = this.readJar(inJar);
            JarInfo old_info = this.readJar(this.getPreFFJar());
            Map<String, String> clsMap = this.createClassMap(new_info.map, new_info.interfaces);
            this.renameAccess(old_info.access);
            Map<String, String> access = this.mergeAccess(new_info.access, old_info.access);
            srg = this.createSrg(srg, clsMap, access);
        }
        this.getLogger().debug("Obfuscating jar...");
        this.obfuscate(inJar, (FileCollection)compileTask.property("classpath"), srg);
    }

    private Map<String, String> mergeAccess(Map<String, AccessInfo> old_data, Map<String, AccessInfo> new_data) {
        Iterator<Map.Entry<String, AccessInfo>> itr = old_data.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, AccessInfo> e = itr.next();
            String key = e.getKey();
            AccessInfo n = new_data.get(key);
            if (n == null || !e.getValue().targetEquals(n)) continue;
            itr.remove();
            new_data.remove(key);
        }
        HashMap matched = Maps.newHashMap();
        itr = old_data.entrySet().iterator();
        block1: while (itr.hasNext()) {
            AccessInfo _old = itr.next().getValue();
            Iterator<Map.Entry<String, AccessInfo>> itr2 = new_data.entrySet().iterator();
            while (itr2.hasNext()) {
                Map.Entry<String, AccessInfo> e2 = itr2.next();
                AccessInfo _new = e2.getValue();
                if (!_old.targetEquals(_new) || !_old.owner.equals(_new.owner) || !_old.desc.equals(_new.desc)) continue;
                matched.put(_old.owner + "/" + _old.name, _new.owner + "/" + _new.name);
                itr.remove();
                itr2.remove();
                continue block1;
            }
        }
        return matched;
    }

    private void renameAccess(Map<String, AccessInfo> data) throws IOException {
        File[] csvs;
        final HashMap renames = Maps.newHashMap();
        for (File f : csvs = new File[]{this.fieldsCsv == null ? null : this.getFieldsCsv(), this.methodsCsv == null ? null : this.getMethodsCsv()}) {
            if (f == null) continue;
            Files.readLines((File)f, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Object>(){

                public boolean processLine(String line) throws IOException {
                    String[] s = line.split(",");
                    renames.put(s[0], s[1]);
                    return true;
                }

                public Object getResult() {
                    return null;
                }
            });
        }
        for (Map.Entry<String, AccessInfo> e : data.entrySet()) {
            AccessInfo i = e.getValue();
            String tmp = (String)renames.get(i.target_name);
            i.target_name = tmp == null ? i.target_name : tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarInfo readJar(File inJar) throws IOException {
        ZipInputStream zip = null;
        try {
            ZipEntry entry;
            try {
                zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(inJar)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            JarInfo reader = new JarInfo();
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                new ClassReader(ByteStreams.toByteArray((InputStream)zip)).accept((ClassVisitor)reader, 0);
            }
            JarInfo jarInfo = reader;
            return jarInfo;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    private void obfuscate(File inJar, FileCollection classpath, File srg) throws FileNotFoundException, IOException {
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(Files.newReader((File)srg, (Charset)Charset.defaultCharset()), null, null, this.reverse);
        JarRemapper remapper = new JarRemapper(null, mapping);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        if (classpath != null) {
            inheritanceProviders.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)new URLClassLoader(ObfuscateTask.toUrls(classpath))));
        }
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        File out = this.getOutJar();
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        remapper.remapJar(input, this.getOutJar());
    }

    private Map<String, String> createClassMap(Map<String, String> markerMap, final List<String> interfaces) throws IOException {
        if (!this.getExc().exists()) {
            return Maps.newHashMap();
        }
        Map excMap = (Map)Files.readLines((File)this.getExc(), (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Map<String, String>>(){
            Map<String, String> tmp = Maps.newHashMap();

            public boolean processLine(String line) throws IOException {
                if (line.contains(".") || !line.contains("=") || line.startsWith("#")) {
                    return true;
                }
                String[] s = line.split("=");
                if (!interfaces.contains(s[0])) {
                    this.tmp.put(s[0], s[1] + "_");
                }
                return true;
            }

            public Map<String, String> getResult() {
                return this.tmp;
            }
        });
        HashMap map = Maps.newHashMap();
        for (Map.Entry e : excMap.entrySet()) {
            String renamed = markerMap.get(e.getValue());
            if (renamed == null) continue;
            map.put(e.getKey(), renamed);
        }
        return map;
    }

    private File createSrg(File base, Map<String, String> map, Map<String, String> access) throws IOException {
        File srg = new File(this.getTemporaryDir(), "reobf_cls.srg");
        if (srg.isFile()) {
            srg.delete();
        }
        String fixed = (String)Files.readLines((File)base, (Charset)Charset.defaultCharset(), (LineProcessor)new SrgLineProcessor(map, access));
        Files.write((byte[])fixed.getBytes(), (File)srg);
        return srg;
    }

    public static URL[] toUrls(FileCollection collection) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : collection.getFiles()) {
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getPreFFJar() {
        return this.preFFJar.call();
    }

    public void setPreFFJar(DelayedFile preFFJar) {
        this.preFFJar = preFFJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getExc() {
        return this.exc.call();
    }

    public void setExc(DelayedFile exc) {
        this.exc = exc;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public File getBuildFile() {
        return this.buildFile.call();
    }

    public void setBuildFile(DelayedFile buildFile) {
        this.buildFile = buildFile;
    }

    public File getMethodsCsv() {
        return this.methodsCsv.call();
    }

    public void setMethodsCsv(DelayedFile methodsCsv) {
        this.methodsCsv = methodsCsv;
    }

    public File getFieldsCsv() {
        return this.fieldsCsv.call();
    }

    public void setFieldsCsv(DelayedFile fieldsCsv) {
        this.fieldsCsv = fieldsCsv;
    }

    private static class AccessInfo {
        public String owner;
        public String name;
        public String desc;
        public int opcode;
        public int access;
        public String target_owner;
        public String target_name;
        public String target_desc;

        public AccessInfo(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public void set(int opcode, String owner, String name, String desc) {
            if (this.opcode != 0) {
                throw new RuntimeException();
            }
            this.opcode = opcode;
            this.target_owner = owner;
            this.target_name = name;
            this.target_desc = desc;
        }

        public String toString() {
            String op = "UNKNOWN_" + this.opcode;
            switch (this.opcode) {
                case 178: {
                    op = "GETSTATIC";
                    break;
                }
                case 179: {
                    op = "PUTSTATIC";
                    break;
                }
                case 180: {
                    op = "GETFIELD";
                    break;
                }
                case 181: {
                    op = "PUTFIELD";
                    break;
                }
                case 182: {
                    op = "INVOKEVIRTUAL";
                    break;
                }
                case 183: {
                    op = "INVOKESPECIAL";
                    break;
                }
                case 184: {
                    op = "INVOKESTATIC";
                    break;
                }
                case 185: {
                    op = "INVOKEINTERFACE";
                }
            }
            return op + " " + this.target_owner + "/" + this.target_name + " " + this.target_desc;
        }

        public boolean targetEquals(AccessInfo o) {
            return this.toString().equals(o.toString());
        }
    }

    private static class JarInfo
    extends ClassVisitor {
        private final Map<String, String> map = Maps.newHashMap();
        private final List<String> interfaces = Lists.newArrayList();
        private final Map<String, AccessInfo> access = Maps.newHashMap();
        private String className;

        public JarInfo() {
            super(262144, null);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] ints) {
            this.className = name;
            if ((access & 0x200) == 512) {
                this.interfaces.add(this.className);
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.equals("__OBFID")) {
                this.map.put(String.valueOf(value) + "_", this.className);
            }
            return null;
        }

        public MethodVisitor visitMethod(int acc, String name, String desc, String signature, String[] exceptions) {
            if (this.className.startsWith("net/minecraft/") && name.startsWith("access$")) {
                String path = this.className + "/" + name + desc;
                final AccessInfo info = new AccessInfo(this.className, name, desc);
                info.access = acc;
                this.access.put(path, info);
                return new MethodVisitor(262144){

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        info.set(opcode, owner, name, desc);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        info.set(opcode, owner, name, desc);
                    }
                };
            }
            return null;
        }
    }

    private static class SrgLineProcessor
    implements LineProcessor<String> {
        Map<String, String> map;
        Map<String, String> access;
        StringBuilder out = new StringBuilder();
        Pattern reg = Pattern.compile("L([^;]+);");

        private SrgLineProcessor(Map<String, String> map, Map<String, String> access) {
            this.map = map;
            this.access = access;
        }

        private String rename(String cls) {
            String rename = this.map.get(cls);
            return rename == null ? cls : rename;
        }

        private String[] rsplit(String value, String delim) {
            int idx = value.lastIndexOf(delim);
            return new String[]{value.substring(0, idx), value.substring(idx + 1)};
        }

        public boolean processLine(String line) throws IOException {
            String[] split = line.split(" ");
            if (split[0].equals("CL:")) {
                split[2] = this.rename(split[2]);
            } else if (split[0].equals("FD:")) {
                String[] s = this.rsplit(split[2], "/");
                split[2] = this.rename(s[0]) + "/" + s[1];
            } else if (split[0].equals("MD:")) {
                String[] s = this.rsplit(split[3], "/");
                split[3] = this.rename(s[0]) + "/" + s[1];
                if (this.access.containsKey(split[3])) {
                    split[3] = this.access.get(split[3]);
                }
                Matcher m = this.reg.matcher(split[4]);
                StringBuffer b = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(b, "L" + this.rename(m.group(1)).replace("$", "\\$") + ";");
                }
                m.appendTail(b);
                split[4] = b.toString();
            }
            this.out.append(StringUtil.joinString(Arrays.asList(split), (String)" ")).append('\n');
            return true;
        }

        public String getResult() {
            return this.out.toString();
        }
    }
}

