/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.Constants;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.patching.ContextualPatch;
import net.minecraftforge.gradle.tasks.abstractutil.EditJarTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;

public class PatchJarTask
extends EditJarTask {
    @InputFiles
    private DelayedFile inPatches;
    @Input
    private int maxFuzz = 0;
    private ContextProvider PROVIDER;

    @Override
    public String asRead(String file) {
        return file;
    }

    @Override
    public void doStuffBefore() throws Throwable {
        this.PROVIDER = new ContextProvider(this.sourceMap);
    }

    @Override
    public void doStuffMiddle() throws Throwable {
        this.getLogger().info("Reading patches");
        ArrayList<PatchedFile> patches = this.readPatches(this.getInPatches());
        boolean fuzzed = false;
        this.getLogger().info("Applying patches");
        Throwable failure = null;
        for (PatchedFile patch : patches) {
            List<ContextualPatch.PatchReport> errors = patch.patch.patch(false);
            for (ContextualPatch.PatchReport report : errors) {
                if (!report.getStatus().isSuccess()) {
                    File reject = patch.makeRejectFile();
                    if (reject.exists()) {
                        reject.delete();
                    }
                    this.getLogger().log(LogLevel.ERROR, "Patching failed: " + this.PROVIDER.strip(report.getTarget()) + " " + report.getFailure().getMessage());
                    int failed = 0;
                    for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                        if (!hunk.getStatus().isSuccess()) {
                            ++failed;
                            this.getLogger().error("  " + hunk.getHunkID() + ": " + (hunk.getFailure() != null ? hunk.getFailure().getMessage() : "") + " @ " + hunk.getIndex());
                            Files.append((CharSequence)String.format("++++ REJECTED PATCH %d\n", hunk.getHunkID()), (File)reject, (Charset)Charsets.UTF_8);
                            Files.append((CharSequence)Joiner.on((char)'\n').join((Iterable)hunk.hunk.lines), (File)reject, (Charset)Charsets.UTF_8);
                            Files.append((CharSequence)String.format("\n++++ END PATCH\n", new Object[0]), (File)reject, (Charset)Charsets.UTF_8);
                            continue;
                        }
                        if (hunk.getStatus() != ContextualPatch.PatchStatus.Fuzzed) continue;
                        this.getLogger().info("  " + hunk.getHunkID() + " fuzzed " + hunk.getFuzz() + "!");
                    }
                    this.getLogger().log(LogLevel.ERROR, "  " + failed + "/" + report.getHunks().size() + " failed");
                    this.getLogger().log(LogLevel.ERROR, "  Rejects written to " + reject.getAbsolutePath());
                    if (failure != null) continue;
                    failure = report.getFailure();
                    continue;
                }
                if (report.getStatus() == ContextualPatch.PatchStatus.Fuzzed) {
                    this.getLogger().log(LogLevel.INFO, "Patching fuzzed: " + this.PROVIDER.strip(report.getTarget()));
                    fuzzed = true;
                    for (ContextualPatch.HunkReport hunk : report.getHunks()) {
                        if (hunk.getStatus() != ContextualPatch.PatchStatus.Fuzzed) continue;
                        this.getLogger().info("  " + hunk.getHunkID() + " fuzzed " + hunk.getFuzz() + "!");
                    }
                    if (failure != null) continue;
                    failure = report.getFailure();
                    continue;
                }
                this.getLogger().info("Patch succeeded: " + this.PROVIDER.strip(report.getTarget()));
            }
        }
        if (fuzzed) {
            this.getLogger().lifecycle("Patches Fuzzed!");
        }
    }

    private ArrayList<PatchedFile> readPatches(FileCollection patchFiles) throws IOException {
        ArrayList<PatchedFile> patches = new ArrayList<PatchedFile>();
        for (File file : patchFiles.getFiles()) {
            if (!file.getPath().endsWith(".patch")) continue;
            patches.add(this.readPatch(file));
        }
        return patches;
    }

    public PatchedFile readPatch(File file) throws IOException {
        this.getLogger().debug("Reading patch file: " + file);
        return new PatchedFile(file);
    }

    public FileCollection getInPatches() {
        File file = this.inPatches.call();
        if (file.isDirectory()) {
            return this.getProject().fileTree((Object)file);
        }
        if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
            return this.getProject().zipTree((Object)file);
        }
        if (file.getName().endsWith(".tar") || file.getName().endsWith(".gz")) {
            return this.getProject().tarTree((Object)file);
        }
        return this.getProject().files(new Object[]{file});
    }

    public void setInPatches(DelayedFile inPatches) {
        this.inPatches = inPatches;
    }

    @Override
    public void doStuffAfter() throws Throwable {
    }

    public int getMaxFuzz() {
        return this.maxFuzz;
    }

    public void setMaxFuzz(int maxFuzz) {
        this.maxFuzz = maxFuzz;
    }

    private class ContextProvider
    implements ContextualPatch.IContextProvider {
        private Map<String, String> fileMap;
        private final int STRIP = 3;

        public ContextProvider(Map<String, String> fileMap) {
            this.fileMap = fileMap;
        }

        public String strip(String target) {
            target = target.replace('\\', '/');
            int index = 0;
            for (int x = 0; x < 3; ++x) {
                index = target.indexOf(47, index) + 1;
            }
            return target.substring(index);
        }

        @Override
        public List<String> getData(String target) {
            if (this.fileMap.containsKey(target = this.strip(target))) {
                String[] lines = this.fileMap.get(target).split("\r\n|\r|\n");
                ArrayList<String> ret = new ArrayList<String>();
                for (String line : lines) {
                    ret.add(line);
                }
                return ret;
            }
            return null;
        }

        @Override
        public void setData(String target, List<String> data) {
            target = this.strip(target);
            this.fileMap.put(target, Joiner.on((String)Constants.NEWLINE).join(data));
        }
    }

    private class PatchedFile {
        public final File fileToPatch;
        public final ContextualPatch patch;

        public PatchedFile(File file) throws IOException {
            this.fileToPatch = file;
            this.patch = ContextualPatch.create(Files.toString((File)file, (Charset)Charset.defaultCharset()), PatchJarTask.this.PROVIDER).setAccessC14N(true).setMaxFuzz(PatchJarTask.this.getMaxFuzz());
        }

        public File makeRejectFile() {
            return new File(this.fileToPatch.getParentFile(), this.fileToPatch.getName() + ".rej");
        }
    }
}

