/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.cloudbees.diff.Diff;
import com.cloudbees.diff.PatchException;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.gradle.delayed.DelayedFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GeneratePatches
extends DefaultTask {
    @InputDirectory
    DelayedFile patchDir;
    @InputDirectory
    DelayedFile changedDir;
    @InputDirectory
    DelayedFile originalDir;
    @Input
    String originalPrefix = "";
    @Input
    String changedPrefix = "";
    private Set<File> created = new HashSet<File>();

    @TaskAction
    public void doTask() throws IOException, PatchException {
        this.created.clear();
        this.getPatchDir().mkdirs();
        this.processDir(this.getOriginalDir());
        this.removeOld(this.getPatchDir());
    }

    private void removeOld(File dir) throws IOException {
        final ArrayList directories = new ArrayList();
        ConfigurableFileTree tree = this.getProject().fileTree((Object)dir);
        tree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dir) {
                directories.add(dir.getFile());
            }

            public void visitFile(FileVisitDetails f) {
                File file = f.getFile();
                if (!GeneratePatches.this.created.contains(file)) {
                    GeneratePatches.this.getLogger().debug("Removed patch: " + f.getRelativePath());
                    file.delete();
                }
            }
        });
        Collections.sort(directories, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int r = o1.compareTo(o2);
                if (r < 0) {
                    return 1;
                }
                if (r > 0) {
                    return -1;
                }
                return 0;
            }
        });
        for (File f : directories) {
            if (f.listFiles().length != 0) continue;
            this.getLogger().debug("Removing empty dir: " + f);
            f.delete();
        }
    }

    public void processDir(File dir) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.processDir(file);
                continue;
            }
            if (!file.getPath().endsWith(".java")) continue;
            this.processFile(file);
        }
    }

    public void processFile(File file) throws IOException {
        this.getLogger().debug("Original File: " + file);
        String relative = file.getAbsolutePath().substring(this.getOriginalDir().getAbsolutePath().length()).replace('\\', '/');
        File patchFile = new File(this.getPatchDir(), relative + ".patch");
        File changedFile = new File(this.getChangedDir(), relative);
        this.getLogger().debug("Changed File: " + changedFile);
        if (!changedFile.exists()) {
            this.getLogger().debug("Changed File does not exist");
            return;
        }
        Diff diff = Diff.diff((File)file, (File)changedFile, (boolean)false);
        if (!diff.isEmpty()) {
            String unidiff = diff.toUnifiedDiff(this.originalPrefix + relative, this.changedPrefix + relative, (Reader)Files.newReader((File)file, (Charset)Charset.defaultCharset()), (Reader)Files.newReader((File)changedFile, (Charset)Charset.defaultCharset()), 3);
            unidiff = unidiff.replace("\r\n", "\n");
            unidiff = unidiff.replace("\n\\ No newline at end of file\n", "\n");
            String olddiff = "";
            if (patchFile.exists()) {
                olddiff = Files.toString((File)patchFile, (Charset)Charset.defaultCharset());
            }
            if (!olddiff.equals(unidiff)) {
                this.getLogger().debug("Writing patch: " + patchFile);
                patchFile.getParentFile().mkdirs();
                Files.touch((File)patchFile);
                Files.write((CharSequence)unidiff, (File)patchFile, (Charset)Charset.defaultCharset());
            } else {
                this.getLogger().debug("Patch did not change");
            }
            this.created.add(patchFile);
        }
    }

    public File getChangedDir() {
        return this.changedDir.call();
    }

    public void setChangedDir(DelayedFile changedDir) {
        this.changedDir = changedDir;
    }

    public File getOriginalDir() {
        return this.originalDir.call();
    }

    public void setOriginalDir(DelayedFile originalDir) {
        this.originalDir = originalDir;
    }

    public File getPatchDir() {
        return this.patchDir.call();
    }

    public void setPatchDir(DelayedFile patchDir) {
        this.patchDir = patchDir;
    }

    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    public void setOriginalPrefix(String originalPrefix) {
        this.originalPrefix = originalPrefix;
    }

    public String getChangedPrefix() {
        return this.changedPrefix;
    }

    public void setChangedPrefix(String changedPrefix) {
        this.changedPrefix = changedPrefix;
    }
}

