/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.version.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Date;
import net.minecraftforge.gradle.common.version.AssetIndex;
import net.minecraftforge.gradle.common.version.Version;
import net.minecraftforge.gradle.common.version.json.DateAdapter;
import net.minecraftforge.gradle.common.version.json.EnumAdaptorFactory;
import net.minecraftforge.gradle.common.version.json.FileAdapter;

public class JsonFactory {
    public static final Gson GSON;

    public static Version loadVersion(File json) throws JsonSyntaxException, JsonIOException, FileNotFoundException {
        return (Version)GSON.fromJson((Reader)new FileReader(json), Version.class);
    }

    public static AssetIndex loadAssetsIndex(File json) throws JsonSyntaxException, JsonIOException, FileNotFoundException {
        return (AssetIndex)GSON.fromJson((Reader)new FileReader(json), AssetIndex.class);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumAdaptorFactory());
        builder.registerTypeAdapter(Date.class, (Object)new DateAdapter());
        builder.registerTypeAdapter(File.class, (Object)new FileAdapter());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        GSON = builder.create();
    }
}

