/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.sourcemanip;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.gradle.StringUtils;
import net.minecraftforge.gradle.common.Constants;

public class FFPatcher {
    static final String MODIFIERS = "public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp";
    public static final Pattern SYNTHETICS = Pattern.compile((String)"(?m)(\\s*// \\$FF: (synthetic|bridge) method(\\r\\n|\\n|\\r)){1,2}\\s*(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<return>.+?) (?<method>.+?)\\((?<arguments>.*)\\)\\s*\\{(\\r\\n|\\n|\\r)\\s*return this\\.(?<method2>.+?)\\((?<arguments2>.*)\\);(\\r\\n|\\n|\\r)\\s*\\}");
    public static final Pattern TYPECAST = Pattern.compile((String)"\\([\\w\\.]+\\)");
    public static final String TRAILING = "(?m)[ \\t]+$";
    public static final String NEWLINES = "(?m)^(\\r\\n|\\r|\\n){2,}";
    public static final Pattern MODIFIERS_REG = Pattern.compile((String)"(public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp)");
    public static final String LIST = ", ";
    public static final Pattern ENUM_CLASS = Pattern.compile((String)"(?m)^[ \t]*(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<type>enum) (?<name>[\\w$]+)(?: implements (?<implements>[\\w$.]+(?:, [\\w$.]+)*))? \\{(?:\\r\\n|\\r|\\n)(?<body>(?:.*(?:\\r\\n|\\n|\\r))*?)(?<end>\\})");
    public static final Pattern ENUM_ENTRIES = Pattern.compile((String)"(?m)^[ \t]+(?<name>[\\w$]+)\\(\"(?:[\\w$]+)\", [0-9]+(?:, (?<body>.*?))?\\)(?<end>(?:;|,)(?:\\r\\n|\\n|\\r)+)");
    public static final String EMPTY_SUPER = "(?m)^[ \t]+super\\(\\);(\\r\\n|\\n|\\r)";
    public static final String TRAILINGZERO = "([0-9]+\\.[0-9]*[1-9])0+([DdFfEe])";
    public static final String CONSTRUCTOR = "(?m)^[ \t]+(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)%s\\((?<parameters>.*?)\\)(?: throws (?<throws>[\\w$.]+(?:, [\\w$.]+)*))? \\{(?:(?<empty>\\}(?:\\r\\n|\\r|\\n)+)|(?:(?<body>(?:\\r\\n|\\r|\\n)(?:.*?(?:\\r\\n|\\r|\\n))*?)(?<end> {3}\\}(?:\\r\\n|\\r|\\n)+)))";
    public static final String ENUM_VALS = "(?m)^[ \t]+// \\$FF: synthetic field(\\r\\n|\\n|\\r) +private static final %s\\[\\] [$\\w\\d]+ = new %s\\[\\]\\{.*?\\};(\\r\\n|\\n|\\r)";
    private static final String CLASS_REGEX = "(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)(?<type>enum|class|interface) (?<name>[\\w$]+)(?: implements (?<implements>[\\w$.]+(?:, [\\w$.]+)*))? \\{";
    private static final String ENUM_ENTRY_REGEX = "(?<name>[\\w$]+)\\(\"(?:[\\w$]+)\", [0-9]+(?:, (?<body>.*?))?\\)(?<end> *(?:;|,|\\{))";
    private static final String CONSTRUCTOR_REGEX = "(?<modifiers>(?:(?:public|protected|private|static|abstract|final|native|synchronized|transient|volatile|strictfp) )*)%s\\((?<parameters>.*?)\\)(?<end>(?: throws (?<throws>[\\w$.]+(?:, [\\w$.]+)*))? *(?:\\{\\}| \\{))";
    private static final String VALUE_FIELD_REGEX = "private static final %s\\[\\] [$\\w\\d]+ = new %s\\[\\]\\{.*?\\};";

    public static String processFile(String fileName, String text) throws IOException {
        StringBuffer out = new StringBuffer();
        Matcher m = SYNTHETICS.matcher((CharSequence)text);
        while (m.find()) {
            m.appendReplacement(out, FFPatcher.synthetic_replacement(m).replace("$", "\\$"));
        }
        m.appendTail(out);
        text = out.toString();
        text = text.replaceAll(TRAILING, "");
        text = text.replaceAll(EMPTY_SUPER, "");
        text = text.replaceAll(TRAILINGZERO, "");
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll((Collection<String>)StringUtils.lines(text));
        int start = 0;
        Pattern classPattern = Pattern.compile((String)CLASS_REGEX);
        Matcher matcher = classPattern.matcher((CharSequence)lines.get(0));
        while (!matcher.find() && start < lines.size()) {
            matcher = classPattern.matcher((CharSequence)lines.get(++start));
        }
        FFPatcher.processClass(lines, "", start + 1, matcher.group("name"), matcher.group("name"));
        text = Joiner.on((String)Constants.NEWLINE).join(lines);
        text = text.replaceAll(NEWLINES, Constants.NEWLINE);
        return text;
    }

    private static void processClass(List<String> lines, String indent, int startIndex, String qualifiedName, String simpleName) {
        Pattern classPattern = Pattern.compile((String)(indent + CLASS_REGEX));
        String newIndent = indent + "   ";
        for (int i = startIndex; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (Strings.isNullOrEmpty((String)line) || line.startsWith("package") || line.startsWith("import")) continue;
            Matcher matcher = classPattern.matcher((CharSequence)line);
            if (matcher.find()) {
                String classPath = qualifiedName + "\\." + matcher.group("name");
                if (matcher.group("type").equals("enum")) {
                    FFPatcher.processEnum(lines, newIndent, i + 1, classPath, matcher.group("name"));
                }
                FFPatcher.processClass(lines, newIndent, i + 1, classPath, matcher.group("name"));
            }
            if (line.startsWith(indent + "}")) break;
        }
    }

    private static void processEnum(List<String> lines, String indent, int startIndex, String qualifiedName, String simpleName) {
        String newIndent = indent + "   ";
        Pattern enumEntry = Pattern.compile((String)(newIndent + ENUM_ENTRY_REGEX));
        Pattern constructor = Pattern.compile((String)(newIndent + String.format(CONSTRUCTOR_REGEX, simpleName)));
        String formatted = newIndent + String.format(VALUE_FIELD_REGEX, qualifiedName, qualifiedName);
        Pattern valueField = Pattern.compile((String)formatted);
        boolean prevSynthetic = false;
        for (int i = startIndex; i < lines.size(); ++i) {
            String newLine = null;
            String line = lines.get(i);
            Matcher matcher = enumEntry.matcher((CharSequence)line);
            if (matcher.find()) {
                String body = matcher.group("body");
                newLine = newIndent + matcher.group("name");
                newLine = Strings.isNullOrEmpty((String)body) ? newLine + matcher.group("end") : newLine + "(" + matcher.group("body") + ")" + matcher.group("end");
            }
            if ((matcher = constructor.matcher((CharSequence)line)).find()) {
                StringBuilder tmp = new StringBuilder();
                tmp.append(newIndent).append(matcher.group("modifiers")).append(simpleName).append("(");
                String[] args = matcher.group("parameters").split(LIST);
                for (int x = 2; x < args.length; ++x) {
                    tmp.append(args[x]).append(x < args.length - 1 ? LIST : "");
                }
                tmp.append(")");
                tmp.append(matcher.group("end"));
                newLine = tmp.toString();
                if (args.length <= 2 && newLine.endsWith("}")) {
                    newLine = "";
                }
            }
            if (prevSynthetic && (matcher = valueField.matcher((CharSequence)line)).find()) {
                newLine = "";
            }
            if (line.contains("// $FF: synthetic field")) {
                newLine = "";
                prevSynthetic = true;
            } else {
                prevSynthetic = false;
            }
            if (newLine != null) {
                lines.set(i, newLine);
            }
            if (line.startsWith(indent + "}")) break;
        }
    }

    private static String synthetic_replacement(Matcher match) {
        String arg2;
        if (!match.group("method").equals(match.group("method2"))) {
            return match.group();
        }
        String arg1 = match.group("arguments");
        if (arg1.equals(arg2 = match.group("arguments2")) && arg1.equals("")) {
            return "";
        }
        String[] args = match.group("arguments").split(LIST);
        for (int x = 0; x < args.length; ++x) {
            args[x] = args[x].split(" ")[1];
        }
        StringBuilder b = new StringBuilder();
        b.append(args[0]);
        for (int x = 1; x < args.length; ++x) {
            b.append(LIST).append(args[x]);
        }
        arg1 = b.toString();
        if (arg1.equals(arg2)) {
            return "";
        }
        return match.group();
    }
}

