/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.user.reobf;

import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import joptsimple.internal.Strings;
import org.gradle.api.Project;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ArtifactSpec {
    private Object baseName;
    private Object appendix;
    private Object version;
    private Object classifier;
    private Object extension;
    private Object archiveName;
    private Object classpath;
    private Project project;
    private boolean archiveSet = false;

    public ArtifactSpec(Project proj) {
        this.project = proj;
    }

    public ArtifactSpec(File file, Project proj) {
        this.archiveName = file.getName();
        this.extension = Files.getFileExtension((String)file.getName());
        this.project = proj;
    }

    public ArtifactSpec(String file, Project proj) {
        this.archiveName = file;
        this.extension = Files.getFileExtension((String)file);
        this.project = proj;
    }

    public ArtifactSpec(PublishArtifact artifact, Project proj) {
        this.baseName = artifact.getName();
        this.classifier = artifact.getClassifier();
        this.extension = artifact.getExtension();
        this.project = proj;
    }

    public ArtifactSpec(final AbstractArchiveTask task) {
        this.project = task.getProject();
        this.baseName = new Closure(null){

            public Object call() {
                return task.getBaseName();
            }
        };
        this.appendix = new Closure(null){

            public Object call() {
                return task.getAppendix();
            }
        };
        this.version = new Closure(null){

            public Object call() {
                return task.getVersion();
            }
        };
        this.classifier = new Closure(null){

            public Object call() {
                return task.getClassifier();
            }
        };
        this.extension = new Closure(null){

            public Object call() {
                return task.getExtension();
            }
        };
        this.classpath = new Closure(null){

            public Object call() {
                return task.getSource();
            }
        };
    }

    public Object getBaseName() {
        return this.baseName;
    }

    public void setBaseName(Object baseName) {
        this.baseName = baseName;
    }

    public Object getAppendix() {
        return this.appendix;
    }

    public void setAppendix(Object appendix) {
        this.appendix = appendix;
    }

    public Object getVersion() {
        return this.version;
    }

    public void setVersion(Object version) {
        this.version = version;
    }

    public Object getClassifier() {
        return this.classifier;
    }

    public void setClassifier(Object classifier) {
        this.classifier = classifier;
    }

    public Object getExtension() {
        return this.extension;
    }

    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public Object getClasspath() {
        if (this.classpath == null) {
            this.classpath = this.project.files(new Object[]{new String[0]});
        }
        return this.classpath;
    }

    public void setClasspath(Object classpath) {
        this.classpath = classpath;
    }

    public boolean isArchiveSet() {
        return this.archiveSet;
    }

    public void setArchiveSet(boolean archiveSet) {
        this.archiveSet = archiveSet;
    }

    public Object getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(Object archiveName) {
        this.archiveName = archiveName;
        this.archiveSet = true;
    }

    protected void resolve() {
        this.baseName = this.resolve(this.baseName, true);
        this.appendix = this.resolve(this.appendix, true);
        this.version = this.resolve(this.version, true);
        this.classifier = this.resolve(this.classifier, true);
        this.extension = this.resolve(this.extension, true);
        if (this.classpath != null) {
            this.classpath = this.project.files(new Object[]{this.classpath});
        }
        if (this.archiveSet) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.baseName);
        if (!Strings.isNullOrEmpty((String)((String)this.appendix))) {
            builder.append('-');
            builder.append(this.appendix);
        }
        if (!Strings.isNullOrEmpty((String)((String)this.version))) {
            builder.append('-');
            builder.append(this.version);
        }
        if (!Strings.isNullOrEmpty((String)((String)this.classifier))) {
            builder.append('-');
            builder.append(this.classifier);
        }
        builder.append('.');
        builder.append(this.extension);
        this.archiveName = builder.toString();
    }

    private Object resolve(Object obj, boolean isString) {
        if (obj instanceof Closure) {
            obj = ((Closure)obj).call();
        }
        if (obj == null) {
            return null;
        }
        if (isString) {
            obj = obj.toString();
        }
        return obj;
    }
}

