/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.tasks.dev;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.minecraftforge.gradle.delayed.DelayedFile;
import net.minecraftforge.gradle.dev.FmlDevPlugin;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.TaskAction;

public class ObfuscateTask
extends DefaultTask {
    private DelayedFile outJar;
    private DelayedFile srg;
    private DelayedFile exc;
    private boolean reverse;
    private DelayedFile buildFile;

    @TaskAction
    public void doTask() throws IOException {
        this.getLogger().debug("Building child project model...");
        Project childProj = FmlDevPlugin.getProject(this.getBuildFile(), this.getProject());
        AbstractTask compileTask = (AbstractTask)childProj.getTasks().getByName("compileJava");
        AbstractTask jarTask = (AbstractTask)childProj.getTasks().getByName("jar");
        this.getLogger().debug("Executing child Jar task...");
        this.executeTask(jarTask);
        File srg = this.getSrg();
        if (this.getExc() != null) {
            srg = this.createSrg(srg, this.getExc());
        }
        this.getLogger().debug("Obfuscating jar...");
        this.obfuscate((File)jarTask.property("archivePath"), (FileCollection)compileTask.property("classpath"), srg);
    }

    private void executeTask(AbstractTask task) {
        for (Object dep : task.getTaskDependencies().getDependencies((Task)task)) {
            this.executeTask((AbstractTask)dep);
        }
        if (!task.getState().getExecuted()) {
            this.getLogger().lifecycle(task.getPath());
            task.execute();
        }
    }

    private void obfuscate(File inJar, FileCollection classpath, File srg) throws FileNotFoundException, IOException {
        JarMapping mapping = new JarMapping();
        mapping.loadMappings(Files.newReader((File)srg, (Charset)Charset.defaultCharset()), null, null, this.reverse);
        JarRemapper remapper = new JarRemapper(null, mapping);
        Jar input = Jar.init((File)inJar);
        JointProvider inheritanceProviders = new JointProvider();
        inheritanceProviders.add((InheritanceProvider)new JarProvider(input));
        if (classpath != null) {
            inheritanceProviders.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)new URLClassLoader(ObfuscateTask.toUrls(classpath))));
        }
        mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
        File out = this.getOutJar();
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        remapper.remapJar(input, this.getOutJar());
    }

    private File createSrg(File base, File exc) throws IOException {
        File srg = new File(this.getTemporaryDir(), "reobf_cls.srg");
        if (srg.isFile()) {
            srg.delete();
        }
        Map map = (Map)Files.readLines((File)exc, (Charset)Charset.defaultCharset(), (LineProcessor)new LineProcessor<Map<String, String>>(){
            Map<String, String> tmp = Maps.newHashMap();

            public boolean processLine(String line) throws IOException {
                if (line.contains(".") || !line.contains("=") || line.startsWith("#")) {
                    return true;
                }
                String[] s = line.split("=");
                this.tmp.put(s[0], s[1] + "_");
                return true;
            }

            public Map<String, String> getResult() {
                return this.tmp;
            }
        });
        String fixed = (String)Files.readLines((File)base, (Charset)Charset.defaultCharset(), (LineProcessor)new SrgLineProcessor(map));
        Files.write((byte[])fixed.getBytes(), (File)srg);
        return srg;
    }

    public static URL[] toUrls(FileCollection collection) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : collection.getFiles()) {
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public File getOutJar() {
        return this.outJar.call();
    }

    public void setOutJar(DelayedFile outJar) {
        this.outJar = outJar;
    }

    public File getSrg() {
        return this.srg.call();
    }

    public void setSrg(DelayedFile srg) {
        this.srg = srg;
    }

    public File getExc() {
        return this.exc.call();
    }

    public void setExc(DelayedFile exc) {
        this.exc = exc;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public File getBuildFile() {
        return this.buildFile.call();
    }

    public void setBuildFile(DelayedFile buildFile) {
        this.buildFile = buildFile;
    }

    private static class SrgLineProcessor
    implements LineProcessor<String> {
        Map<String, String> map;
        StringBuilder out = new StringBuilder();
        Pattern reg = Pattern.compile("L([^;]+);");

        private SrgLineProcessor(Map<String, String> map) {
            this.map = map;
        }

        private String rename(String cls) {
            String rename = this.map.get(cls);
            return rename == null ? cls : rename;
        }

        private String[] rsplit(String value, String delim) {
            int idx = value.lastIndexOf(delim);
            return new String[]{value.substring(0, idx), value.substring(idx + 1)};
        }

        public boolean processLine(String line) throws IOException {
            String[] split = line.split(" ");
            if (split[0].equals("CL:")) {
                split[2] = this.rename(split[2]);
            } else if (split[0].equals("FD:")) {
                String[] s = this.rsplit(split[2], "/");
                split[2] = this.rename(s[0] + "/" + s[1]);
            } else if (split[0].equals("MD:")) {
                String[] s = this.rsplit(split[2], "/");
                split[2] = this.rename(s[0] + "/" + s[1]);
                Matcher m = this.reg.matcher(split[3]);
                StringBuffer b = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(b, "L" + this.rename(m.group(1)) + ";");
                }
                m.appendTail(b);
                split[3] = m.toString();
            }
            this.out.append(StringUtil.joinString(Arrays.asList(split), (String)" ")).append('\n');
            return true;
        }

        public String getResult() {
            return this.out.toString();
        }
    }
}

